/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.clustering;

import java.util.List;
import org.apache.cxf.clustering.SequentialStrategy;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;

public class RetryStrategy
extends SequentialStrategy {
    private int maxNumberOfRetries;
    private int counter;

    @Override
    public List<Endpoint> getAlternateEndpoints(Exchange exchange) {
        return this.getEndpoints(exchange, this.stillTheSameAddress());
    }

    @Override
    protected <T> T getNextAlternate(List<T> alternates) {
        if (!this.stillTheSameAddress() && !alternates.isEmpty()) {
            alternates.remove(0);
        }
        return alternates.isEmpty() ? null : (T)alternates.get(0);
    }

    protected boolean stillTheSameAddress() {
        if (this.maxNumberOfRetries == 0) {
            return true;
        }
        if (++this.counter <= this.maxNumberOfRetries) {
            return true;
        }
        this.counter = 0;
        return false;
    }

    public void setMaxNumberOfRetries(int maxNumberOfRetries) {
        if (maxNumberOfRetries < 0) {
            throw new IllegalArgumentException();
        }
        this.maxNumberOfRetries = maxNumberOfRetries;
    }

    public int getMaxNumberOfRetries() {
        return this.maxNumberOfRetries;
    }
}

