/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2ws.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.model.JavaException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaReturn;
import org.apache.cxf.tools.common.model.JavaType;

public final class JavaFirstUtil {
    private JavaFirstUtil() {
    }

    public static JavaInterface serviceInfo2JavaInf(ServiceInfo service) {
        JavaInterface javaInf = new JavaInterface();
        InterfaceInfo inf = service.getInterface();
        for (OperationInfo op : inf.getOperations()) {
            JavaMethod jm = new JavaMethod();
            Method m = (Method)op.getProperty("operation.method");
            jm.setName(m.getName());
            int i = 0;
            for (Type type : m.getGenericParameterTypes()) {
                JavaParameter jp = new JavaParameter();
                jp.setClassName(JavaFirstUtil.getClassName(type));
                jp.setStyle(JavaType.Style.IN);
                jp.setName("arg" + i++);
                jm.addParameter(jp);
            }
            for (Type type : m.getGenericExceptionTypes()) {
                JavaException jex = new JavaException();
                String className = JavaFirstUtil.getClassName(type);
                jex.setClassName(className);
                jex.setName(className);
                jm.addException(jex);
            }
            JavaReturn jreturn = new JavaReturn();
            jreturn.setClassName(JavaFirstUtil.getClassName(m.getGenericReturnType()));
            jreturn.setStyle(JavaType.Style.OUT);
            jm.setReturn(jreturn);
            String pkg = PackageUtils.getPackageName(m.getDeclaringClass());
            javaInf.setPackageName(pkg.length() == 0 ? "defaultnamespace" : pkg);
            javaInf.addMethod(jm);
            javaInf.setName(inf.getName().getLocalPart());
            jm.getParameterList();
        }
        return javaInf;
    }

    public static String getClassName(Type type) {
        if (type instanceof Class) {
            Class clz = (Class)type;
            if (clz.isArray()) {
                return clz.getComponentType().getName() + "[]";
            }
            return clz.getName();
        }
        if (type instanceof ParameterizedType) {
            return type.toString();
        }
        if (type instanceof GenericArrayType) {
            return type.toString();
        }
        return "";
    }
}

