/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.neuralnet.oned;

import org.apache.commons.math4.neuralnet.FeatureInitializer;
import org.apache.commons.math4.neuralnet.Network;
import org.apache.commons.math4.neuralnet.internal.NeuralNetException;

public class NeuronString {
    private static final int MIN_NEURONS = 2;
    private final Network network;
    private final int size;
    private final boolean wrap;
    private final long[] identifiers;

    NeuronString(boolean wrap, double[][] featuresList) {
        this.size = featuresList.length;
        if (this.size < 2) {
            throw new NeuralNetException("Number {0} is smaller than {1}", this.size, 2);
        }
        this.wrap = wrap;
        int fLen = featuresList[0].length;
        this.network = new Network(0L, fLen);
        this.identifiers = new long[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.identifiers[i] = this.network.createNeuron(featuresList[i]);
        }
        this.createLinks();
    }

    public NeuronString(int num, boolean wrap, FeatureInitializer[] featureInit) {
        if (num < 2) {
            throw new NeuralNetException("Number {0} is smaller than {1}", num, 2);
        }
        this.size = num;
        this.wrap = wrap;
        this.identifiers = new long[num];
        int fLen = featureInit.length;
        this.network = new Network(0L, fLen);
        for (int i = 0; i < num; ++i) {
            double[] features = new double[fLen];
            for (int fIndex = 0; fIndex < fLen; ++fIndex) {
                features[fIndex] = featureInit[fIndex].value();
            }
            this.identifiers[i] = this.network.createNeuron(features);
        }
        this.createLinks();
    }

    public Network getNetwork() {
        return this.network;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isWrapped() {
        return this.wrap;
    }

    public double[] getFeatures(int i) {
        if (i < 0 || i >= this.size) {
            throw new NeuralNetException("Number {0} is out of range [{1}, {2}]", i, 0, this.size - 1);
        }
        return this.network.getNeuron(this.identifiers[i]).getFeatures();
    }

    private void createLinks() {
        int i;
        for (i = 0; i < this.size - 1; ++i) {
            this.network.addLink(this.network.getNeuron(i), this.network.getNeuron(i + 1));
        }
        for (i = this.size - 1; i > 0; --i) {
            this.network.addLink(this.network.getNeuron(i), this.network.getNeuron(i - 1));
        }
        if (this.wrap) {
            this.network.addLink(this.network.getNeuron(0L), this.network.getNeuron(this.size - 1));
            this.network.addLink(this.network.getNeuron(this.size - 1), this.network.getNeuron(0L));
        }
    }
}

