/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.Combinations;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.junit.Assert;
import org.junit.Test;

public class CombinationsTest {
    @Test
    public void testAccessor1() {
        int n = 5;
        int k = 3;
        Assert.assertEquals((long)5L, (long)new Combinations(5, 3).getN());
    }

    @Test
    public void testAccessor2() {
        int n = 5;
        int k = 3;
        Assert.assertEquals((long)3L, (long)new Combinations(5, 3).getK());
    }

    @Test
    public void testLexicographicIterator() {
        this.checkLexicographicIterator(new Combinations(5, 3));
        this.checkLexicographicIterator(new Combinations(6, 4));
        this.checkLexicographicIterator(new Combinations(8, 2));
        this.checkLexicographicIterator(new Combinations(6, 1));
        this.checkLexicographicIterator(new Combinations(3, 3));
        this.checkLexicographicIterator(new Combinations(1, 1));
        this.checkLexicographicIterator(new Combinations(1, 0));
        this.checkLexicographicIterator(new Combinations(0, 0));
        this.checkLexicographicIterator(new Combinations(4, 2));
        this.checkLexicographicIterator(new Combinations(123, 2));
    }

    @Test(expected=DimensionMismatchException.class)
    public void testLexicographicComparatorWrongIterate1() {
        int n = 5;
        int k = 3;
        Comparator comp = new Combinations(5, 3).comparator();
        comp.compare(new int[]{1}, new int[]{0, 1, 2});
    }

    @Test(expected=DimensionMismatchException.class)
    public void testLexicographicComparatorWrongIterate2() {
        int n = 5;
        int k = 3;
        Comparator comp = new Combinations(5, 3).comparator();
        comp.compare(new int[]{0, 1, 2}, new int[]{0, 1, 2, 3});
    }

    @Test(expected=OutOfRangeException.class)
    public void testLexicographicComparatorWrongIterate3() {
        int n = 5;
        int k = 3;
        Comparator comp = new Combinations(5, 3).comparator();
        comp.compare(new int[]{1, 2, 5}, new int[]{0, 1, 2});
    }

    @Test(expected=OutOfRangeException.class)
    public void testLexicographicComparatorWrongIterate4() {
        int n = 5;
        int k = 3;
        Comparator comp = new Combinations(5, 3).comparator();
        comp.compare(new int[]{1, 2, 4}, new int[]{-1, 1, 2});
    }

    @Test
    public void testLexicographicComparator() {
        int n = 5;
        int k = 3;
        Comparator comp = new Combinations(5, 3).comparator();
        Assert.assertEquals((long)1L, (long)comp.compare(new int[]{1, 2, 4}, new int[]{1, 2, 3}));
        Assert.assertEquals((long)-1L, (long)comp.compare(new int[]{0, 1, 4}, new int[]{0, 2, 4}));
        Assert.assertEquals((long)0L, (long)comp.compare(new int[]{1, 3, 4}, new int[]{1, 3, 4}));
    }

    @Test
    public void testLexicographicComparatorUnsorted() {
        int n = 5;
        int k = 3;
        Comparator comp = new Combinations(5, 3).comparator();
        Assert.assertEquals((long)1L, (long)comp.compare(new int[]{1, 4, 2}, new int[]{1, 3, 2}));
        Assert.assertEquals((long)-1L, (long)comp.compare(new int[]{0, 4, 1}, new int[]{0, 4, 2}));
        Assert.assertEquals((long)0L, (long)comp.compare(new int[]{1, 4, 3}, new int[]{1, 3, 4}));
    }

    @Test
    public void testEmptyCombination() {
        Iterator iter = new Combinations(12345, 0).iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        int[] c = (int[])iter.next();
        Assert.assertEquals((long)0L, (long)c.length);
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testFullSetCombination() {
        int n = 67;
        Iterator iter = new Combinations(67, 67).iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        int[] c = (int[])iter.next();
        Assert.assertEquals((long)67L, (long)c.length);
        for (int i = 0; i < 67; ++i) {
            Assert.assertEquals((long)i, (long)c[i]);
        }
        Assert.assertFalse((boolean)iter.hasNext());
    }

    private void checkLexicographicIterator(Combinations c) {
        Comparator comp = c.comparator();
        int n = c.getN();
        int k = c.getK();
        int[] lastIterate = null;
        long numIterates = 0L;
        for (int[] iterate : c) {
            Assert.assertEquals((long)k, (long)iterate.length);
            if (lastIterate != null) {
                Assert.assertTrue((comp.compare(iterate, lastIterate) == 1 ? 1 : 0) != 0);
            }
            for (int i = 1; i < iterate.length; ++i) {
                Assert.assertTrue((iterate[i] > iterate[i - 1] ? 1 : 0) != 0);
            }
            lastIterate = iterate;
            ++numIterates;
        }
        Assert.assertEquals((long)CombinatoricsUtils.binomialCoefficient((int)n, (int)k), (long)numIterates);
    }

    @Test
    public void testCombinationsIteratorFail() {
        try {
            new Combinations(4, 5).iterator();
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            new Combinations(-1, -2).iterator();
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }
}

