/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import org.junit.Assert;
import org.junit.Test;

public class ChiSquaredDistributionTest
extends RealDistributionAbstractTest {
    public ChiSquaredDistribution makeDistribution() {
        return new ChiSquaredDistribution(5.0);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{0.210212602629, 0.554298076728, 0.831211613487, 1.14547622606, 1.61030798696, 20.5150056524, 15.0862724694, 12.832501994, 11.0704976935, 9.23635689978};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.001, 0.01, 0.025, 0.05, 0.1, 0.999, 0.99, 0.975, 0.95, 0.9};
    }

    public double[] makeInverseCumulativeTestPoints() {
        return new double[]{0.0, 0.001, 0.01, 0.025, 0.05, 0.1, 0.999, 0.99, 0.975, 0.95, 0.9, 1.0};
    }

    public double[] makeInverseCumulativeTestValues() {
        return new double[]{0.0, 0.210212602629, 0.554298076728, 0.831211613487, 1.14547622606, 1.61030798696, 20.5150056524, 15.0862724694, 12.832501994, 11.0704976935, 9.23635689978, Double.POSITIVE_INFINITY};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.0115379817652, 0.0415948507811, 0.0665060119842, 0.0919455953114, 0.121472591024, 4.33630076361E-4, 0.00412780610309, 0.00999340341045, 0.0193246438937, 0.0368460089216};
    }

    public void setUp() {
        super.setUp();
        this.setTolerance(1.0E-9);
    }

    @Test
    public void testSmallDf() {
        this.setDistribution((RealDistribution)new ChiSquaredDistribution(0.1));
        this.setTolerance(1.0E-4);
        this.setCumulativeTestPoints(new double[]{1.168926E-60, 1.168926E-40, 1.063132E-32, 1.144775E-26, 1.168926E-20, 5.472917, 2.175255, 1.13438, 0.5318646, 0.1526342});
        this.setInverseCumulativeTestValues(this.getCumulativeTestPoints());
        this.setInverseCumulativeTestPoints(this.getCumulativeTestValues());
        this.verifyCumulativeProbabilities();
        this.verifyInverseCumulativeProbabilities();
    }

    @Test
    public void testDfAccessors() {
        ChiSquaredDistribution distribution = (ChiSquaredDistribution)this.getDistribution();
        Assert.assertEquals((double)5.0, (double)distribution.getDegreesOfFreedom(), (double)Double.MIN_VALUE);
    }

    @Test
    public void testDensity() {
        double[] x = new double[]{-0.1, 1.0E-6, 0.5, 1.0, 2.0, 5.0};
        this.checkDensity(1.0, x, new double[]{0.0, 398.94208093034, 0.43939128947, 0.24197072452, 0.10377687436, 0.01464498256});
        this.checkDensity(0.1, x, new double[]{0.0, 24864.53997, 0.07464238732, 0.03009077718, 0.009447299159, 8.827199396E-4});
        this.checkDensity(2.0, x, new double[]{0.0, 0.49999975, 0.38940039154, 0.30326532986, 0.18393972059, 0.04104249931});
        this.checkDensity(10.0, x, new double[]{0.0, 1.302082682E-27, 6.337896998E-5, 7.897534632E-4, 0.007664155024, 0.06680094289});
    }

    private void checkDensity(double df, double[] x, double[] expected) {
        ChiSquaredDistribution d = new ChiSquaredDistribution(df);
        for (int i = 0; i < x.length; ++i) {
            Assert.assertEquals((double)expected[i], (double)d.density(x[i]), (double)1.0E-5);
        }
    }

    @Test
    public void testMoments() {
        double tol = 1.0E-9;
        ChiSquaredDistribution dist = new ChiSquaredDistribution(1500.0);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)1500.0, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)3000.0, (double)1.0E-9);
        dist = new ChiSquaredDistribution(1.12);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)1.12, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)2.24, (double)1.0E-9);
    }
}

