/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dynamic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.TestBean;
import org.apache.commons.jxpath.ri.model.dynamic.TestDynamicPropertyFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DynamicPropertiesModelTest
extends AbstractJXPathTest {
    private JXPathContext context;

    @Override
    @BeforeEach
    public void setUp() {
        if (this.context == null) {
            this.context = JXPathContext.newContext((Object)new TestBean());
            this.context.setFactory((AbstractFactory)new TestDynamicPropertyFactory());
        }
    }

    @Test
    public void testAttributeName() {
        this.assertXPathValue(this.context, "map[@name = 'Key1']", "Value 1");
        this.assertXPathPointer(this.context, "map[@name = 'Key1']", "/map[@name='Key1']");
        this.assertXPathPointerLenient(this.context, "map[@name = 'Key&quot;&apos;&quot;&apos;1']", "/map[@name='Key&quot;&apos;&quot;&apos;1']");
        this.assertXPathValue(this.context, "/.[@name='map']/Key2/name", "Name 6");
        this.assertXPathPointer(this.context, "/.[@name='map']/Key2/name", "/map[@name='Key2']/name");
        this.assertXPathValue(this.context, "/map[@name='Key2'][@name='name']", "Name 6");
        this.assertXPathPointer(this.context, "/map[@name='Key2'][@name='name']", "/map[@name='Key2']/name");
        this.assertXPathValue(this.context, "/.[@name='map'][@name='Key2'][@name='name']", "Name 6");
        this.assertXPathPointer(this.context, "/.[@name='map'][@name='Key2'][@name='name']", "/map[@name='Key2']/name");
        ((Map)this.context.getValue("map")).put("Key:3", "value3");
        this.assertXPathValueAndPointer(this.context, "/map[@name='Key:3']", "value3", "/map[@name='Key:3']");
        this.assertXPathValueAndPointer(this.context, "/map[@name='Key:4:5']", null, "/map[@name='Key:4:5']");
    }

    @Test
    public void testAxisChild() {
        this.assertXPathValue(this.context, "map/Key1", "Value 1");
        this.assertXPathPointer(this.context, "map/Key1", "/map[@name='Key1']");
        this.assertXPathValue(this.context, "map/Key2/name", "Name 6");
        this.assertXPathPointer(this.context, "map/Key2/name", "/map[@name='Key2']/name");
    }

    @Test
    public void testAxisDescendant() {
        this.assertXPathValue(this.context, "//Key1", "Value 1");
    }

    @Test
    public void testCollectionOfMaps() {
        TestBean bean = (TestBean)this.context.getContextBean();
        ArrayList list = new ArrayList();
        bean.getMap().put("stuff", list);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("fruit", "apple");
        list.add(m);
        m = new HashMap();
        m.put("berry", "watermelon");
        list.add(m);
        m = new HashMap();
        m.put("fruit", "banana");
        list.add(m);
        this.assertXPathValueIterator(this.context, "/map/stuff/fruit", DynamicPropertiesModelTest.list("apple", "banana"));
        this.assertXPathValueIterator(this.context, "/map/stuff[@name='fruit']", DynamicPropertiesModelTest.list("apple", "banana"));
    }

    @Test
    public void testCreatePath() {
        TestBean bean = (TestBean)this.context.getContextBean();
        bean.setMap(null);
        this.assertXPathCreatePath(this.context, "/map[@name='TestKey1']", "", "/map[@name='TestKey1']");
    }

    @Test
    public void testCreatePathAndSetValue() {
        TestBean bean = (TestBean)this.context.getContextBean();
        bean.setMap(null);
        this.assertXPathCreatePathAndSetValue(this.context, "/map[@name='TestKey1']", "Test", "/map[@name='TestKey1']");
    }

    @Test
    public void testCreatePathAndSetValueCollectionElement() {
        TestBean bean = (TestBean)this.context.getContextBean();
        bean.setMap(null);
        this.assertXPathCreatePathAndSetValue(this.context, "/map/TestKey3[2]", "Test1", "/map[@name='TestKey3'][2]");
        this.assertXPathCreatePathAndSetValue(this.context, "/map[@name='TestKey3'][3]", "Test2", "/map[@name='TestKey3'][3]");
    }

    @Test
    public void testCreatePathAndSetValueCreateBean() {
        TestBean bean = (TestBean)this.context.getContextBean();
        bean.setMap(null);
        this.assertXPathCreatePathAndSetValue(this.context, "/map[@name='TestKey2']/int", 4, "/map[@name='TestKey2']/int");
    }

    @Test
    public void testCreatePathAndSetValueNewCollectionElement() {
        TestBean bean = (TestBean)this.context.getContextBean();
        bean.setMap(null);
        this.assertXPathCreatePathAndSetValue(this.context, "/map/TestKey4[1]/int", 2, "/map[@name='TestKey4'][1]/int");
        bean.getMap().remove("TestKey4");
        this.assertXPathCreatePathAndSetValue(this.context, "/map/TestKey4[1]/int", 3, "/map[@name='TestKey4'][1]/int");
    }

    @Test
    public void testCreatePathCollectionElement() {
        TestBean bean = (TestBean)this.context.getContextBean();
        bean.setMap(null);
        this.assertXPathCreatePath(this.context, "/map/TestKey3[2]", null, "/map[@name='TestKey3'][2]");
        this.assertXPathCreatePath(this.context, "/map[@name='TestKey3'][3]", null, "/map[@name='TestKey3'][3]");
    }

    @Test
    public void testCreatePathCreateBean() {
        TestBean bean = (TestBean)this.context.getContextBean();
        bean.setMap(null);
        this.assertXPathCreatePath(this.context, "/map[@name='TestKey2']/int", 1, "/map[@name='TestKey2']/int");
    }

    @Test
    public void testCreatePathNewCollectionElement() {
        TestBean bean = (TestBean)this.context.getContextBean();
        bean.setMap(null);
        this.assertXPathCreatePath(this.context, "/map/TestKey4[1]/int", 1, "/map[@name='TestKey4'][1]/int");
        bean.getMap().remove("TestKey4");
        this.assertXPathCreatePath(this.context, "/map/TestKey4[1]/int", 1, "/map[@name='TestKey4'][1]/int");
    }

    @Test
    public void testMapOfMaps() {
        TestBean bean = (TestBean)this.context.getContextBean();
        HashMap<String, String> fruit = new HashMap<String, String>();
        fruit.put("apple", "green");
        fruit.put("orange", "red");
        HashMap<String, String> meat = new HashMap<String, String>();
        meat.put("pork", "pig");
        meat.put("beef", "cow");
        bean.getMap().put("fruit", fruit);
        bean.getMap().put("meat", meat);
        this.assertXPathPointer(this.context, "//beef", "/map[@name='meat'][@name='beef']");
        this.assertXPathPointer(this.context, "map//apple", "/map[@name='fruit'][@name='apple']");
        this.assertXPathPointerLenient(this.context, "map//banana", "null()");
        this.assertXPathPointerLenient(this.context, "//fruit/pear", "/map[@name='fruit']/pear");
    }

    @Test
    public void testRemovePath() {
        TestBean bean = (TestBean)this.context.getContextBean();
        bean.getMap().put("TestKey1", "test");
        this.context.removePath("map[@name = 'TestKey1']");
        Assertions.assertNull((Object)this.context.getValue("map[@name = 'TestKey1']"), (String)"Remove dynamic property value");
    }

    @Test
    public void testRemovePathArrayElement() {
        TestBean bean = (TestBean)this.context.getContextBean();
        bean.getMap().put("TestKey2", new String[]{"temp1", "temp2"});
        this.context.removePath("map[@name = 'TestKey2'][1]");
        Assertions.assertEquals((Object)"temp2", (Object)this.context.getValue("map[@name = 'TestKey2'][1]"), (String)"Remove dynamic property collection element");
    }

    @Test
    public void testSetCollection() {
        this.context.setValue("map/Key1", (Object)new Integer[]{7, 8});
        this.assertXPathSetValue(this.context, "map/Key1[1]", 9);
    }

    @Test
    public void testSetNewKey() {
        this.assertXPathSetValue(this.context, "map/Key4", 7);
        this.assertXPathPointerLenient(this.context, "//map/Key5", "/map/Key5");
        this.assertXPathSetValue(this.context, "//map/Key5", 8);
    }

    @Test
    public void testSetPrimitiveValue() {
        this.assertXPathSetValue(this.context, "map/Key1", 6);
    }
}

