/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.Assert;
import org.junit.Test;

public class BlockTest
extends JexlTestCase {
    public BlockTest() {
        super("BlockTest");
    }

    @Test
    public void testBlockSimple() throws Exception {
        JexlScript e = this.JEXL.createScript("if (true) { 'hello'; }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is wrong", (Object)"hello", (Object)o);
    }

    @Test
    public void testBlockExecutesAll() throws Exception {
        JexlScript e = this.JEXL.createScript("if (true) { x = 'Hello'; y = 'World';}");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"First result is wrong", (Object)"Hello", (Object)jc.get("x"));
        Assert.assertEquals((String)"Second result is wrong", (Object)"World", (Object)jc.get("y"));
        Assert.assertEquals((String)"Block result is wrong", (Object)"World", (Object)o);
    }

    @Test
    public void testEmptyBlock() throws Exception {
        JexlScript e = this.JEXL.createScript("if (true) { }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertNull((String)"Result is wrong", (Object)o);
    }

    @Test
    public void testBlockLastExecuted01() throws Exception {
        JexlScript e = this.JEXL.createScript("if (true) { x = 1; } else { x = 2; }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Block result is wrong", (Object)new Integer(1), (Object)o);
    }

    @Test
    public void testBlockLastExecuted02() throws Exception {
        JexlScript e = this.JEXL.createScript("if (false) { x = 1; } else { x = 2; }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Block result is wrong", (Object)new Integer(2), (Object)o);
    }

    @Test
    public void testNestedBlock() throws Exception {
        JexlScript e = this.JEXL.createScript("if (true) { x = 'hello'; y = 'world'; if (true) { x; } y; }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Block result is wrong", (Object)"world", (Object)o);
    }
}

