/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine;

import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.utils.props.PropertyLoader;

public class SystemPropertyUsageUnitTest
extends TestCase {
    private static final String JCS_DEFAULT_CACHEATTRIBUTES_MAX_OBJECTS = "jcs.default.cacheattributes.MaxObjects";
    private static final int testValue = 6789;
    private CompositeCacheManager manager;

    protected void setUp() throws Exception {
        super.setUp();
        this.manager = CompositeCacheManager.getInstance();
        this.manager.shutDown();
    }

    protected void tearDown() throws Exception {
        if (this.manager != null) {
            this.manager.shutDown();
        }
        System.clearProperty(JCS_DEFAULT_CACHEATTRIBUTES_MAX_OBJECTS);
        super.tearDown();
    }

    public void testSystemPropertyUsage() throws Exception {
        System.setProperty(JCS_DEFAULT_CACHEATTRIBUTES_MAX_OBJECTS, String.valueOf(6789));
        JCS.setConfigFilename((String)"/TestSystemPropertyUsage.ccf");
        CacheAccess jcs = JCS.getInstance((String)"someCacheNotInFile");
        this.manager = CompositeCacheManager.getInstance();
        SystemPropertyUsageUnitTest.assertEquals((String)"System property value is not reflected.", (int)6789, (int)jcs.getCacheAttributes().getMaxObjects());
    }

    public void testSystemPropertyUsage_inactive() throws Exception {
        System.setProperty(JCS_DEFAULT_CACHEATTRIBUTES_MAX_OBJECTS, String.valueOf(6789));
        this.manager = CompositeCacheManager.getUnconfiguredInstance();
        Properties props = PropertyLoader.loadProperties("TestSystemPropertyUsage.ccf");
        this.manager.configure(props, false);
        CacheAccess jcs = JCS.getInstance((String)"someCacheNotInFile");
        SystemPropertyUsageUnitTest.assertEquals((String)"System property value should not be reflected", (int)Integer.parseInt(props.getProperty(JCS_DEFAULT_CACHEATTRIBUTES_MAX_OBJECTS)), (int)jcs.getCacheAttributes().getMaxObjects());
    }
}

