/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.tree.AbstractCombinerTest;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.commons.configuration.tree.OverrideCombiner;
import org.apache.commons.configuration.tree.ViewNode;
import org.junit.Assert;
import org.junit.Test;

public class TestOverrideCombiner
extends AbstractCombinerTest {
    protected NodeCombiner createCombiner() {
        return new OverrideCombiner();
    }

    @Test
    public void testSimpleValues() throws ConfigurationException {
        HierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Wrong number of bgcolors", (long)0L, (long)config.getMaxIndex("gui.bgcolor"));
        Assert.assertEquals((String)"Wrong bgcolor", (Object)"green", (Object)config.getString("gui.bgcolor"));
        Assert.assertEquals((String)"Wrong selcolor", (Object)"yellow", (Object)config.getString("gui.selcolor"));
        Assert.assertEquals((String)"Wrong fgcolor", (Object)"blue", (Object)config.getString("gui.fgcolor"));
        Assert.assertEquals((String)"Wrong level", (long)1L, (long)config.getInt("gui.level"));
    }

    @Test
    public void testAttributes() throws ConfigurationException {
        HierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Wrong value of min attribute", (long)1L, (long)config.getInt("gui.level[@min]"));
        Assert.assertEquals((String)"Wrong value of default attribute", (long)2L, (long)config.getInt("gui.level[@default]"));
        Assert.assertEquals((String)"Wrong number of id attributes", (long)0L, (long)config.getMaxIndex("database.tables.table(0)[@id]"));
        Assert.assertEquals((String)"Wrong value of table id", (long)1L, (long)config.getInt("database.tables.table(0)[@id]"));
    }

    @Test
    public void testOverrideValues() throws ConfigurationException {
        HierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Wrong user", (Object)"Admin", (Object)config.getString("base.services.security.login.user"));
        Assert.assertEquals((String)"Wrong user type", (Object)"default", (Object)config.getString("base.services.security.login.user[@type]"));
        Assert.assertEquals((String)"Wrong password", (Object)"BeamMeUp", (Object)config.getString("base.services.security.login.passwd"));
        Assert.assertEquals((String)"Wrong password type", (Object)"secret", (Object)config.getString("base.services.security.login.passwd[@type]"));
    }

    @Test
    public void testListFromFirstStructure() throws ConfigurationException {
        HierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Wrong number of services", (long)0L, (long)config.getMaxIndex("net.service.url"));
        Assert.assertEquals((String)"Wrong service", (Object)"http://service1.org", (Object)config.getString("net.service.url"));
        Assert.assertFalse((String)"Type attribute available", (boolean)config.containsKey("net.service.url[@type]"));
    }

    @Test
    public void testListFromSecondStructure() throws ConfigurationException {
        HierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Wrong number of servers", (long)3L, (long)config.getMaxIndex("net.server.url"));
        Assert.assertEquals((String)"Wrong server", (Object)"http://testsvr.com", (Object)config.getString("net.server.url(2)"));
    }

    @Test
    public void testCombinedTableNoList() throws ConfigurationException {
        ConfigurationNode tabNode = this.checkTable(this.createCombinedConfiguration());
        Assert.assertTrue((String)"Node is not a view node", (boolean)(tabNode instanceof ViewNode));
    }

    @Test
    public void testCombinedTableList() throws ConfigurationException {
        this.combiner.addListNode("table");
        ConfigurationNode tabNode = this.checkTable(this.createCombinedConfiguration());
        Assert.assertFalse((String)"Node is a view node", (boolean)(tabNode instanceof ViewNode));
    }

    private ConfigurationNode checkTable(HierarchicalConfiguration config) {
        Assert.assertEquals((String)"Wrong number of tables", (long)0L, (long)config.getMaxIndex("database.tables.table"));
        SubnodeConfiguration c = config.configurationAt("database.tables.table");
        Assert.assertEquals((String)"Wrong table name", (Object)"documents", (Object)c.getString("name"));
        Assert.assertEquals((String)"Wrong number of fields", (long)2L, (long)c.getMaxIndex("fields.field.name"));
        Assert.assertEquals((String)"Wrong field", (Object)"docname", (Object)c.getString("fields.field(1).name"));
        List nds = config.getExpressionEngine().query((ConfigurationNode)config.getRoot(), "database.tables.table");
        Assert.assertFalse((String)"No node found", (boolean)nds.isEmpty());
        return (ConfigurationNode)nds.get(0);
    }
}

