/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.XMLConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestHierarchicalXMLConfiguration {
    private static final String TEST_DIR = "conf";
    private static final String TEST_FILENAME = "testHierarchicalXMLConfiguration.xml";
    private static final String TEST_FILENAME2 = "testHierarchicalXMLConfiguration2.xml";
    private static final String TEST_FILE = ConfigurationAssert.getTestFile("testHierarchicalXMLConfiguration.xml").getAbsolutePath();
    private static final String TEST_FILE2 = ConfigurationAssert.getTestFile("testHierarchicalXMLConfiguration2.xml").getAbsolutePath();
    private static final String TEST_FILE3 = ConfigurationAssert.getTestFile("test.xml").getAbsolutePath();
    private static final String TEST_SAVENAME = "testhierarchicalsave.xml";
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private XMLConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.config = new XMLConfiguration();
    }

    private void configTest(XMLConfiguration config) {
        Assert.assertEquals((long)1L, (long)config.getMaxIndex("tables.table"));
        Assert.assertEquals((Object)"system", (Object)config.getProperty("tables.table(0)[@tableType]"));
        Assert.assertEquals((Object)"application", (Object)config.getProperty("tables.table(1)[@tableType]"));
        Assert.assertEquals((Object)"users", (Object)config.getProperty("tables.table(0).name"));
        Assert.assertEquals((Object)"documents", (Object)config.getProperty("tables.table(1).name"));
        Object prop = config.getProperty("tables.table.fields.field.name");
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)10L, (long)((Collection)prop).size());
        prop = config.getProperty("tables.table(0).fields.field.type");
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)5L, (long)((Collection)prop).size());
        prop = config.getProperty("tables.table(1).fields.field.type");
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)5L, (long)((Collection)prop).size());
    }

    @Test
    public void testGetProperty() throws Exception {
        this.config.setFileName(TEST_FILE);
        this.config.load();
        this.configTest(this.config);
    }

    @Test
    public void testLoadURL() throws Exception {
        this.config.load(new File(TEST_FILE).getAbsoluteFile().toURI().toURL());
        this.configTest(this.config);
    }

    @Test
    public void testLoadBasePath1() throws Exception {
        this.config.setBasePath(TEST_DIR);
        this.config.setFileName(TEST_FILENAME);
        this.config.load();
        this.configTest(this.config);
    }

    @Test
    public void testLoadBasePath2() throws Exception {
        this.config.setBasePath(new File(TEST_FILE).getAbsoluteFile().toURI().toURL().toString());
        this.config.setFileName(TEST_FILENAME);
        this.config.load();
        this.configTest(this.config);
    }

    @Test
    public void testXmlNodeTypes() throws Exception {
        int KEY_COUNT = 5;
        this.config.load(new File(TEST_FILE2).getAbsoluteFile().toURI().toURL());
        Assert.assertEquals((String)"Comment in element must not change element value.", (Object)"Case1Text", (Object)this.config.getString("case1"));
        Assert.assertEquals((String)"Comment as sibling must not change element value.", (Object)"Case2Text", (Object)this.config.getString("case2.child"));
        Assert.assertEquals((String)"Comment and use of CDATA must not change element value.", (Object)"Case3Text", (Object)this.config.getString("case3"));
        Assert.assertEquals((String)"Comment and use of PI must not change element value.", (Object)"Case4Text", (Object)this.config.getString("case4"));
        Assert.assertEquals((String)"Comment must not change attribute node value.", (Object)"Case5Text", (Object)this.config.getString("case5[@attr]"));
        Iterator iter = this.config.getKeys();
        int count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        Assert.assertEquals((String)"Config must contain only 5 keys.", (long)5L, (long)count);
    }

    @Test
    public void testSave() throws Exception {
        this.config.setFileName(TEST_FILE3);
        this.config.load();
        File saveFile = this.folder.newFile(TEST_SAVENAME);
        this.config.save(saveFile);
        this.config = new XMLConfiguration();
        this.config.load(saveFile.toURI().toURL());
        Assert.assertEquals((Object)"value", (Object)this.config.getProperty("element"));
        Assert.assertEquals((Object)"I'm complex!", (Object)this.config.getProperty("element2.subelement.subsubelement"));
        Assert.assertEquals((long)8L, (long)this.config.getInt("test.short"));
        Assert.assertEquals((Object)"one", (Object)this.config.getString("list(0).item(0)[@name]"));
        Assert.assertEquals((Object)"two", (Object)this.config.getString("list(0).item(1)"));
        Assert.assertEquals((Object)"six", (Object)this.config.getString("list(1).sublist.item(1)"));
    }

    @Test
    public void testSaveNew() throws Exception {
        this.config.addProperty("connection.url", (Object)"jdbc://mydb:1234");
        this.config.addProperty("connection.user", (Object)"scott");
        this.config.addProperty("connection.passwd", (Object)"tiger");
        this.config.addProperty("connection[@type]", (Object)"system");
        this.config.addProperty("tables.table.name", (Object)"tests");
        this.config.addProperty("tables.table(0).fields.field.name", (Object)"test_id");
        this.config.addProperty("tables.table(0).fields.field(-1).name", (Object)"test_name");
        this.config.addProperty("tables.table(-1).name", (Object)"results");
        this.config.addProperty("tables.table(1).fields.field.name", (Object)"res_id");
        this.config.addProperty("tables.table(1).fields.field(0).type", (Object)"int");
        this.config.addProperty("tables.table(1).fields.field(-1).name", (Object)"value");
        this.config.addProperty("tables.table(1).fields.field(1).type", (Object)"string");
        this.config.addProperty("tables.table(1).fields.field(1)[@null]", (Object)"true");
        File saveFile = this.folder.newFile(TEST_SAVENAME);
        this.config.setFile(saveFile);
        this.config.setRootElementName("myconfig");
        this.config.save();
        this.config = new XMLConfiguration();
        this.config.load(saveFile);
        Assert.assertEquals((long)1L, (long)this.config.getMaxIndex("tables.table.name"));
        Assert.assertEquals((Object)"tests", (Object)this.config.getString("tables.table(0).name"));
        Assert.assertEquals((Object)"test_name", (Object)this.config.getString("tables.table(0).fields.field(1).name"));
        Assert.assertEquals((Object)"int", (Object)this.config.getString("tables.table(1).fields.field(0).type"));
        Assert.assertTrue((boolean)this.config.getBoolean("tables.table(1).fields.field(1)[@null]"));
        Assert.assertEquals((Object)"tiger", (Object)this.config.getString("connection.passwd"));
        Assert.assertEquals((Object)"system", (Object)this.config.getProperty("connection[@type]"));
        Assert.assertEquals((Object)"myconfig", (Object)this.config.getRootElementName());
    }

    @Test
    public void testSaveModified() throws Exception {
        this.config.setFile(new File(TEST_FILE3));
        this.config.load();
        Assert.assertTrue((boolean)this.config.getString("mean").startsWith("This is\n A long story..."));
        Assert.assertTrue((this.config.getString("mean").indexOf("And even longer") > 0 ? 1 : 0) != 0);
        this.config.clearProperty("test.entity[@name]");
        this.config.setProperty("element", (Object)"new value");
        this.config.setProperty("test(0)", (Object)"A <new> value");
        this.config.addProperty("test(1).int", (Object)new Integer(9));
        this.config.addProperty("list(1).sublist.item", (Object)"seven");
        this.config.setProperty("clear", (Object)"yes");
        this.config.setProperty("mean", (Object)"now it's simple");
        this.config.addProperty("[@topattr]", (Object)"available");
        this.config.addProperty("[@topattr]", (Object)"successfull");
        File saveFile = this.folder.newFile(TEST_SAVENAME);
        this.config.save(saveFile);
        this.config = new XMLConfiguration();
        this.config.load(saveFile.getAbsolutePath());
        Assert.assertFalse((boolean)this.config.containsKey("test.entity[@name]"));
        Assert.assertEquals((Object)"1<2", (Object)this.config.getProperty("test.entity"));
        Assert.assertEquals((Object)"new value", (Object)this.config.getString("element"));
        Assert.assertEquals((Object)"A <new> value", (Object)this.config.getProperty("test(0)"));
        Assert.assertEquals((long)8L, (long)this.config.getShort("test(1).short"));
        Assert.assertEquals((long)9L, (long)this.config.getInt("test(1).int"));
        Assert.assertEquals((Object)"six", (Object)this.config.getProperty("list(1).sublist.item(1)"));
        Assert.assertEquals((Object)"seven", (Object)this.config.getProperty("list(1).sublist.item(2)"));
        Assert.assertEquals((Object)"yes", (Object)this.config.getProperty("clear"));
        Assert.assertEquals((Object)"now it's simple", (Object)this.config.getString("mean"));
        Assert.assertEquals((Object)"available", (Object)this.config.getString("[@topattr](0)"));
        Assert.assertEquals((Object)"successfull", (Object)this.config.getString("[@topattr](1)"));
    }

    @Test
    public void testRootElement() throws Exception {
        Assert.assertEquals((Object)"configuration", (Object)this.config.getRootElementName());
        this.config.setRootElementName("newRootName");
        Assert.assertEquals((Object)"newRootName", (Object)this.config.getRootElementName());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetRootElementNameWhenLoadedFromFile() throws Exception {
        this.config.setFile(new File(TEST_FILE3));
        this.config.load();
        Assert.assertEquals((Object)"testconfig", (Object)this.config.getRootElementName());
        this.config.setRootElementName("anotherRootElement");
    }
}

