/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import org.apache.commons.compress.archivers.zip.AsiExtraField;
import org.apache.commons.compress.archivers.zip.UnixStat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AsiExtraFieldTest
implements UnixStat {
    AsiExtraFieldTest() {
    }

    @Test
    void testClone() {
        AsiExtraField s1 = new AsiExtraField();
        s1.setUserId(42);
        s1.setGroupId(12);
        s1.setLinkedFile("foo");
        s1.setMode(420);
        s1.setDirectory(true);
        AsiExtraField s2 = (AsiExtraField)s1.clone();
        Assertions.assertNotSame((Object)s1, (Object)s2);
        Assertions.assertEquals((int)s1.getUserId(), (int)s2.getUserId());
        Assertions.assertEquals((int)s1.getGroupId(), (int)s2.getGroupId());
        Assertions.assertEquals((Object)s1.getLinkedFile(), (Object)s2.getLinkedFile());
        Assertions.assertEquals((int)s1.getMode(), (int)s2.getMode());
        Assertions.assertEquals((Object)s1.isDirectory(), (Object)s2.isDirectory());
    }

    @Test
    void testContent() {
        int i;
        AsiExtraField a = new AsiExtraField();
        a.setMode(83);
        a.setUserId(5);
        a.setGroupId(6);
        byte[] b = a.getLocalFileDataData();
        byte[] expect = new byte[]{-58, 2, 120, -74, 83, -128, 0, 0, 0, 0, 5, 0, 6, 0};
        Assertions.assertEquals((int)expect.length, (int)b.length, (String)"no link");
        for (i = 0; i < expect.length; ++i) {
            Assertions.assertEquals((byte)expect[i], (byte)b[i], (String)("no link, byte " + i));
        }
        a.setLinkedFile("test");
        expect = new byte[]{117, -114, 65, -3, 83, -96, 4, 0, 0, 0, 5, 0, 6, 0, 116, 101, 115, 116};
        b = a.getLocalFileDataData();
        Assertions.assertEquals((int)expect.length, (int)b.length, (String)"no link");
        for (i = 0; i < expect.length; ++i) {
            Assertions.assertEquals((byte)expect[i], (byte)b[i], (String)("no link, byte " + i));
        }
    }

    @Test
    void testModes() {
        AsiExtraField a = new AsiExtraField();
        a.setMode(83);
        Assertions.assertEquals((int)32851, (int)a.getMode(), (String)"plain file");
        a.setDirectory(true);
        Assertions.assertEquals((int)16467, (int)a.getMode(), (String)"directory");
        a.setLinkedFile("test");
        Assertions.assertEquals((int)41043, (int)a.getMode(), (String)"symbolic link");
    }

    @Test
    void testReparse() throws Exception {
        byte[] data1 = new byte[]{-58, 2, 120, -74, 83, -128, 0, 0, 0, 0, 5, 0, 6, 0};
        AsiExtraField a1 = new AsiExtraField();
        a1.parseFromLocalFileData(data1, 0, data1.length);
        Assertions.assertEquals((int)data1.length, (int)a1.getLocalFileDataLength().getValue(), (String)"length plain file");
        Assertions.assertFalse((boolean)a1.isLink(), (String)"plain file, no link");
        Assertions.assertFalse((boolean)a1.isDirectory(), (String)"plain file, no dir");
        Assertions.assertEquals((int)32851, (int)a1.getMode(), (String)"mode plain file");
        Assertions.assertEquals((int)5, (int)a1.getUserId(), (String)"uid plain file");
        Assertions.assertEquals((int)6, (int)a1.getGroupId(), (String)"gid plain file");
        byte[] data2 = new byte[]{117, -114, 65, -3, 83, -96, 4, 0, 0, 0, 5, 0, 6, 0, 116, 101, 115, 116};
        AsiExtraField a2 = new AsiExtraField();
        a2.parseFromLocalFileData(data2, 0, data2.length);
        Assertions.assertEquals((int)data2.length, (int)a2.getLocalFileDataLength().getValue(), (String)"length link");
        Assertions.assertTrue((boolean)a2.isLink(), (String)"link, is link");
        Assertions.assertFalse((boolean)a2.isDirectory(), (String)"link, no dir");
        Assertions.assertEquals((int)41043, (int)a2.getMode(), (String)"mode link");
        Assertions.assertEquals((int)5, (int)a2.getUserId(), (String)"uid link");
        Assertions.assertEquals((int)6, (int)a2.getGroupId(), (String)"gid link");
        Assertions.assertEquals((Object)"test", (Object)a2.getLinkedFile());
        byte[] data3 = new byte[]{-114, 1, -65, 14, 83, 64, 0, 0, 0, 0, 5, 0, 6, 0};
        AsiExtraField a3 = new AsiExtraField();
        a3.parseFromLocalFileData(data3, 0, data3.length);
        Assertions.assertEquals((int)data3.length, (int)a3.getLocalFileDataLength().getValue(), (String)"length dir");
        Assertions.assertFalse((boolean)a3.isLink(), (String)"dir, no link");
        Assertions.assertTrue((boolean)a3.isDirectory(), (String)"dir, is dir");
        Assertions.assertEquals((int)16467, (int)a3.getMode(), (String)"mode dir");
        Assertions.assertEquals((int)5, (int)a3.getUserId(), (String)"uid dir");
        Assertions.assertEquals((int)6, (int)a3.getGroupId(), (String)"gid dir");
        byte[] data4 = new byte[]{0, 0, 0, 0, 83, 64, 0, 0, 0, 0, 5, 0, 6, 0};
        AsiExtraField a4 = new AsiExtraField();
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> a4.parseFromLocalFileData(data4, 0, data4.length), (String)"should raise bad CRC exception");
        Assertions.assertEquals((Object)"Bad CRC checksum, expected 0 instead of ebf018e", (Object)e.getMessage());
    }
}

