/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.modeler.dialog.pref.EncodingSelector;
import org.apache.cayenne.modeler.dialog.pref.GeneralPreferencesView;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.pref.CayennePreferenceEditor;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.pref.PreferenceDetail;
import org.apache.cayenne.pref.PreferenceEditor;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.validation.ValidationException;

public class GeneralPreferences
extends CayenneController {
    public static final String AUTO_LOAD_PROJECT_PREFERENCE = "autoLoadProject";
    public static final String DELETE_PROMPT_PREFERENCE = "deletePrompt";
    public static final String ENCODING_PREFERENCE = "encoding";
    protected GeneralPreferencesView view = new GeneralPreferencesView();
    protected CayennePreferenceEditor editor;
    protected PreferenceDetail autoLoadProjectPreference;
    protected PreferenceDetail classGeneratorPreferences;
    protected PreferenceDetail deletePromptPreference;
    protected ObjectBinding saveIntervalBinding;
    protected ObjectBinding encodingBinding;
    protected ObjectBinding autoLoadProjectBinding;
    protected ObjectBinding deletePromptBinding;

    public GeneralPreferences(PreferenceDialog parentController) {
        super(parentController);
        PreferenceEditor editor = parentController.getEditor();
        if (editor instanceof CayennePreferenceEditor) {
            this.editor = (CayennePreferenceEditor)editor;
            this.view.setEnabled(true);
            this.initBindings();
            this.saveIntervalBinding.updateView();
            this.encodingBinding.updateView();
            this.autoLoadProjectBinding.updateView();
            this.deletePromptBinding.updateView();
        } else {
            this.view.setEnabled(false);
        }
    }

    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        Domain classGeneratorDomain = this.editor.editableInstance(this.getApplication().getPreferenceDomain()).getSubdomain(ClassGenerationAction.class);
        this.classGeneratorPreferences = classGeneratorDomain.getDetail(ENCODING_PREFERENCE, true);
        this.autoLoadProjectPreference = this.editor.editableInstance(this.getApplication().getPreferenceDomain()).getDetail(AUTO_LOAD_PROJECT_PREFERENCE, true);
        this.deletePromptPreference = this.editor.editableInstance(this.getApplication().getPreferenceDomain()).getDetail(DELETE_PROMPT_PREFERENCE, true);
        EncodingSelector encodingSelector = new EncodingSelector(this, this.view.getEncodingSelector());
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        this.saveIntervalBinding = builder.bindToTextField(this.view.getSaveInterval(), "timeInterval");
        this.encodingBinding = builder.bindToProperty(encodingSelector, "classGeneratorPreferences.property[\"encoding\"]", ENCODING_PREFERENCE);
        this.autoLoadProjectBinding = builder.bindToCheckBox(this.view.getAutoLoadProject(), AUTO_LOAD_PROJECT_PREFERENCE);
        this.deletePromptBinding = builder.bindToCheckBox(this.view.getDeletePrompt(), DELETE_PROMPT_PREFERENCE);
    }

    public double getTimeInterval() {
        return (double)this.editor.getSaveInterval() / 1000.0;
    }

    public void setTimeInterval(double d) {
        int ms = (int)(d * 1000.0);
        if (ms < 500) {
            throw new ValidationException("Time interval is too small, minimum allowed is 0.5");
        }
        this.editor.setSaveInterval(ms);
    }

    public boolean getAutoLoadProject() {
        return this.autoLoadProjectPreference.getBooleanProperty(AUTO_LOAD_PROJECT_PREFERENCE);
    }

    public void setAutoLoadProject(boolean autoLoadProject) {
        this.autoLoadProjectPreference.setBooleanProperty(AUTO_LOAD_PROJECT_PREFERENCE, autoLoadProject);
    }

    public boolean getDeletePrompt() {
        return this.deletePromptPreference.getBooleanProperty(DELETE_PROMPT_PREFERENCE);
    }

    public void setDeletePrompt(boolean deletePrompt) {
        this.deletePromptPreference.setBooleanProperty(DELETE_PROMPT_PREFERENCE, deletePrompt);
    }

    public PreferenceDetail getClassGeneratorPreferences() {
        return this.classGeneratorPreferences;
    }
}

