/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.parser.ASTAdd;
import org.apache.cayenne.exp.parser.ASTAnd;
import org.apache.cayenne.exp.parser.ASTBetween;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.parser.ASTDivide;
import org.apache.cayenne.exp.parser.ASTEqual;
import org.apache.cayenne.exp.parser.ASTFalse;
import org.apache.cayenne.exp.parser.ASTGreater;
import org.apache.cayenne.exp.parser.ASTGreaterOrEqual;
import org.apache.cayenne.exp.parser.ASTIn;
import org.apache.cayenne.exp.parser.ASTLess;
import org.apache.cayenne.exp.parser.ASTLessOrEqual;
import org.apache.cayenne.exp.parser.ASTLike;
import org.apache.cayenne.exp.parser.ASTLikeIgnoreCase;
import org.apache.cayenne.exp.parser.ASTList;
import org.apache.cayenne.exp.parser.ASTMultiply;
import org.apache.cayenne.exp.parser.ASTNegate;
import org.apache.cayenne.exp.parser.ASTNot;
import org.apache.cayenne.exp.parser.ASTNotBetween;
import org.apache.cayenne.exp.parser.ASTNotEqual;
import org.apache.cayenne.exp.parser.ASTNotIn;
import org.apache.cayenne.exp.parser.ASTNotLike;
import org.apache.cayenne.exp.parser.ASTNotLikeIgnoreCase;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.ASTOr;
import org.apache.cayenne.exp.parser.ASTSubtract;
import org.apache.cayenne.exp.parser.ASTTrue;
import org.apache.cayenne.exp.parser.SimpleNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionFactory {
    public static final char SPLIT_SEPARATOR = '|';
    private static Class<?>[] typeLookup;
    private static volatile int autoAliasId;

    public static Expression expressionOfType(int type) {
        if (type < 0 || type >= typeLookup.length) {
            throw new ExpressionException("Bad expression type: " + type);
        }
        if (typeLookup[type] == null) {
            throw new ExpressionException("Bad expression type: " + type);
        }
        if (SimpleNode.class.isAssignableFrom(typeLookup[type])) {
            try {
                return (Expression)typeLookup[type].newInstance();
            }
            catch (Exception ex) {
                throw new ExpressionException("Error creating expression", ex);
            }
        }
        throw new ExpressionException("Bad expression type: " + type);
    }

    protected static Object wrapPathOperand(Object op) {
        if (op instanceof Collection) {
            return new ASTList((Collection)op);
        }
        if (op instanceof Object[]) {
            return new ASTList((Object[])op);
        }
        return op;
    }

    public static Expression matchAnyDbExp(Map<String, ?> map, int pairType) {
        ArrayList<Expression> pairs = new ArrayList<Expression>(map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Expression exp = ExpressionFactory.expressionOfType(pairType);
            exp.setOperand(0, new ASTDbPath(entry.getKey()));
            exp.setOperand(1, ExpressionFactory.wrapPathOperand(entry.getValue()));
            pairs.add(exp);
        }
        return ExpressionFactory.joinExp(1, pairs);
    }

    public static Expression matchAllDbExp(Map<String, ?> map, int pairType) {
        ArrayList<Expression> pairs = new ArrayList<Expression>(map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Expression exp = ExpressionFactory.expressionOfType(pairType);
            exp.setOperand(0, new ASTDbPath(entry.getKey()));
            exp.setOperand(1, ExpressionFactory.wrapPathOperand(entry.getValue()));
            pairs.add(exp);
        }
        return ExpressionFactory.joinExp(0, pairs);
    }

    public static Expression matchAnyExp(Map<String, ?> map, int pairType) {
        ArrayList<Expression> pairs = new ArrayList<Expression>(map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Expression exp = ExpressionFactory.expressionOfType(pairType);
            exp.setOperand(0, new ASTObjPath(entry.getKey()));
            exp.setOperand(1, ExpressionFactory.wrapPathOperand(entry.getValue()));
            pairs.add(exp);
        }
        return ExpressionFactory.joinExp(1, pairs);
    }

    public static Expression matchAllExp(String path, Collection values) {
        if (values == null) {
            throw new NullPointerException("Null values collection");
        }
        if (values.size() == 0) {
            return new ASTTrue();
        }
        return ExpressionFactory.matchAllExp(path, values.toArray());
    }

    public static Expression matchAllExp(String path, Object ... values) {
        if (values == null) {
            throw new NullPointerException("Null values collection");
        }
        if (values.length == 0) {
            return new ASTTrue();
        }
        int split = path.indexOf(124);
        ArrayList<Expression> matches = new ArrayList<Expression>(values.length);
        if (split >= 0 && split < path.length() - 1) {
            int splitEnd = path.indexOf(".", split + 1);
            String beforeSplit = split > 0 ? path.substring(0, split) + "." : "";
            String afterSplit = splitEnd > 0 ? "." + path.substring(splitEnd + 1) : "";
            String aliasBase = "split" + autoAliasId++ + "_";
            String splitChunk = splitEnd > 0 ? path.substring(split + 1, splitEnd) : path.substring(split + 1);
            path = split == 0 ? path.substring(1) : path.replace('|', '.');
            int i = 0;
            for (Object value : values) {
                String alias = aliasBase + i;
                String aliasedPath = beforeSplit + alias + afterSplit;
                ++i;
                ASTObjPath pathExp = new ASTObjPath(aliasedPath);
                pathExp.setPathAliases(Collections.singletonMap(alias, splitChunk));
                matches.add(new ASTEqual(pathExp, value));
            }
        } else {
            for (Object value : values) {
                matches.add(new ASTEqual(new ASTObjPath(path), value));
            }
        }
        return ExpressionFactory.joinExp(0, matches);
    }

    public static Expression matchAllExp(Map<String, ?> map, int pairType) {
        ArrayList<Expression> pairs = new ArrayList<Expression>(map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Expression exp = ExpressionFactory.expressionOfType(pairType);
            exp.setOperand(0, new ASTObjPath(entry.getKey()));
            exp.setOperand(1, ExpressionFactory.wrapPathOperand(entry.getValue()));
            pairs.add(exp);
        }
        return ExpressionFactory.joinExp(0, pairs);
    }

    public static Expression matchDbExp(String pathSpec, Object value) {
        return new ASTEqual(new ASTDbPath(pathSpec), value);
    }

    public static Expression noMatchDbExp(String pathSpec, Object value) {
        return new ASTNotEqual(new ASTDbPath(pathSpec), value);
    }

    public static Expression matchExp(String pathSpec, Object value) {
        return new ASTEqual(new ASTObjPath(pathSpec), value);
    }

    public static Expression noMatchExp(String pathSpec, Object value) {
        return new ASTNotEqual(new ASTObjPath(pathSpec), value);
    }

    public static Expression lessExp(String pathSpec, Object value) {
        return new ASTLess(new ASTObjPath(pathSpec), value);
    }

    public static Expression lessDbExp(String pathSpec, Object value) {
        return new ASTLess(new ASTDbPath(pathSpec), value);
    }

    public static Expression lessOrEqualExp(String pathSpec, Object value) {
        return new ASTLessOrEqual(new ASTObjPath(pathSpec), value);
    }

    public static Expression lessOrEqualDbExp(String pathSpec, Object value) {
        return new ASTLessOrEqual(new ASTDbPath(pathSpec), value);
    }

    public static Expression greaterExp(String pathSpec, Object value) {
        return new ASTGreater(new ASTObjPath(pathSpec), value);
    }

    public static Expression greaterDbExp(String pathSpec, Object value) {
        return new ASTGreater(new ASTDbPath(pathSpec), value);
    }

    public static Expression greaterOrEqualExp(String pathSpec, Object value) {
        return new ASTGreaterOrEqual(new ASTObjPath(pathSpec), value);
    }

    public static Expression greaterOrEqualDbExp(String pathSpec, Object value) {
        return new ASTGreaterOrEqual(new ASTDbPath(pathSpec), value);
    }

    public static Expression inExp(String pathSpec, Object ... values) {
        if (values.length == 0) {
            return new ASTFalse();
        }
        return new ASTIn(new ASTObjPath(pathSpec), new ASTList(values));
    }

    public static Expression inDbExp(String pathSpec, Object ... values) {
        if (values.length == 0) {
            return new ASTFalse();
        }
        return new ASTIn(new ASTDbPath(pathSpec), new ASTList(values));
    }

    public static Expression inExp(String pathSpec, Collection<?> values) {
        if (values.isEmpty()) {
            return new ASTFalse();
        }
        return new ASTIn(new ASTObjPath(pathSpec), new ASTList(values));
    }

    public static Expression inDbExp(String pathSpec, Collection<?> values) {
        if (values.isEmpty()) {
            return new ASTFalse();
        }
        return new ASTIn(new ASTDbPath(pathSpec), new ASTList(values));
    }

    public static Expression notInExp(String pathSpec, Collection<?> values) {
        if (values.isEmpty()) {
            return new ASTTrue();
        }
        return new ASTNotIn(new ASTObjPath(pathSpec), new ASTList(values));
    }

    public static Expression notInDbExp(String pathSpec, Collection<?> values) {
        if (values.isEmpty()) {
            return new ASTTrue();
        }
        return new ASTNotIn(new ASTDbPath(pathSpec), new ASTList(values));
    }

    public static Expression notInExp(String pathSpec, Object ... values) {
        if (values.length == 0) {
            return new ASTTrue();
        }
        return new ASTNotIn(new ASTObjPath(pathSpec), new ASTList(values));
    }

    public static Expression notInDbExp(String pathSpec, Object ... values) {
        if (values.length == 0) {
            return new ASTTrue();
        }
        return new ASTNotIn(new ASTDbPath(pathSpec), new ASTList(values));
    }

    public static Expression betweenExp(String pathSpec, Object value1, Object value2) {
        return new ASTBetween(new ASTObjPath(pathSpec), value1, value2);
    }

    public static Expression betweenDbExp(String pathSpec, Object value1, Object value2) {
        return new ASTBetween(new ASTDbPath(pathSpec), value1, value2);
    }

    public static Expression notBetweenExp(String pathSpec, Object value1, Object value2) {
        return new ASTNotBetween(new ASTObjPath(pathSpec), value1, value2);
    }

    public static Expression notBetweenDbExp(String pathSpec, Object value1, Object value2) {
        return new ASTNotBetween(new ASTDbPath(pathSpec), value1, value2);
    }

    public static Expression likeExp(String pathSpec, Object value) {
        return new ASTLike(new ASTObjPath(pathSpec), value);
    }

    public static Expression likeExp(String pathSpec, Object value, char escapeChar) {
        return new ASTLike(new ASTObjPath(pathSpec), value, escapeChar);
    }

    public static Expression likeDbExp(String pathSpec, Object value) {
        return new ASTLike(new ASTDbPath(pathSpec), value);
    }

    public static Expression likeDbExp(String pathSpec, Object value, char escapeChar) {
        return new ASTLike(new ASTDbPath(pathSpec), value, escapeChar);
    }

    public static Expression notLikeExp(String pathSpec, Object value) {
        return new ASTNotLike(new ASTObjPath(pathSpec), value);
    }

    public static Expression notLikeExp(String pathSpec, Object value, char escapeChar) {
        return new ASTNotLike(new ASTObjPath(pathSpec), value, escapeChar);
    }

    public static Expression notLikeDbExp(String pathSpec, Object value) {
        return new ASTNotLike(new ASTDbPath(pathSpec), value);
    }

    public static Expression notLikeDbExp(String pathSpec, Object value, char escapeChar) {
        return new ASTNotLike(new ASTDbPath(pathSpec), value, escapeChar);
    }

    public static Expression likeIgnoreCaseExp(String pathSpec, Object value) {
        return new ASTLikeIgnoreCase(new ASTObjPath(pathSpec), value);
    }

    public static Expression likeIgnoreCaseExp(String pathSpec, Object value, char escapeChar) {
        return new ASTLikeIgnoreCase(new ASTObjPath(pathSpec), value, escapeChar);
    }

    public static Expression likeIgnoreCaseDbExp(String pathSpec, Object value) {
        return new ASTLikeIgnoreCase(new ASTDbPath(pathSpec), value);
    }

    public static Expression likeIgnoreCaseDbExp(String pathSpec, Object value, char escapeChar) {
        return new ASTLikeIgnoreCase(new ASTDbPath(pathSpec), value, escapeChar);
    }

    public static Expression notLikeIgnoreCaseExp(String pathSpec, Object value) {
        return new ASTNotLikeIgnoreCase(new ASTObjPath(pathSpec), value);
    }

    public static Expression notLikeIgnoreCaseExp(String pathSpec, Object value, char escapeChar) {
        return new ASTNotLikeIgnoreCase(new ASTObjPath(pathSpec), value, escapeChar);
    }

    public static Expression notLikeIgnoreCaseDbExp(String pathSpec, Object value) {
        return new ASTNotLikeIgnoreCase(new ASTDbPath(pathSpec), value);
    }

    public static Expression notLikeIgnoreCaseDbExp(String pathSpec, Object value, char escapeChar) {
        return new ASTNotLikeIgnoreCase(new ASTDbPath(pathSpec), value, escapeChar);
    }

    public static Expression expTrue() {
        return new ASTTrue();
    }

    public static Expression expFalse() {
        return new ASTFalse();
    }

    public static Expression joinExp(int type, List<Expression> expressions) {
        int len = expressions.size();
        if (len == 0) {
            return null;
        }
        Expression currentExp = expressions.get(0);
        if (len == 1) {
            return currentExp;
        }
        Expression exp = ExpressionFactory.expressionOfType(type);
        for (int i = 0; i < len; ++i) {
            exp.setOperand(i, expressions.get(i));
        }
        return exp;
    }

    public static Expression matchExp(Persistent object) {
        return ExpressionFactory.matchAllDbExp(object.getObjectId().getIdSnapshot(), 3);
    }

    public static Expression matchAnyExp(List<? extends Persistent> objects) {
        if (objects == null || objects.size() == 0) {
            return ExpressionFactory.expFalse();
        }
        return ExpressionFactory.matchAnyExp(objects.toArray(new Persistent[objects.size()]));
    }

    public static Expression matchAnyExp(Persistent ... objects) {
        if (objects == null || objects.length == 0) {
            return ExpressionFactory.expFalse();
        }
        ArrayList<Expression> pairs = new ArrayList<Expression>(objects.length);
        for (Persistent object : objects) {
            pairs.add(ExpressionFactory.matchExp(object));
        }
        return ExpressionFactory.joinExp(1, pairs);
    }

    static {
        int[] allTypes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 16, 17, 18, 19, 20, 26, 27, 28, 35, 36, 37, 38, 21, 22};
        int max = 0;
        int min = 0;
        int allLen = allTypes.length;
        for (int i = 0; i < allLen; ++i) {
            if (allTypes[i] > max) {
                max = allTypes[i];
                continue;
            }
            if (allTypes[i] >= min) continue;
            min = allTypes[i];
        }
        if (max > 500) {
            throw new RuntimeException("Types values are too big: " + max);
        }
        if (min < 0) {
            throw new RuntimeException("Types values are too small: " + min);
        }
        typeLookup = new Class[max + 1];
        ExpressionFactory.typeLookup[0] = ASTAnd.class;
        ExpressionFactory.typeLookup[1] = ASTOr.class;
        ExpressionFactory.typeLookup[9] = ASTBetween.class;
        ExpressionFactory.typeLookup[35] = ASTNotBetween.class;
        ExpressionFactory.typeLookup[3] = ASTEqual.class;
        ExpressionFactory.typeLookup[4] = ASTNotEqual.class;
        ExpressionFactory.typeLookup[5] = ASTLess.class;
        ExpressionFactory.typeLookup[6] = ASTGreater.class;
        ExpressionFactory.typeLookup[7] = ASTLessOrEqual.class;
        ExpressionFactory.typeLookup[8] = ASTGreaterOrEqual.class;
        ExpressionFactory.typeLookup[10] = ASTIn.class;
        ExpressionFactory.typeLookup[36] = ASTNotIn.class;
        ExpressionFactory.typeLookup[11] = ASTLike.class;
        ExpressionFactory.typeLookup[12] = ASTLikeIgnoreCase.class;
        ExpressionFactory.typeLookup[37] = ASTNotLike.class;
        ExpressionFactory.typeLookup[38] = ASTNotLikeIgnoreCase.class;
        ExpressionFactory.typeLookup[16] = ASTAdd.class;
        ExpressionFactory.typeLookup[17] = ASTSubtract.class;
        ExpressionFactory.typeLookup[18] = ASTMultiply.class;
        ExpressionFactory.typeLookup[19] = ASTDivide.class;
        ExpressionFactory.typeLookup[2] = ASTNot.class;
        ExpressionFactory.typeLookup[20] = ASTNegate.class;
        ExpressionFactory.typeLookup[26] = ASTObjPath.class;
        ExpressionFactory.typeLookup[27] = ASTDbPath.class;
        ExpressionFactory.typeLookup[28] = ASTList.class;
        ExpressionFactory.typeLookup[21] = ASTTrue.class;
        ExpressionFactory.typeLookup[22] = ASTFalse.class;
    }
}

