/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.pref;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.cayenne.modeler.pref._ComponentGeometry;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.pref.PreferenceException;
import org.apache.cayenne.reflect.PropertyUtils;

public class ComponentGeometry
extends _ComponentGeometry {
    public static final String GEOMETRY_PREF_KEY = "geometry";

    public static ComponentGeometry getPreference(Domain domain) {
        return (ComponentGeometry)domain.getDetail(GEOMETRY_PREF_KEY, ComponentGeometry.class, true);
    }

    public void bind(final Window window, int initialWidth, int initialHeight, int maxOffset) {
        this.updateSize(window, initialWidth, initialHeight);
        this.updateLocation(window, maxOffset);
        window.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ComponentGeometry.this.setWidth(new Integer(window.getWidth()));
                ComponentGeometry.this.setHeight(new Integer(window.getHeight()));
            }

            public void componentMoved(ComponentEvent e) {
                ComponentGeometry.this.setX(new Integer(window.getX()));
                ComponentGeometry.this.setY(new Integer(window.getY()));
            }
        });
    }

    public void bindSize(final Window window, int initialWidth, int initialHeight) {
        this.updateSize(window, initialWidth, initialHeight);
        window.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ComponentGeometry.this.setWidth(new Integer(window.getWidth()));
                ComponentGeometry.this.setHeight(new Integer(window.getHeight()));
            }
        });
    }

    public void bindIntProperty(Component component, final String property, int defaultValue) {
        this.updateIntProperty(component, property, defaultValue);
        component.addPropertyChangeListener(property, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                Object value = e.getNewValue();
                ComponentGeometry.this.setProperty(property, value != null ? value.toString() : null);
            }
        });
    }

    void updateIntProperty(Component c, String property, int defaultValue) {
        int i = this.getIntProperty(property, defaultValue);
        try {
            PropertyUtils.setProperty((Object)c, (String)property, (Object)new Integer(i));
        }
        catch (Throwable th) {
            throw new PreferenceException("Error setting property: " + property, th);
        }
    }

    void updateSize(Component c, int initialWidth, int initialHeight) {
        int w = this.getIntWidth(initialWidth);
        int h = this.getIntHeight(initialHeight);
        if (w > 0 && h > 0) {
            c.setSize(w, h);
        }
    }

    void updateLocation(Component c, int maxOffset) {
        if (maxOffset != 0) {
            int xOffset = (int)(Math.random() * (double)maxOffset);
            int yOffset = (int)(Math.random() * (double)maxOffset);
            this.changeX(xOffset);
            this.changeY(yOffset);
        }
        int x = this.getIntX(-1);
        int y = this.getIntY(-1);
        if (x > 0 && y > 0) {
            c.setLocation(x, y);
        }
    }

    public void changeX(int xOffset) {
        if (xOffset != 0) {
            this.setX(new Integer(this.getIntX(0) + xOffset));
        }
    }

    public void changeY(int yOffset) {
        if (yOffset != 0) {
            this.setY(new Integer(this.getIntY(0) + yOffset));
        }
    }

    public int getIntWidth(int defaultValue) {
        return this.getWidth() != null ? this.getWidth() : defaultValue;
    }

    public int getIntHeight(int defaultValue) {
        return this.getHeight() != null ? this.getHeight() : defaultValue;
    }

    public int getIntX(int defaultValue) {
        return this.getX() != null ? this.getX() : defaultValue;
    }

    public int getIntY(int defaultValue) {
        return this.getY() != null ? this.getY() : defaultValue;
    }
}

