/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.state;

import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.pref.ProjectStatePreferences;
import org.apache.cayenne.util.CayenneMapEntry;

public abstract class DisplayEventType {
    protected ProjectController controller;
    protected ProjectStatePreferences preferences;

    public DisplayEventType(ProjectController controller) {
        this.controller = controller;
        this.preferences = controller.getProjectStatePreferences();
    }

    public abstract void fireLastDisplayEvent();

    public abstract void saveLastDisplayEvent();

    protected String getObjectName(ConfigurationNode object) {
        if (object instanceof CayenneMapEntry) {
            return ((CayenneMapEntry)((Object)object)).getName();
        }
        if (object instanceof DataChannelDescriptor) {
            return ((DataChannelDescriptor)object).getName();
        }
        if (object instanceof DataNodeDescriptor) {
            return ((DataNodeDescriptor)object).getName();
        }
        if (object instanceof DataMap) {
            return ((DataMap)object).getName();
        }
        if (object instanceof Embeddable) {
            return ((Embeddable)object).getClassName();
        }
        if (object instanceof QueryDescriptor) {
            return ((QueryDescriptor)object).getName();
        }
        return "";
    }

    protected String parseToString(CayenneMapEntry[] array) {
        if (array == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (CayenneMapEntry entry : array) {
            if (entry == null) continue;
            sb.append(entry.getName()).append(",");
        }
        return sb.toString();
    }
}

