/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.cayenne.map.LifecycleEvent;

public class CallbackDescriptor
implements Serializable {
    protected LifecycleEvent callbackType;
    protected Set<String> callbackMethods;

    public CallbackDescriptor(LifecycleEvent callbackType) {
        this.setCallbackType(callbackType);
        this.callbackMethods = new LinkedHashSet<String>(3);
    }

    public void clear() {
        this.callbackMethods.clear();
    }

    public Collection<String> getCallbackMethods() {
        return Collections.unmodifiableCollection(this.callbackMethods);
    }

    public void addCallbackMethod(String methodName) {
        this.callbackMethods.add(methodName);
    }

    public void removeCallbackMethod(String methodName) {
        this.callbackMethods.remove(methodName);
    }

    public LifecycleEvent getCallbackType() {
        return this.callbackType;
    }

    void setCallbackType(LifecycleEvent callbackType) {
        this.callbackType = callbackType;
    }

    public boolean moveMethod(String callbackMethod, int destinationIndex) {
        ArrayList<String> callbackMethodsList = new ArrayList<String>(this.callbackMethods);
        int currentIndex = callbackMethodsList.indexOf(callbackMethod);
        if (currentIndex < 0) {
            throw new IllegalArgumentException("Unknown callback method: " + callbackMethod);
        }
        boolean changed = false;
        if (destinationIndex > currentIndex) {
            callbackMethodsList.add(destinationIndex + 1, callbackMethod);
            callbackMethodsList.remove(currentIndex);
            changed = true;
        } else if (destinationIndex < currentIndex) {
            callbackMethodsList.add(destinationIndex, callbackMethod);
            callbackMethodsList.remove(currentIndex + 1);
            changed = true;
        }
        if (changed) {
            this.callbackMethods.clear();
            this.callbackMethods.addAll(callbackMethodsList);
        }
        return changed;
    }

    public void setCallbackMethodAt(int index, String method) {
        ArrayList<String> callbackMethodsList = new ArrayList<String>(this.callbackMethods);
        callbackMethodsList.set(index, method);
        this.callbackMethods.clear();
        this.callbackMethods.addAll(callbackMethodsList);
    }
}

