/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ProcedureResult;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.IndirectQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.ProcedureResultBuilder;

public class ProcedureCall<T>
extends IndirectQuery {
    protected String procedureName;
    protected Class<T> resultClass;
    protected Map<String, Object> params;
    protected Integer fetchLimit;
    protected Integer fetchOffset;
    protected CapsStrategy capsStrategy;
    protected Boolean fetchingDataRows;
    protected ColumnDescriptor[] resultDescriptor;

    public static ProcedureCall query(String procedure) {
        return new ProcedureCall(procedure);
    }

    public static ProcedureCall<DataRow> dataRowQuery(String procedure) {
        ProcedureCall<DataRow> procedureCall = new ProcedureCall<DataRow>(procedure);
        procedureCall.fetchingDataRows = true;
        return procedureCall;
    }

    public static <T> ProcedureCall<T> query(String procedure, Class<T> resultClass) {
        ProcedureCall<T> procedureCall = new ProcedureCall<T>(procedure, resultClass);
        procedureCall.fetchingDataRows = false;
        return procedureCall;
    }

    public ProcedureCall(String procedureName) {
        this.procedureName = procedureName;
    }

    public ProcedureCall(String procedureName, Class<T> resultClass) {
        this.procedureName = procedureName;
        this.resultClass = resultClass;
    }

    public ProcedureCall<T> params(Map<String, ?> parameters) {
        if (this.params == null) {
            this.params = new HashMap(parameters);
        } else {
            Map<String, ?> bareMap = parameters;
            this.params.putAll(bareMap);
        }
        this.replacementQuery = null;
        return this;
    }

    public ProcedureCall<T> param(String name, Object value) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(name, value);
        this.replacementQuery = null;
        return this;
    }

    public ProcedureCall<T> limit(int fetchLimit) {
        this.fetchLimit = fetchLimit;
        return this;
    }

    public ProcedureCall<T> offset(int fetchOffset) {
        this.fetchOffset = fetchOffset;
        return this;
    }

    public ProcedureCall<T> capsStrategy(CapsStrategy capsStrategy) {
        this.capsStrategy = capsStrategy;
        return this;
    }

    public ProcedureCall<T> resultDescriptor(ColumnDescriptor[] resultDescriptor) {
        this.resultDescriptor = resultDescriptor;
        return this;
    }

    public ProcedureResult<T> call(ObjectContext context) {
        QueryResponse response = context.performGenericQuery(this);
        ProcedureResultBuilder<T> builder = ProcedureResultBuilder.builder(response.size(), this.resultClass);
        response.reset();
        while (response.next()) {
            if (response.isList()) {
                builder.addSelectResult(response.currentList());
                continue;
            }
            builder.addBatchUpdateResult(response.currentUpdateCount());
        }
        return builder.build();
    }

    public List<T> select(ObjectContext context) {
        return this.call(context).firstList();
    }

    public int[] batchUpdate(ObjectContext context) {
        return this.call(context).firstBatchUpdateCount();
    }

    public int update(ObjectContext context) {
        return this.call(context).firstUpdateCount();
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        ProcedureQuery procedureQuery = new ProcedureQuery(this.procedureName);
        if (this.fetchingDataRows != null) {
            procedureQuery.setFetchingDataRows(this.fetchingDataRows);
        }
        if (this.resultClass != null) {
            procedureQuery.resultClass = this.resultClass;
        }
        if (this.fetchLimit != null) {
            procedureQuery.setFetchLimit(this.fetchLimit);
        }
        if (this.fetchOffset != null) {
            procedureQuery.setFetchOffset(this.fetchOffset);
        }
        if (this.resultDescriptor != null) {
            procedureQuery.addResultDescriptor(this.resultDescriptor);
        }
        if (this.capsStrategy != null) {
            procedureQuery.setColumnNamesCapitalization(this.capsStrategy);
        }
        procedureQuery.setParameters(this.params);
        return procedureQuery;
    }
}

