/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing.control;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

public class ActionLink
extends JLabel {
    static final Color LINK_FONT_COLOR = Color.BLUE;
    static final Color LINK_MOUSEOVER_FONT_COLOR = Color.RED;

    public ActionLink(String text) {
        super(text);
        this.setForeground(LINK_FONT_COLOR);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ActionLink.this.fireActionPerformed();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ActionLink.this.setForeground(LINK_MOUSEOVER_FONT_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ActionLink.this.setForeground(LINK_FONT_COLOR);
            }
        });
    }

    protected void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                e = new ActionEvent(this, 1001, null);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }
}

