/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.pref;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.cayenne.modeler.util.CayenneUserDir;
import org.apache.cayenne.pref.Preference;
import org.apache.cayenne.pref.PreferenceDecorator;

public class UpgradeCayennePreference
extends PreferenceDecorator {
    public static final String PREFERENCES_NAME_OLD = "modeler.preferences";
    public static final String LAST_PROJ_FILES_OLD = "Editor.lastSeveralProjectFiles";
    public static final String EDITOR_LAFNAME_OLD = "Editor.lookAndFeel";
    public static final String EDITOR_THEMENAME_OLD = "Editor.theme";
    public static final String EDITOR_LOGFILE_ENABLED_OLD = "Editor.logfileEnabled";
    public static final String EDITOR_LOGFILE_OLD = "Editor.logfile";
    public static final String DELIMITER = ",";

    public UpgradeCayennePreference(Preference delegate) {
        super(delegate);
    }

    public void upgrade() {
        block6: {
            try {
                File prefsFile;
                if (Preferences.userRoot().nodeExists("org/apache/cayenne") || !(prefsFile = new File(this.preferencesDirectory(), PREFERENCES_NAME_OLD)).exists()) break block6;
                Properties ep = new Properties();
                try {
                    ep.load(new FileInputStream(prefsFile));
                    Preferences prefEditor = Preferences.userRoot().node("org/apache/cayenne").node("editor");
                    prefEditor.putBoolean("logfileEnabled", Boolean.valueOf(ep.getProperty(EDITOR_LOGFILE_ENABLED_OLD)));
                    prefEditor.put("logfile", ep.getProperty(EDITOR_LOGFILE_OLD));
                    Preferences frefLastProjFiles = prefEditor.node("lastSeveralProjectFiles");
                    List<String> arr = this.getVector(ep.getProperty(LAST_PROJ_FILES_OLD));
                    while (arr.size() > 12) {
                        arr.remove(arr.size() - 1);
                    }
                    frefLastProjFiles.clear();
                    for (int i = 0; i < arr.size(); ++i) {
                        frefLastProjFiles.put(String.valueOf(i), arr.get(i));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
    }

    private List<String> getVector(String value) {
        return Arrays.asList(value.split(DELIMITER));
    }

    public File preferencesDirectory() {
        return CayenneUserDir.getInstance().getDirectory();
    }

    @Override
    public Preferences getRootPreference() {
        this.upgrade();
        return this.delegate.getRootPreference();
    }

    @Override
    public Preferences getCayennePreference() {
        this.upgrade();
        return this.delegate.getCayennePreference();
    }

    @Override
    public Preferences getCurrentPreference() {
        this.upgrade();
        return this.delegate.getCayennePreference();
    }
}

