/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.apache.cayenne.swing.components.TopBorder;

public class PreferenceDialogView
extends JDialog {
    protected JSplitPane split;
    protected JList<String> list;
    protected CardLayout detailLayout;
    protected Container detailPanel;
    protected JButton cancelButton;
    protected JButton saveButton;

    public PreferenceDialogView(Dialog parent) {
        super(parent);
        this.init();
    }

    public PreferenceDialogView(Frame parent) {
        super(parent);
        this.init();
    }

    private void init() {
        this.split = new JSplitPane(1);
        this.split.setBorder(TopBorder.create());
        this.list = new JList();
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 0));
                return this;
            }
        });
        this.list.setFont(new JLabel().getFont().deriveFont(1, 12.0f));
        this.detailLayout = new CardLayout();
        this.detailPanel = new JPanel(this.detailLayout);
        this.saveButton = new JButton("Save");
        this.cancelButton = new JButton("Cancel");
        JPanel leftContainer = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        leftContainer.add(scrollPane);
        ((Component)leftContainer).setPreferredSize(new Dimension(180, 400));
        this.split.setLeftComponent(leftContainer);
        this.split.setRightComponent(this.detailPanel);
        this.split.setDividerSize(3);
        this.getRootPane().setDefaultButton(this.saveButton);
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.cancelButton);
        buttons.add(this.saveButton);
        buttons.setBorder(TopBorder.create());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.split, "Center");
        this.getContentPane().add((Component)buttons, "South");
        this.setTitle("Edit Preferences");
    }

    public JList<String> getList() {
        return this.list;
    }

    public JSplitPane getSplit() {
        return this.split;
    }

    public Container getDetailPanel() {
        return this.detailPanel;
    }

    public CardLayout getDetailLayout() {
        return this.detailLayout;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }
}

