/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action.dbimport;

import java.awt.event.ActionEvent;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.dbimport.TreeManipulationAction;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;

public class AddIncludeTableAction
extends TreeManipulationAction {
    private static final String ACTION_NAME = "Include Table";
    private static final String ICON_NAME = "icon-dbi-includeTable.png";

    public AddIncludeTableAction(Application application) {
        super(ACTION_NAME, application);
        this.insertableNodeClass = IncludeTable.class;
    }

    @Override
    public String getIconName() {
        return ICON_NAME;
    }

    @Override
    public void performAction(ActionEvent e) {
        ReverseEngineering reverseEngineeringOldCopy = this.prepareElements();
        if (this.reverseEngineeringIsEmpty()) {
            this.tree.getRootNode().removeAllChildren();
        }
        IncludeTable newTable = new IncludeTable(this.name);
        if (this.canBeInserted(this.selectedElement)) {
            ((FilterContainer)this.selectedElement.getUserObject()).addIncludeTable(newTable);
            this.selectedElement.add(new DbImportTreeNode(newTable));
            this.updateSelected = true;
        } else {
            if (this.parentElement == null) {
                this.parentElement = this.tree.getRootNode();
            }
            ((FilterContainer)this.parentElement.getUserObject()).addIncludeTable(newTable);
            this.parentElement.add(new DbImportTreeNode(newTable));
            this.updateSelected = false;
        }
        this.completeInserting(reverseEngineeringOldCopy);
    }
}

