/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1alpha1.kameletbindingspec.integration.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.Ingress;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.ingress.Configuration;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.ingress.ConfigurationBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.ingress.ConfigurationFluent;

public class IngressFluent<A extends IngressFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> annotations;
    private Boolean auto;
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private String host;
    private String ingressClassName;
    private String path;
    private Ingress.PathType pathType;
    private List<String> tlsHosts;
    private String tlsSecretName;

    public IngressFluent() {
    }

    public IngressFluent(Ingress instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Ingress instance) {
        Ingress ingress = instance = instance != null ? instance : new Ingress();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withAuto(instance.getAuto());
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withHost(instance.getHost());
            this.withIngressClassName(instance.getIngressClassName());
            this.withPath(instance.getPath());
            this.withPathType(instance.getPathType());
            this.withTlsHosts(instance.getTlsHosts());
            this.withTlsSecretName(instance.getTlsSecretName());
        }
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public Boolean getAuto() {
        return this.auto;
    }

    public A withAuto(Boolean auto) {
        this.auto = auto;
        return (A)((Object)this);
    }

    public boolean hasAuto() {
        return this.auto != null;
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public String getIngressClassName() {
        return this.ingressClassName;
    }

    public A withIngressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
        return (A)((Object)this);
    }

    public boolean hasIngressClassName() {
        return this.ingressClassName != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public Ingress.PathType getPathType() {
        return this.pathType;
    }

    public A withPathType(Ingress.PathType pathType) {
        this.pathType = pathType;
        return (A)((Object)this);
    }

    public boolean hasPathType() {
        return this.pathType != null;
    }

    public A addToTlsHosts(int index, String item) {
        if (this.tlsHosts == null) {
            this.tlsHosts = new ArrayList<String>();
        }
        this.tlsHosts.add(index, item);
        return (A)((Object)this);
    }

    public A setToTlsHosts(int index, String item) {
        if (this.tlsHosts == null) {
            this.tlsHosts = new ArrayList<String>();
        }
        this.tlsHosts.set(index, item);
        return (A)((Object)this);
    }

    public A addToTlsHosts(String ... items) {
        if (this.tlsHosts == null) {
            this.tlsHosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.tlsHosts.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTlsHosts(Collection<String> items) {
        if (this.tlsHosts == null) {
            this.tlsHosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.tlsHosts.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTlsHosts(String ... items) {
        if (this.tlsHosts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tlsHosts.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTlsHosts(Collection<String> items) {
        if (this.tlsHosts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tlsHosts.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTlsHosts() {
        return this.tlsHosts;
    }

    public String getTlsHost(int index) {
        return this.tlsHosts.get(index);
    }

    public String getFirstTlsHost() {
        return this.tlsHosts.get(0);
    }

    public String getLastTlsHost() {
        return this.tlsHosts.get(this.tlsHosts.size() - 1);
    }

    public String getMatchingTlsHost(Predicate<String> predicate) {
        for (String item : this.tlsHosts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTlsHost(Predicate<String> predicate) {
        for (String item : this.tlsHosts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTlsHosts(List<String> tlsHosts) {
        if (tlsHosts != null) {
            this.tlsHosts = new ArrayList<String>();
            for (String item : tlsHosts) {
                this.addToTlsHosts(item);
            }
        } else {
            this.tlsHosts = null;
        }
        return (A)((Object)this);
    }

    public A withTlsHosts(String ... tlsHosts) {
        if (this.tlsHosts != null) {
            this.tlsHosts.clear();
            this._visitables.remove((Object)"tlsHosts");
        }
        if (tlsHosts != null) {
            for (String item : tlsHosts) {
                this.addToTlsHosts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTlsHosts() {
        return this.tlsHosts != null && !this.tlsHosts.isEmpty();
    }

    public String getTlsSecretName() {
        return this.tlsSecretName;
    }

    public A withTlsSecretName(String tlsSecretName) {
        this.tlsSecretName = tlsSecretName;
        return (A)((Object)this);
    }

    public boolean hasTlsSecretName() {
        return this.tlsSecretName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressFluent that = (IngressFluent)((Object)o);
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.auto, that.auto)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.ingressClassName, that.ingressClassName)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals((Object)this.pathType, (Object)that.pathType)) {
            return false;
        }
        if (!Objects.equals(this.tlsHosts, that.tlsHosts)) {
            return false;
        }
        return Objects.equals(this.tlsSecretName, that.tlsSecretName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.annotations, this.auto, this.configuration, this.enabled, this.host, this.ingressClassName, this.path, this.pathType, this.tlsHosts, this.tlsSecretName, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.auto != null) {
            sb.append("auto:");
            sb.append(this.auto + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.ingressClassName != null) {
            sb.append("ingressClassName:");
            sb.append(this.ingressClassName + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.pathType != null) {
            sb.append("pathType:");
            sb.append(this.pathType + ",");
        }
        if (this.tlsHosts != null && !this.tlsHosts.isEmpty()) {
            sb.append("tlsHosts:");
            sb.append(this.tlsHosts + ",");
        }
        if (this.tlsSecretName != null) {
            sb.append("tlsSecretName:");
            sb.append(this.tlsSecretName);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAuto() {
        return this.withAuto(true);
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)IngressFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

