/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationstatus.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.integrationstatus.traits.Telemetry;
import org.apache.camel.v1.integrationstatus.traits.telemetry.Configuration;
import org.apache.camel.v1.integrationstatus.traits.telemetry.ConfigurationBuilder;
import org.apache.camel.v1.integrationstatus.traits.telemetry.ConfigurationFluent;

public class TelemetryFluent<A extends TelemetryFluent<A>>
extends BaseFluent<A> {
    private Boolean auto;
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private String endpoint;
    private String sampler;
    private Boolean samplerParentBased;
    private String samplerRatio;
    private String serviceName;

    public TelemetryFluent() {
    }

    public TelemetryFluent(Telemetry instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Telemetry instance) {
        Telemetry telemetry = instance = instance != null ? instance : new Telemetry();
        if (instance != null) {
            this.withAuto(instance.getAuto());
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withEndpoint(instance.getEndpoint());
            this.withSampler(instance.getSampler());
            this.withSamplerParentBased(instance.getSamplerParentBased());
            this.withSamplerRatio(instance.getSamplerRatio());
            this.withServiceName(instance.getServiceName());
        }
    }

    public Boolean getAuto() {
        return this.auto;
    }

    public A withAuto(Boolean auto) {
        this.auto = auto;
        return (A)((Object)this);
    }

    public boolean hasAuto() {
        return this.auto != null;
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public A withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return (A)((Object)this);
    }

    public boolean hasEndpoint() {
        return this.endpoint != null;
    }

    public String getSampler() {
        return this.sampler;
    }

    public A withSampler(String sampler) {
        this.sampler = sampler;
        return (A)((Object)this);
    }

    public boolean hasSampler() {
        return this.sampler != null;
    }

    public Boolean getSamplerParentBased() {
        return this.samplerParentBased;
    }

    public A withSamplerParentBased(Boolean samplerParentBased) {
        this.samplerParentBased = samplerParentBased;
        return (A)((Object)this);
    }

    public boolean hasSamplerParentBased() {
        return this.samplerParentBased != null;
    }

    public String getSamplerRatio() {
        return this.samplerRatio;
    }

    public A withSamplerRatio(String samplerRatio) {
        this.samplerRatio = samplerRatio;
        return (A)((Object)this);
    }

    public boolean hasSamplerRatio() {
        return this.samplerRatio != null;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public A withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (A)((Object)this);
    }

    public boolean hasServiceName() {
        return this.serviceName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TelemetryFluent that = (TelemetryFluent)((Object)o);
        if (!Objects.equals(this.auto, that.auto)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.endpoint, that.endpoint)) {
            return false;
        }
        if (!Objects.equals(this.sampler, that.sampler)) {
            return false;
        }
        if (!Objects.equals(this.samplerParentBased, that.samplerParentBased)) {
            return false;
        }
        if (!Objects.equals(this.samplerRatio, that.samplerRatio)) {
            return false;
        }
        return Objects.equals(this.serviceName, that.serviceName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.auto, this.configuration, this.enabled, this.endpoint, this.sampler, this.samplerParentBased, this.samplerRatio, this.serviceName, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.auto != null) {
            sb.append("auto:");
            sb.append(this.auto + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.endpoint != null) {
            sb.append("endpoint:");
            sb.append(this.endpoint + ",");
        }
        if (this.sampler != null) {
            sb.append("sampler:");
            sb.append(this.sampler + ",");
        }
        if (this.samplerParentBased != null) {
            sb.append("samplerParentBased:");
            sb.append(this.samplerParentBased + ",");
        }
        if (this.samplerRatio != null) {
            sb.append("samplerRatio:");
            sb.append(this.samplerRatio + ",");
        }
        if (this.serviceName != null) {
            sb.append("serviceName:");
            sb.append(this.serviceName);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAuto() {
        return this.withAuto(true);
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withSamplerParentBased() {
        return this.withSamplerParentBased(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)TelemetryFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

