/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationstatus.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import org.apache.camel.v1.integrationstatus.traits.RouteBuilder;
import org.apache.camel.v1.integrationstatus.traits.route.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"annotations", "configuration", "enabled", "host", "tlsCACertificate", "tlsCACertificateSecret", "tlsCertificate", "tlsCertificateSecret", "tlsDestinationCACertificate", "tlsDestinationCACertificateSecret", "tlsInsecureEdgeTerminationPolicy", "tlsKey", "tlsKeySecret", "tlsTermination"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Route
implements Editable<RouteBuilder>,
KubernetesResource {
    @JsonProperty(value="annotations")
    @JsonPropertyDescription(value="The annotations added to route.\nThis can be used to set route specific annotations\nFor annotations options see https://docs.openshift.com/container-platform/3.11/architecture/networking/routes.html#route-specific-annotations\nCLI usage example: -t \"route.annotations.'haproxy.router.openshift.io/balance'=true\"")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> annotations;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters.\nDeprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Can be used to enable or disable a trait. All traits share this common property.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="To configure the host exposed by the route.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String host;
    @JsonProperty(value="tlsCACertificate")
    @JsonPropertyDescription(value="The TLS CA certificate contents.\n\n\nRefer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsCACertificate;
    @JsonProperty(value="tlsCACertificateSecret")
    @JsonPropertyDescription(value="The secret name and key reference to the TLS CA certificate. The format is \"secret-name[/key-name]\", the value represents the secret name, if there is only one key in the secret it will be read, otherwise you can set a key name separated with a \"/\".\n\n\nRefer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsCACertificateSecret;
    @JsonProperty(value="tlsCertificate")
    @JsonPropertyDescription(value="The TLS certificate contents.\n\n\nRefer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsCertificate;
    @JsonProperty(value="tlsCertificateSecret")
    @JsonPropertyDescription(value="The secret name and key reference to the TLS certificate. The format is \"secret-name[/key-name]\", the value represents the secret name, if there is only one key in the secret it will be read, otherwise you can set a key name separated with a \"/\".\n\n\nRefer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsCertificateSecret;
    @JsonProperty(value="tlsDestinationCACertificate")
    @JsonPropertyDescription(value="The destination CA certificate provides the contents of the ca certificate of the final destination.  When using reencrypt\ntermination this file should be provided in order to have routers use it for health checks on the secure connection.\nIf this field is not specified, the router may provide its own destination CA and perform hostname validation using\nthe short service name (service.namespace.svc), which allows infrastructure generated certificates to automatically\nverify.\n\n\nRefer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsDestinationCACertificate;
    @JsonProperty(value="tlsDestinationCACertificateSecret")
    @JsonPropertyDescription(value="The secret name and key reference to the destination CA certificate. The format is \"secret-name[/key-name]\", the value represents the secret name, if there is only one key in the secret it will be read, otherwise you can set a key name separated with a \"/\".\n\n\nRefer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsDestinationCACertificateSecret;
    @JsonProperty(value="tlsInsecureEdgeTerminationPolicy")
    @JsonPropertyDescription(value="To configure how to deal with insecure traffic, e.g. `Allow`, `Disable` or `Redirect` traffic.\n\n\nRefer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private TlsInsecureEdgeTerminationPolicy tlsInsecureEdgeTerminationPolicy;
    @JsonProperty(value="tlsKey")
    @JsonPropertyDescription(value="The TLS certificate key contents.\n\n\nRefer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsKey;
    @JsonProperty(value="tlsKeySecret")
    @JsonPropertyDescription(value="The secret name and key reference to the TLS certificate key. The format is \"secret-name[/key-name]\", the value represents the secret name, if there is only one key in the secret it will be read, otherwise you can set a key name separated with a \"/\".\n\n\nRefer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsKeySecret;
    @JsonProperty(value="tlsTermination")
    @JsonPropertyDescription(value="The TLS termination type, like `edge`, `passthrough` or `reencrypt`.\n\n\nRefer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private TlsTermination tlsTermination;

    public RouteBuilder edit() {
        return new RouteBuilder(this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getTlsCACertificate() {
        return this.tlsCACertificate;
    }

    public void setTlsCACertificate(String tlsCACertificate) {
        this.tlsCACertificate = tlsCACertificate;
    }

    public String getTlsCACertificateSecret() {
        return this.tlsCACertificateSecret;
    }

    public void setTlsCACertificateSecret(String tlsCACertificateSecret) {
        this.tlsCACertificateSecret = tlsCACertificateSecret;
    }

    public String getTlsCertificate() {
        return this.tlsCertificate;
    }

    public void setTlsCertificate(String tlsCertificate) {
        this.tlsCertificate = tlsCertificate;
    }

    public String getTlsCertificateSecret() {
        return this.tlsCertificateSecret;
    }

    public void setTlsCertificateSecret(String tlsCertificateSecret) {
        this.tlsCertificateSecret = tlsCertificateSecret;
    }

    public String getTlsDestinationCACertificate() {
        return this.tlsDestinationCACertificate;
    }

    public void setTlsDestinationCACertificate(String tlsDestinationCACertificate) {
        this.tlsDestinationCACertificate = tlsDestinationCACertificate;
    }

    public String getTlsDestinationCACertificateSecret() {
        return this.tlsDestinationCACertificateSecret;
    }

    public void setTlsDestinationCACertificateSecret(String tlsDestinationCACertificateSecret) {
        this.tlsDestinationCACertificateSecret = tlsDestinationCACertificateSecret;
    }

    public TlsInsecureEdgeTerminationPolicy getTlsInsecureEdgeTerminationPolicy() {
        return this.tlsInsecureEdgeTerminationPolicy;
    }

    public void setTlsInsecureEdgeTerminationPolicy(TlsInsecureEdgeTerminationPolicy tlsInsecureEdgeTerminationPolicy) {
        this.tlsInsecureEdgeTerminationPolicy = tlsInsecureEdgeTerminationPolicy;
    }

    public String getTlsKey() {
        return this.tlsKey;
    }

    public void setTlsKey(String tlsKey) {
        this.tlsKey = tlsKey;
    }

    public String getTlsKeySecret() {
        return this.tlsKeySecret;
    }

    public void setTlsKeySecret(String tlsKeySecret) {
        this.tlsKeySecret = tlsKeySecret;
    }

    public TlsTermination getTlsTermination() {
        return this.tlsTermination;
    }

    public void setTlsTermination(TlsTermination tlsTermination) {
        this.tlsTermination = tlsTermination;
    }

    public String toString() {
        return "Route(annotations=" + this.getAnnotations() + ", configuration=" + this.getConfiguration() + ", enabled=" + this.getEnabled() + ", host=" + this.getHost() + ", tlsCACertificate=" + this.getTlsCACertificate() + ", tlsCACertificateSecret=" + this.getTlsCACertificateSecret() + ", tlsCertificate=" + this.getTlsCertificate() + ", tlsCertificateSecret=" + this.getTlsCertificateSecret() + ", tlsDestinationCACertificate=" + this.getTlsDestinationCACertificate() + ", tlsDestinationCACertificateSecret=" + this.getTlsDestinationCACertificateSecret() + ", tlsInsecureEdgeTerminationPolicy=" + this.getTlsInsecureEdgeTerminationPolicy() + ", tlsKey=" + this.getTlsKey() + ", tlsKeySecret=" + this.getTlsKeySecret() + ", tlsTermination=" + this.getTlsTermination() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Route)) {
            return false;
        }
        Route other = (Route)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$tlsCACertificate = this.getTlsCACertificate();
        String other$tlsCACertificate = other.getTlsCACertificate();
        if (this$tlsCACertificate == null ? other$tlsCACertificate != null : !this$tlsCACertificate.equals(other$tlsCACertificate)) {
            return false;
        }
        String this$tlsCACertificateSecret = this.getTlsCACertificateSecret();
        String other$tlsCACertificateSecret = other.getTlsCACertificateSecret();
        if (this$tlsCACertificateSecret == null ? other$tlsCACertificateSecret != null : !this$tlsCACertificateSecret.equals(other$tlsCACertificateSecret)) {
            return false;
        }
        String this$tlsCertificate = this.getTlsCertificate();
        String other$tlsCertificate = other.getTlsCertificate();
        if (this$tlsCertificate == null ? other$tlsCertificate != null : !this$tlsCertificate.equals(other$tlsCertificate)) {
            return false;
        }
        String this$tlsCertificateSecret = this.getTlsCertificateSecret();
        String other$tlsCertificateSecret = other.getTlsCertificateSecret();
        if (this$tlsCertificateSecret == null ? other$tlsCertificateSecret != null : !this$tlsCertificateSecret.equals(other$tlsCertificateSecret)) {
            return false;
        }
        String this$tlsDestinationCACertificate = this.getTlsDestinationCACertificate();
        String other$tlsDestinationCACertificate = other.getTlsDestinationCACertificate();
        if (this$tlsDestinationCACertificate == null ? other$tlsDestinationCACertificate != null : !this$tlsDestinationCACertificate.equals(other$tlsDestinationCACertificate)) {
            return false;
        }
        String this$tlsDestinationCACertificateSecret = this.getTlsDestinationCACertificateSecret();
        String other$tlsDestinationCACertificateSecret = other.getTlsDestinationCACertificateSecret();
        if (this$tlsDestinationCACertificateSecret == null ? other$tlsDestinationCACertificateSecret != null : !this$tlsDestinationCACertificateSecret.equals(other$tlsDestinationCACertificateSecret)) {
            return false;
        }
        TlsInsecureEdgeTerminationPolicy this$tlsInsecureEdgeTerminationPolicy = this.getTlsInsecureEdgeTerminationPolicy();
        TlsInsecureEdgeTerminationPolicy other$tlsInsecureEdgeTerminationPolicy = other.getTlsInsecureEdgeTerminationPolicy();
        if (this$tlsInsecureEdgeTerminationPolicy == null ? other$tlsInsecureEdgeTerminationPolicy != null : !((Object)((Object)this$tlsInsecureEdgeTerminationPolicy)).equals((Object)other$tlsInsecureEdgeTerminationPolicy)) {
            return false;
        }
        String this$tlsKey = this.getTlsKey();
        String other$tlsKey = other.getTlsKey();
        if (this$tlsKey == null ? other$tlsKey != null : !this$tlsKey.equals(other$tlsKey)) {
            return false;
        }
        String this$tlsKeySecret = this.getTlsKeySecret();
        String other$tlsKeySecret = other.getTlsKeySecret();
        if (this$tlsKeySecret == null ? other$tlsKeySecret != null : !this$tlsKeySecret.equals(other$tlsKeySecret)) {
            return false;
        }
        TlsTermination this$tlsTermination = this.getTlsTermination();
        TlsTermination other$tlsTermination = other.getTlsTermination();
        return !(this$tlsTermination == null ? other$tlsTermination != null : !((Object)((Object)this$tlsTermination)).equals((Object)other$tlsTermination));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Route;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $tlsCACertificate = this.getTlsCACertificate();
        result = result * 59 + ($tlsCACertificate == null ? 43 : $tlsCACertificate.hashCode());
        String $tlsCACertificateSecret = this.getTlsCACertificateSecret();
        result = result * 59 + ($tlsCACertificateSecret == null ? 43 : $tlsCACertificateSecret.hashCode());
        String $tlsCertificate = this.getTlsCertificate();
        result = result * 59 + ($tlsCertificate == null ? 43 : $tlsCertificate.hashCode());
        String $tlsCertificateSecret = this.getTlsCertificateSecret();
        result = result * 59 + ($tlsCertificateSecret == null ? 43 : $tlsCertificateSecret.hashCode());
        String $tlsDestinationCACertificate = this.getTlsDestinationCACertificate();
        result = result * 59 + ($tlsDestinationCACertificate == null ? 43 : $tlsDestinationCACertificate.hashCode());
        String $tlsDestinationCACertificateSecret = this.getTlsDestinationCACertificateSecret();
        result = result * 59 + ($tlsDestinationCACertificateSecret == null ? 43 : $tlsDestinationCACertificateSecret.hashCode());
        TlsInsecureEdgeTerminationPolicy $tlsInsecureEdgeTerminationPolicy = this.getTlsInsecureEdgeTerminationPolicy();
        result = result * 59 + ($tlsInsecureEdgeTerminationPolicy == null ? 43 : ((Object)((Object)$tlsInsecureEdgeTerminationPolicy)).hashCode());
        String $tlsKey = this.getTlsKey();
        result = result * 59 + ($tlsKey == null ? 43 : $tlsKey.hashCode());
        String $tlsKeySecret = this.getTlsKeySecret();
        result = result * 59 + ($tlsKeySecret == null ? 43 : $tlsKeySecret.hashCode());
        TlsTermination $tlsTermination = this.getTlsTermination();
        result = result * 59 + ($tlsTermination == null ? 43 : ((Object)((Object)$tlsTermination)).hashCode());
        return result;
    }

    public static enum TlsInsecureEdgeTerminationPolicy {
        NONE("None"),
        ALLOW("Allow"),
        REDIRECT("Redirect");

        String value;

        private TlsInsecureEdgeTerminationPolicy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }

    public static enum TlsTermination {
        EDGE("edge"),
        REENCRYPT("reencrypt"),
        PASSTHROUGH("passthrough");

        String value;

        private TlsTermination(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

