/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformspec.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.integrationplatformspec.traits.PullSecret;
import org.apache.camel.v1.integrationplatformspec.traits.pullsecret.Configuration;
import org.apache.camel.v1.integrationplatformspec.traits.pullsecret.ConfigurationBuilder;
import org.apache.camel.v1.integrationplatformspec.traits.pullsecret.ConfigurationFluent;

public class PullSecretFluent<A extends PullSecretFluent<A>>
extends BaseFluent<A> {
    private Boolean auto;
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private Boolean imagePullerDelegation;
    private String secretName;

    public PullSecretFluent() {
    }

    public PullSecretFluent(PullSecret instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PullSecret instance) {
        PullSecret pullSecret = instance = instance != null ? instance : new PullSecret();
        if (instance != null) {
            this.withAuto(instance.getAuto());
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withImagePullerDelegation(instance.getImagePullerDelegation());
            this.withSecretName(instance.getSecretName());
        }
    }

    public Boolean getAuto() {
        return this.auto;
    }

    public A withAuto(Boolean auto) {
        this.auto = auto;
        return (A)((Object)this);
    }

    public boolean hasAuto() {
        return this.auto != null;
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public Boolean getImagePullerDelegation() {
        return this.imagePullerDelegation;
    }

    public A withImagePullerDelegation(Boolean imagePullerDelegation) {
        this.imagePullerDelegation = imagePullerDelegation;
        return (A)((Object)this);
    }

    public boolean hasImagePullerDelegation() {
        return this.imagePullerDelegation != null;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)((Object)this);
    }

    public boolean hasSecretName() {
        return this.secretName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PullSecretFluent that = (PullSecretFluent)((Object)o);
        if (!Objects.equals(this.auto, that.auto)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.imagePullerDelegation, that.imagePullerDelegation)) {
            return false;
        }
        return Objects.equals(this.secretName, that.secretName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.auto, this.configuration, this.enabled, this.imagePullerDelegation, this.secretName, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.auto != null) {
            sb.append("auto:");
            sb.append(this.auto + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.imagePullerDelegation != null) {
            sb.append("imagePullerDelegation:");
            sb.append(this.imagePullerDelegation + ",");
        }
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAuto() {
        return this.withAuto(true);
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withImagePullerDelegation() {
        return this.withImagePullerDelegation(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)PullSecretFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

