/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.IntegrationKitStatusBuilder;
import org.apache.camel.v1.integrationkitstatus.Artifacts;
import org.apache.camel.v1.integrationkitstatus.Conditions;
import org.apache.camel.v1.integrationkitstatus.Failure;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"artifacts", "baseImage", "conditions", "digest", "failure", "image", "observedGeneration", "phase", "platform", "rootImage", "runtimeProvider", "runtimeVersion", "version"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class IntegrationKitStatus
implements Editable<IntegrationKitStatusBuilder>,
KubernetesResource {
    @JsonProperty(value="artifacts")
    @JsonPropertyDescription(value="list of artifacts used by the kit")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Artifacts> artifacts;
    @JsonProperty(value="baseImage")
    @JsonPropertyDescription(value="base image used by the kit (could be another IntegrationKit)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String baseImage;
    @JsonProperty(value="conditions")
    @JsonPropertyDescription(value="a list of conditions which happened for the events related the kit")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Conditions> conditions;
    @JsonProperty(value="digest")
    @JsonPropertyDescription(value="actual image digest of the kit")
    @JsonSetter(nulls=Nulls.SKIP)
    private String digest;
    @JsonProperty(value="failure")
    @JsonPropertyDescription(value="failure reason (if any)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Failure failure;
    @JsonProperty(value="image")
    @JsonPropertyDescription(value="actual image name of the kit")
    @JsonSetter(nulls=Nulls.SKIP)
    private String image;
    @JsonProperty(value="observedGeneration")
    @JsonPropertyDescription(value="ObservedGeneration is the most recent generation observed for this IntegrationKit.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long observedGeneration;
    @JsonProperty(value="phase")
    @JsonPropertyDescription(value="phase of the kit")
    @JsonSetter(nulls=Nulls.SKIP)
    private String phase;
    @JsonProperty(value="platform")
    @JsonPropertyDescription(value="the platform for which this kit was configured")
    @JsonSetter(nulls=Nulls.SKIP)
    private String platform;
    @JsonProperty(value="rootImage")
    @JsonPropertyDescription(value="root image used by the kit (the first image from which the incremental image has started, typically a JDK/JRE base image)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String rootImage;
    @JsonProperty(value="runtimeProvider")
    @JsonPropertyDescription(value="the runtime provider for which this kit was configured")
    @JsonSetter(nulls=Nulls.SKIP)
    private String runtimeProvider;
    @JsonProperty(value="runtimeVersion")
    @JsonPropertyDescription(value="the runtime version for which this kit was configured")
    @JsonSetter(nulls=Nulls.SKIP)
    private String runtimeVersion;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="the Camel K operator version for which this kit was configured")
    @JsonSetter(nulls=Nulls.SKIP)
    private String version;

    public IntegrationKitStatusBuilder edit() {
        return new IntegrationKitStatusBuilder(this);
    }

    public List<Artifacts> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<Artifacts> artifacts) {
        this.artifacts = artifacts;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    public List<Conditions> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Conditions> conditions) {
        this.conditions = conditions;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public Failure getFailure() {
        return this.failure;
    }

    public void setFailure(Failure failure) {
        this.failure = failure;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getRootImage() {
        return this.rootImage;
    }

    public void setRootImage(String rootImage) {
        this.rootImage = rootImage;
    }

    public String getRuntimeProvider() {
        return this.runtimeProvider;
    }

    public void setRuntimeProvider(String runtimeProvider) {
        this.runtimeProvider = runtimeProvider;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "IntegrationKitStatus(artifacts=" + this.getArtifacts() + ", baseImage=" + this.getBaseImage() + ", conditions=" + this.getConditions() + ", digest=" + this.getDigest() + ", failure=" + this.getFailure() + ", image=" + this.getImage() + ", observedGeneration=" + this.getObservedGeneration() + ", phase=" + this.getPhase() + ", platform=" + this.getPlatform() + ", rootImage=" + this.getRootImage() + ", runtimeProvider=" + this.getRuntimeProvider() + ", runtimeVersion=" + this.getRuntimeVersion() + ", version=" + this.getVersion() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegrationKitStatus)) {
            return false;
        }
        IntegrationKitStatus other = (IntegrationKitStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$observedGeneration = this.getObservedGeneration();
        Long other$observedGeneration = other.getObservedGeneration();
        if (this$observedGeneration == null ? other$observedGeneration != null : !((Object)this$observedGeneration).equals(other$observedGeneration)) {
            return false;
        }
        List<Artifacts> this$artifacts = this.getArtifacts();
        List<Artifacts> other$artifacts = other.getArtifacts();
        if (this$artifacts == null ? other$artifacts != null : !((Object)this$artifacts).equals(other$artifacts)) {
            return false;
        }
        String this$baseImage = this.getBaseImage();
        String other$baseImage = other.getBaseImage();
        if (this$baseImage == null ? other$baseImage != null : !this$baseImage.equals(other$baseImage)) {
            return false;
        }
        List<Conditions> this$conditions = this.getConditions();
        List<Conditions> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        String this$digest = this.getDigest();
        String other$digest = other.getDigest();
        if (this$digest == null ? other$digest != null : !this$digest.equals(other$digest)) {
            return false;
        }
        Failure this$failure = this.getFailure();
        Failure other$failure = other.getFailure();
        if (this$failure == null ? other$failure != null : !((Object)this$failure).equals(other$failure)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$phase = this.getPhase();
        String other$phase = other.getPhase();
        if (this$phase == null ? other$phase != null : !this$phase.equals(other$phase)) {
            return false;
        }
        String this$platform = this.getPlatform();
        String other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
            return false;
        }
        String this$rootImage = this.getRootImage();
        String other$rootImage = other.getRootImage();
        if (this$rootImage == null ? other$rootImage != null : !this$rootImage.equals(other$rootImage)) {
            return false;
        }
        String this$runtimeProvider = this.getRuntimeProvider();
        String other$runtimeProvider = other.getRuntimeProvider();
        if (this$runtimeProvider == null ? other$runtimeProvider != null : !this$runtimeProvider.equals(other$runtimeProvider)) {
            return false;
        }
        String this$runtimeVersion = this.getRuntimeVersion();
        String other$runtimeVersion = other.getRuntimeVersion();
        if (this$runtimeVersion == null ? other$runtimeVersion != null : !this$runtimeVersion.equals(other$runtimeVersion)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IntegrationKitStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $observedGeneration = this.getObservedGeneration();
        result = result * 59 + ($observedGeneration == null ? 43 : ((Object)$observedGeneration).hashCode());
        List<Artifacts> $artifacts = this.getArtifacts();
        result = result * 59 + ($artifacts == null ? 43 : ((Object)$artifacts).hashCode());
        String $baseImage = this.getBaseImage();
        result = result * 59 + ($baseImage == null ? 43 : $baseImage.hashCode());
        List<Conditions> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        String $digest = this.getDigest();
        result = result * 59 + ($digest == null ? 43 : $digest.hashCode());
        Failure $failure = this.getFailure();
        result = result * 59 + ($failure == null ? 43 : ((Object)$failure).hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $phase = this.getPhase();
        result = result * 59 + ($phase == null ? 43 : $phase.hashCode());
        String $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
        String $rootImage = this.getRootImage();
        result = result * 59 + ($rootImage == null ? 43 : $rootImage.hashCode());
        String $runtimeProvider = this.getRuntimeProvider();
        result = result * 59 + ($runtimeProvider == null ? 43 : $runtimeProvider.hashCode());
        String $runtimeVersion = this.getRuntimeVersion();
        result = result * 59 + ($runtimeVersion == null ? 43 : $runtimeVersion.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

