/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.template.spec.volumes;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.Cephfs;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.cephfs.SecretRef;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.cephfs.SecretRefBuilder;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.cephfs.SecretRefFluent;

public class CephfsFluent<A extends CephfsFluent<A>>
extends BaseFluent<A> {
    private List<String> monitors;
    private String path;
    private Boolean readOnly;
    private String secretFile;
    private SecretRefBuilder secretRef;
    private String user;

    public CephfsFluent() {
    }

    public CephfsFluent(Cephfs instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Cephfs instance) {
        Cephfs cephfs = instance = instance != null ? instance : new Cephfs();
        if (instance != null) {
            this.withMonitors(instance.getMonitors());
            this.withPath(instance.getPath());
            this.withReadOnly(instance.getReadOnly());
            this.withSecretFile(instance.getSecretFile());
            this.withSecretRef(instance.getSecretRef());
            this.withUser(instance.getUser());
        }
    }

    public A addToMonitors(int index, String item) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        this.monitors.add(index, item);
        return (A)((Object)this);
    }

    public A setToMonitors(int index, String item) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        this.monitors.set(index, item);
        return (A)((Object)this);
    }

    public A addToMonitors(String ... items) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToMonitors(Collection<String> items) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromMonitors(String ... items) {
        if (this.monitors == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.monitors.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMonitors(Collection<String> items) {
        if (this.monitors == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.monitors.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getMonitors() {
        return this.monitors;
    }

    public String getMonitor(int index) {
        return this.monitors.get(index);
    }

    public String getFirstMonitor() {
        return this.monitors.get(0);
    }

    public String getLastMonitor() {
        return this.monitors.get(this.monitors.size() - 1);
    }

    public String getMatchingMonitor(Predicate<String> predicate) {
        for (String item : this.monitors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMonitor(Predicate<String> predicate) {
        for (String item : this.monitors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMonitors(List<String> monitors) {
        if (monitors != null) {
            this.monitors = new ArrayList<String>();
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        } else {
            this.monitors = null;
        }
        return (A)((Object)this);
    }

    public A withMonitors(String ... monitors) {
        if (this.monitors != null) {
            this.monitors.clear();
            this._visitables.remove((Object)"monitors");
        }
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMonitors() {
        return this.monitors != null && !this.monitors.isEmpty();
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)((Object)this);
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public String getSecretFile() {
        return this.secretFile;
    }

    public A withSecretFile(String secretFile) {
        this.secretFile = secretFile;
        return (A)((Object)this);
    }

    public boolean hasSecretFile() {
        return this.secretFile != null;
    }

    public SecretRef buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(SecretRef secretRef) {
        this._visitables.remove((Object)"secretRef");
        if (secretRef != null) {
            this.secretRef = new SecretRefBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove((Object)this.secretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public SecretRefNested<A> withNewSecretRefLike(SecretRef item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<A> editCephfsSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new SecretRefBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(SecretRef item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public String getUser() {
        return this.user;
    }

    public A withUser(String user) {
        this.user = user;
        return (A)((Object)this);
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CephfsFluent that = (CephfsFluent)((Object)o);
        if (!Objects.equals(this.monitors, that.monitors)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals(this.secretFile, that.secretFile)) {
            return false;
        }
        if (!Objects.equals((Object)this.secretRef, (Object)that.secretRef)) {
            return false;
        }
        return Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.monitors, this.path, this.readOnly, this.secretFile, this.secretRef, this.user, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.monitors != null && !this.monitors.isEmpty()) {
            sb.append("monitors:");
            sb.append(this.monitors + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretFile != null) {
            sb.append("secretFile:");
            sb.append(this.secretFile + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public class SecretRefNested<N>
    extends SecretRefFluent<SecretRefNested<N>>
    implements Nested<N> {
        SecretRefBuilder builder;

        SecretRefNested(SecretRef item) {
            this.builder = new SecretRefBuilder(this, item);
        }

        public N and() {
            return (N)CephfsFluent.this.withSecretRef(this.builder.build());
        }

        public N endCephfsSecretRef() {
            return this.and();
        }
    }
}

