/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.functions.lbaas.v1;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.openstack.neutron.v2.NeutronApi;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.Member;
import org.jclouds.openstack.neutron.v2.extensions.lbaas.v1.LBaaSApi;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

public class MembersToPagedIterable
extends Arg0ToPagedIterable.FromCaller<Member, MembersToPagedIterable> {
    private final NeutronApi api;

    @Inject
    protected MembersToPagedIterable(NeutronApi api) {
        this.api = (NeutronApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    protected Function<Object, IterableWithMarker<Member>> markerToNextForArg0(Optional<Object> arg0) {
        String region = arg0.isPresent() ? arg0.get().toString() : null;
        final LBaaSApi lbaasApi = (LBaaSApi)this.api.getLBaaSApi(region).get();
        return new Function<Object, IterableWithMarker<Member>>(){

            public IterableWithMarker<Member> apply(Object input) {
                PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                return (IterableWithMarker)IterableWithMarker.class.cast((Object)lbaasApi.listMembers(paginationOptions));
            }

            public String toString() {
                return "listMembers()";
            }
        };
    }
}

