/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.variables;

import com.google.common.reflect.TypeToken;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.steps.variables.TypedValueToSet;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.QuotedStringTokenizer;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Timestamp;
import org.apache.commons.lang3.tuple.MutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetVariableWorkflowStep
extends WorkflowStepDefinition {
    private static final Logger log = LoggerFactory.getLogger(SetVariableWorkflowStep.class);
    public static final String SHORTHAND = "[ [ ${variable.type} ] ${variable.name} [ \"=\" ${value...} ] ]";
    public static final ConfigKey<TypedValueToSet> VARIABLE = ConfigKeys.newConfigKey(TypedValueToSet.class, "variable");
    public static final ConfigKey<Object> VALUE = ConfigKeys.newConfigKey(Object.class, "value");
    public static final ConfigKey<InterpolationMode> INTERPOLATION_MODE = ConfigKeys.newConfigKey(InterpolationMode.class, "interpolation_mode", "Whether interpolation runs on the full value (not touching quotes; the default in most places), on words (if unquoted, unquoting others; the default for 'let var = value' shorthand), or is disabled (not applied at all)");
    public static final ConfigKey<TemplateProcessor.InterpolationErrorMode> INTERPOLATION_ERRORS = ConfigKeys.newConfigKey(TemplateProcessor.InterpolationErrorMode.class, "interpolation_errors", "Whether unresolvable interpolated expressions fail and return an error (the default for 'let'), ignore the expression leaving it in place (the default for 'load'), or replace the expression with a blank string");

    @Override
    public void populateFromShorthand(String expression) {
        Map<String, Object> newInput = this.populateFromShorthandTemplate(SHORTHAND, expression, true, true, true);
        if (newInput.get(VALUE.getName()) != null && this.input.get(INTERPOLATION_MODE.getName()) == null) {
            this.setInput(INTERPOLATION_MODE, InterpolationMode.WORDS);
        }
    }

    @Override
    public void validateStep(@Nullable ManagementContext mgmt, @Nullable WorkflowExecutionContext workflow) {
        super.validateStep(mgmt, workflow);
        if (this.input.get(VARIABLE.getName()) == null) {
            throw new IllegalArgumentException("Variable name is required");
        }
        if (this.input.get(VALUE.getName()) == null) {
            throw new IllegalArgumentException("Value is required");
        }
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        TypedValueToSet variable = context.getInput(VARIABLE);
        if (variable == null) {
            throw new IllegalArgumentException("Variable name is required");
        }
        String name = context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_INPUT, (Object)variable.name, String.class);
        if (Strings.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Variable name is required");
        }
        TypeToken<?> type = context.lookupType(variable.type, () -> null);
        Object unresolvedValue = this.input.get(VALUE.getName());
        Object resolvedValue = new ConfigurableInterpolationEvaluation(context, type, unresolvedValue, context.getInputOrDefault(INTERPOLATION_MODE), context.getInputOrDefault(INTERPOLATION_ERRORS)).evaluate();
        Object oldValue = SetVariableWorkflowStep.setWorkflowScratchVariableDotSeparated(context, name, resolvedValue);
        return context.getPreviousStepOutput();
    }

    static Object setWorkflowScratchVariableDotSeparated(WorkflowStepInstanceExecutionContext context, String name, Object resolvedValue) {
        Object oldValue;
        if (name.contains(".")) {
            String[] names = name.split("\\.");
            String names0 = names[0];
            if ("output".equals(names0)) {
                throw new IllegalArgumentException("Cannot set subfield in output");
            }
            Object h = context.getWorkflowExectionContext().getWorkflowScratchVariables().get(names0);
            if (!(h instanceof Map)) {
                throw new IllegalArgumentException("Cannot set " + name + " because " + names0 + " is " + (h == null ? "unset" : "not a map"));
            }
            for (int i = 1; i < names.length - 1; ++i) {
                Object hi = ((Map)h).get(names[i]);
                if (hi == null) {
                    hi = MutableMap.of();
                    ((Map)h).put(names[i], hi);
                } else if (!(hi instanceof Map)) {
                    throw new IllegalArgumentException("Cannot set " + name + " because " + names[i] + " is not a map");
                }
                h = hi;
            }
            oldValue = ((Map)h).put(names[names.length - 1], resolvedValue);
        } else if (name.contains("[")) {
            String[] names = name.split("((?<=\\[|\\])|(?=\\[|\\]))");
            if (names.length != 4 || !"[".equals(names[1]) || !"]".equals(names[3])) {
                throw new IllegalArgumentException("Invalid list index specifier " + name);
            }
            String listName = names[0];
            int listIndex = Integer.parseInt(names[2]);
            Object o = context.getWorkflowExectionContext().getWorkflowScratchVariables().get(listName);
            if (!(o instanceof List)) {
                throw new IllegalArgumentException("Cannot set " + name + " because " + listName + " is " + (o == null ? "unset" : "not a list"));
            }
            MutableList l = MutableList.copyOf((Iterable)((List)o));
            if (listIndex < 0 || listIndex >= l.size()) {
                throw new IllegalArgumentException("Invalid list index " + listIndex);
            }
            oldValue = l.set(listIndex, resolvedValue);
            context.getWorkflowExectionContext().updateWorkflowScratchVariable(listName, l);
        } else {
            oldValue = context.getWorkflowExectionContext().updateWorkflowScratchVariable(name, resolvedValue);
        }
        return oldValue;
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }

    public static class ConfigurableInterpolationEvaluation<T> {
        protected final WorkflowStepInstanceExecutionContext context;
        protected final TypeToken<T> type;
        protected final Object unresolvedValue;
        protected final InterpolationMode interpolationMode;
        protected final TemplateProcessor.InterpolationErrorMode errorMode;

        public ConfigurableInterpolationEvaluation(WorkflowStepInstanceExecutionContext context, TypeToken<T> type, Object unresolvedValue) {
            this(context, type, unresolvedValue, null, null);
        }

        public ConfigurableInterpolationEvaluation(WorkflowStepInstanceExecutionContext context, TypeToken<T> type, Object unresolvedValue, InterpolationMode interpolationMode, TemplateProcessor.InterpolationErrorMode errorMode) {
            this.context = context;
            this.unresolvedValue = unresolvedValue;
            this.type = type;
            this.interpolationMode = interpolationMode;
            this.errorMode = errorMode;
        }

        public boolean unquotedStartsWith(String s, char c) {
            if (s == null) {
                return false;
            }
            s = s.trim();
            s = Strings.removeFromStart((String)s, (String)"\"");
            s = Strings.removeFromStart((String)s, (String)"'");
            s = s.trim();
            return s.startsWith("" + c);
        }

        public boolean trimmedEndsWithQuote(String s) {
            if (s == null) {
                return false;
            }
            return (s = s.trim()).endsWith("\"") || s.endsWith("'");
        }

        public Function<String, TypeToken<?>> ifUnquotedStartsWithThen(char c, Class<?> clazz) {
            return s -> !this.unquotedStartsWith((String)s, c) ? null : TypeToken.of((Class)clazz);
        }

        public T evaluate() {
            T resultCoerced;
            TypeToken<T> typeIntermediate;
            Object result = this.unresolvedValue;
            TypeToken<T> typeToken = typeIntermediate = this.type == null ? TypeToken.of(Object.class) : this.type;
            if (this.interpolationMode == InterpolationMode.DISABLED) {
                resultCoerced = this.context.getWorkflowExectionContext().resolveCoercingOnly(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, result, typeIntermediate);
            } else if (result instanceof String && this.interpolationMode == InterpolationMode.WORDS) {
                result = this.process((String)result);
                resultCoerced = this.context.getWorkflowExectionContext().resolveCoercingOnly(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, result, typeIntermediate);
            } else {
                resultCoerced = this.resolveSubPart(result, typeIntermediate);
            }
            return resultCoerced;
        }

        <T> T resolveSubPart(Object v, TypeToken<T> type) {
            return new WorkflowExpressionResolution(this.context.getWorkflowExectionContext(), WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, false, WorkflowExpressionResolution.WrappingMode.NONE, this.errorMode).resolveWithTemplates(v, type);
        }

        Object process(String input) {
            if (Strings.isBlank((CharSequence)input)) {
                return input;
            }
            QuotedStringTokenizer qst = this.qst(input);
            Object wordsByQuote = qst.isQuoted(input) ? MutableList.of((Object)input) : qst.remainderAsList();
            return this.process((List<String>)wordsByQuote);
        }

        QuotedStringTokenizer qst(String input) {
            return QuotedStringTokenizer.builder().includeQuotes(true).includeDelimiters(true).expectQuotesDelimited(true).failOnOpenQuote(true).build(input);
        }

        Object process(List<String> w) {
            return this.process(w, false);
        }

        Object process(List<String> w, boolean ternaryColonAllowed) {
            if (w.isEmpty()) {
                return null;
            }
            Maybe<Object> result = this.handleTokenIfPresent(w, false, (Map<String, BiFunction<List<String>, List<String>, Object>>)(ternaryColonAllowed ? MutableMap.of((Object)"?", this::handleTernaryCondition, (Object)":", this::handleTernaryArms) : MutableMap.of((Object)"?", this::handleTernaryCondition)));
            if (result.isPresent()) {
                return result.get();
            }
            result = this.handleTokenIfPresent(w, false, (Map<String, BiFunction<List<String>, List<String>, Object>>)MutableMap.of((Object)"??", this::handleNullish));
            if (result.isPresent()) {
                return result.get();
            }
            result = this.handleTokenIfPresent(w, true, (Map<String, BiFunction<List<String>, List<String>, Object>>)MutableMap.of((Object)"+", this::handleAdd, (Object)"-", this::handleSubtract));
            if (result.isPresent()) {
                return result.get();
            }
            result = this.handleTokenIfPresent(w, true, (Map<String, BiFunction<List<String>, List<String>, Object>>)MutableMap.of((Object)"*", this::handleMultiply, (Object)"/", this::handleDivide));
            if (result.isPresent()) {
                return result.get();
            }
            result = this.handleTokenIfPresent(w, true, (Map<String, BiFunction<List<String>, List<String>, Object>>)MutableMap.of((Object)"%", this::handleModulo));
            if (result.isPresent()) {
                return result.get();
            }
            result = this.handleTokenIfPresent(w, false, (Map<String, BiFunction<List<String>, List<String>, Object>>)MutableMap.of((Object)"==", this::handleEquals, (Object)"<", this::handleOrderedLessThan, (Object)"<=", this::handleOrderedLessThanOrEqual, (Object)">", this::handleOrderedGreaterThan, (Object)">=", this::handleOrderedGreaterThanOrEqual));
            if (result.isPresent()) {
                return result.get();
            }
            result = this.handleTokenIfPresent(w, false, (Map<String, BiFunction<List<String>, List<String>, Object>>)MutableMap.of((Object)"&&", this::handleBooleanAnd));
            if (result.isPresent()) {
                return result.get();
            }
            result = this.handleTokenIfPresent(w, false, (Map<String, BiFunction<List<String>, List<String>, Object>>)MutableMap.of((Object)"||", this::handleBooleanOr));
            if (result.isPresent()) {
                return result.get();
            }
            boolean resolveToString = w.size() > 1;
            QuotedStringTokenizer qst = this.qst("");
            List objs = w.stream().map(t -> {
                if (qst.isQuoted(t)) {
                    return qst.unwrapIfQuoted(t);
                }
                TypeToken target = resolveToString ? TypeToken.of(String.class) : TypeToken.of(Object.class);
                return this.resolveSubPart(t, target);
            }).collect(Collectors.toList());
            if (!resolveToString) {
                return objs.get(0);
            }
            return objs.stream().collect(Collectors.joining());
        }

        private Maybe<Object> handleTokenIfPresent(List<String> tokens, boolean startAtRight, Map<String, BiFunction<List<String>, List<String>, Object>> tokenProcessors) {
            for (int i0 = 0; i0 < tokens.size(); ++i0) {
                int i = startAtRight ? tokens.size() - 1 - i0 : i0;
                String t = tokens.get(i);
                BiFunction<List<String>, List<String>, Object> p = tokenProcessors.get(t);
                if (p == null) continue;
                List<String> lhs = this.trim(tokens.subList(0, i));
                List<String> rhs = this.trim(tokens.subList(i + 1, tokens.size()));
                return Maybe.of((Object)p.apply(lhs, rhs));
            }
            return Maybe.absent();
        }

        private List<String> trim(List<String> l) {
            if (!l.isEmpty() && Strings.isBlank((CharSequence)l.get(0))) {
                l = l.subList(1, l.size());
            }
            if (!l.isEmpty() && Strings.isBlank((CharSequence)l.get(l.size() - 1))) {
                l = l.subList(0, l.size() - 1);
            }
            return l;
        }

        Object handleNullish(List<String> lhs, List<String> rhs) {
            return this.processMaybe(lhs, null).or(() -> this.process(rhs));
        }

        Maybe<Object> processMaybe(List<String> lhs, Function<String, TypeToken<?>> explicitType) {
            try {
                Object result = this.process(lhs);
                if (result != null) {
                    return Maybe.of((Object)result);
                }
                return Maybe.absent((String)"null");
            }
            catch (Exception e) {
                if (Exceptions.isCausedByInterruptInAnyThread((Throwable)e) && !Thread.currentThread().isInterrupted()) {
                    return Maybe.absent((String)"unavailable");
                }
                Exceptions.propagateIfFatal((Throwable)e);
                if (log.isTraceEnabled()) {
                    log.trace("Non-fatal exception processing expression " + lhs + " (in context where there is an alterantive)", (Throwable)e);
                }
                return Maybe.absent((Throwable)e);
            }
        }

        Maybe<Integer> asInteger(Object x) {
            Maybe<Integer> xi = TypeCoercions.tryCoerce(x, Integer.class);
            Maybe<Double> xd = this.asDouble(x);
            if (xi.isAbsent() || xd.isAbsent()) {
                return xi;
            }
            if (Math.abs((Double)xd.get() - (double)((Integer)xi.get()).intValue()) < 1.0E-10) {
                return xi;
            }
            return Maybe.absent((String)"Double value does not match integer value");
        }

        Maybe<Double> asDouble(Object x) {
            Maybe<Double> v = TypeCoercions.tryCoerce(x, Double.class);
            if (v.isPresent() && !Double.isFinite((Double)v.get())) {
                return Maybe.absent(() -> new IllegalArgumentException("Value cannot be coerced to double: " + v));
            }
            return v;
        }

        Object applyMathOperator(String op, List<String> lhs0, List<String> rhs0, BiFunction<Integer, Integer, Number> ifInt, BiFunction<Double, Double, Number> ifDouble) {
            Object lhs = this.process(lhs0);
            Object rhs = this.process(rhs0);
            if ("+".equals(op)) {
                if (lhs instanceof Duration) {
                    if (rhs instanceof Instant || rhs instanceof Date) {
                        Object newRhs = lhs;
                        lhs = rhs;
                        rhs = newRhs;
                    } else {
                        return TypeCoercions.coerce(rhs, Duration.class).add((Duration)lhs);
                    }
                }
                if (lhs instanceof Instant) {
                    return TypeCoercions.coerce(rhs, Duration.class).addTo((Temporal)((Instant)lhs));
                }
                if (lhs instanceof Date) {
                    return new Timestamp((Instant)TypeCoercions.coerce(rhs, Duration.class).addTo((Temporal)((Date)lhs).toInstant()));
                }
            } else if ("-".equals(op)) {
                if (lhs instanceof Duration) {
                    return ((Duration)lhs).subtract(TypeCoercions.coerce(rhs, Duration.class));
                }
                if (lhs instanceof Instant) {
                    if (rhs instanceof Instant) {
                        return Duration.between((Instant)((Instant)rhs), (Instant)((Instant)lhs));
                    }
                    return TypeCoercions.coerce(rhs, Duration.class).multiply(-1L).addTo((Temporal)((Instant)lhs));
                }
                if (lhs instanceof Date) {
                    if (rhs instanceof Date) {
                        return Duration.between((Instant)((Date)rhs).toInstant(), (Instant)((Date)lhs).toInstant());
                    }
                    return new Timestamp((Instant)TypeCoercions.coerce(rhs, Duration.class).multiply(-1L).addTo((Temporal)((Date)lhs).toInstant()));
                }
            }
            Maybe<Integer> lhsI = this.asInteger(lhs);
            Maybe<Integer> rhsI = this.asInteger(rhs);
            if (lhsI.isPresent() && rhsI.isPresent()) {
                Number x = ifInt.apply((Integer)lhsI.get(), (Integer)rhsI.get());
                return this.asInteger(x).orMaybe(() -> this.asDouble(x)).get();
            }
            if (ifDouble != null) {
                Maybe<Double> lhsD = this.asDouble(lhs);
                Maybe<Double> rhsD = this.asDouble(rhs);
                if (lhsD.isPresent() && rhsD.isPresent()) {
                    return this.asDouble(ifDouble.apply((Double)lhsD.get(), (Double)rhsD.get())).get();
                }
                if (lhsD.isAbsent()) {
                    this.failOnInvalidArgument("left", op, lhs0, lhs);
                }
                if (rhsD.isAbsent()) {
                    this.failOnInvalidArgument("right", op, rhs0, rhs);
                }
            } else {
                if (lhsI.isAbsent()) {
                    this.failOnInvalidArgument("left", op, lhs0, lhs);
                }
                if (rhsI.isAbsent()) {
                    this.failOnInvalidArgument("right", op, rhs0, rhs);
                }
            }
            throw new IllegalArgumentException("Should not come here");
        }

        Object applyBooleanOperator(List<String> lhs0, List<String> rhs0, BiFunction<Boolean, Boolean, Boolean> biFn) {
            Object lhs = this.process(lhs0);
            Object rhs = this.process(rhs0);
            Maybe<Boolean> lhsB = this.asBoolean(lhs);
            Maybe<Boolean> rhsB = this.asBoolean(rhs);
            if (lhsB.isPresent() && rhsB.isPresent()) {
                return biFn.apply((Boolean)lhsB.get(), (Boolean)rhsB.get());
            }
            throw new IllegalArgumentException("Should not come here");
        }

        boolean applyComparison(List<String> lhs0, List<String> rhs0, Function<Integer, Boolean> test) {
            Object lhs = this.process(lhs0);
            Object rhs = this.process(rhs0);
            return DslPredicates.coercedCompare(lhs, rhs, test);
        }

        Maybe<Boolean> asBoolean(Object x) {
            return TypeCoercions.tryCoerce(x, Boolean.class);
        }

        private IllegalArgumentException failOnInvalidArgument(String side, String op, Object pre, Object post) {
            String msg = "Invalid " + side + " argument to operation '" + op + "'";
            String postS = "" + post;
            if (postS.contains("*") || postS.contains("+") || postS.contains("+") || postS.contains("/")) {
                msg = msg + "; mathematical operations must have spaces around them for disambiguation";
            }
            throw new IllegalArgumentException(msg + ": " + pre + " => " + post);
        }

        Object handleMultiply(List<String> lhs, List<String> rhs) {
            return this.applyMathOperator("*", lhs, rhs, (a, b) -> a * b, (a, b) -> a * b);
        }

        Object handleDivide(List<String> lhs, List<String> rhs) {
            return this.applyMathOperator("/", lhs, rhs, (a, b) -> 1.0 * (double)a.intValue() / (double)b.intValue(), (a, b) -> a / b);
        }

        Object handleBooleanAnd(List<String> lhs, List<String> rhs) {
            return this.applyBooleanOperator(lhs, rhs, (a, b) -> a != false && b != false);
        }

        Object handleBooleanOr(List<String> lhs, List<String> rhs) {
            return this.applyBooleanOperator(lhs, rhs, (a, b) -> a != false || b != false);
        }

        Object handleOrderedGreaterThan(List<String> lhs, List<String> rhs) {
            return this.applyComparison(lhs, rhs, v -> v > 0);
        }

        Object handleOrderedGreaterThanOrEqual(List<String> lhs, List<String> rhs) {
            return this.applyComparison(lhs, rhs, v -> v >= 0);
        }

        Object handleOrderedLessThan(List<String> lhs, List<String> rhs) {
            return this.applyComparison(lhs, rhs, v -> v < 0);
        }

        Object handleOrderedLessThanOrEqual(List<String> lhs, List<String> rhs) {
            return this.applyComparison(lhs, rhs, v -> v <= 0);
        }

        boolean handleEquals(List<String> lhs, List<String> rhs) {
            return DslPredicates.coercedEqual(this.process(lhs), this.process(rhs));
        }

        Object handleTernaryCondition(List<String> lhs0, List<String> rhs0) {
            Object lhs = this.process(lhs0);
            int questionIndex = rhs0.indexOf("?");
            int colonIndex = rhs0.indexOf(":");
            Object rhs = questionIndex > -1 && questionIndex < colonIndex ? this.handleNestedTernaryRhs(rhs0) : (questionIndex > -1 && colonIndex < questionIndex ? this.handleChainedTernaryRhs(rhs0) : this.process(rhs0, true));
            if (!(rhs instanceof TernaryArms)) {
                throw new IllegalArgumentException("Mismatched ternary ':' operator");
            }
            Maybe<Boolean> condition = this.asBoolean(lhs);
            if (condition.isPresent()) {
                if (((Boolean)condition.get()).booleanValue()) {
                    return this.process((List)rhs.getLeft());
                }
                return this.process((List)rhs.getRight());
            }
            throw new IllegalArgumentException("Leading term of ternary '" + lhs + "' does not evaluate to a boolean");
        }

        public TernaryArms handleNestedTernaryRhs(List<String> rhs) {
            int lastColonIndex = rhs.lastIndexOf(":");
            if (lastColonIndex == -1) {
                throw new IllegalArgumentException("Mismatched ternary ':' operator");
            }
            int firstColonIndex = rhs.indexOf(":");
            if (firstColonIndex == lastColonIndex) {
                return (TernaryArms)((Object)this.process(rhs));
            }
            return new TernaryArms(this.trim(rhs.subList(0, lastColonIndex)), this.trim(rhs.subList(lastColonIndex + 1, rhs.size())));
        }

        public TernaryArms handleChainedTernaryRhs(List<String> rhs) {
            int colonIndex = rhs.indexOf(":");
            if (colonIndex == -1) {
                throw new IllegalArgumentException("Mismatched ternary ':' operator");
            }
            return new TernaryArms(this.trim(rhs.subList(0, colonIndex)), this.trim(rhs.subList(colonIndex + 1, rhs.size())));
        }

        public Object handleTernaryArms(List<String> lhs0, List<String> rhs0) {
            return new TernaryArms(lhs0, rhs0);
        }

        Object handleAdd(List<String> lhs, List<String> rhs) {
            return this.applyMathOperator("+", lhs, rhs, (a, b) -> a + b, (a, b) -> a + b);
        }

        Object handleSubtract(List<String> lhs, List<String> rhs) {
            return this.applyMathOperator("-", lhs, rhs, (a, b) -> a - b, (a, b) -> a - b);
        }

        Object handleModulo(List<String> lhs, List<String> rhs) {
            return this.applyMathOperator("%", lhs, rhs, (a, b) -> a % b, null);
        }

        static class TernaryArms
        extends MutablePair<List<String>, List<String>> {
            public TernaryArms(List<String> lhs, List<String> rhs) {
                super(lhs, rhs);
            }
        }
    }

    private static enum LetMergeMode {
        NONE,
        SHALLOW,
        DEEP;

    }

    public static enum InterpolationMode {
        WORDS,
        DISABLED,
        FULL;

    }
}

