/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.all.JustProvider;
import org.jclouds.softlayer.domain.Address;
import org.jclouds.softlayer.domain.Datacenter;

@Singleton
public class DatacenterToLocation
implements Function<Datacenter, Location> {
    private final JustProvider provider;

    @Inject
    public DatacenterToLocation(JustProvider provider) {
        this.provider = (JustProvider)Preconditions.checkNotNull((Object)provider, (Object)"provider");
    }

    public Location apply(Datacenter datacenter) {
        return new LocationBuilder().id(datacenter.getName()).description(datacenter.getLongName()).scope(LocationScope.ZONE).iso3166Codes(this.createIso3166Codes(datacenter.getLocationAddress())).parent((Location)Iterables.getOnlyElement((Iterable)this.provider.get())).metadata((Map)ImmutableMap.of((Object)"name", (Object)datacenter.getName())).build();
    }

    private Iterable<String> createIso3166Codes(Address address) {
        if (address == null) {
            return ImmutableSet.of();
        }
        String country = Strings.nullToEmpty((String)address.getCountry()).trim();
        if (country.isEmpty()) {
            return ImmutableSet.of();
        }
        String state = Strings.nullToEmpty((String)address.getState()).trim();
        if (state.isEmpty()) {
            return ImmutableSet.of((Object)address.getCountry());
        }
        return ImmutableSet.of((Object)("" + country + "-" + state));
    }
}

