/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.collections;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.QuorumCheck;

public class CollectionFunctionals {
    public static Supplier<Integer> sizeSupplier(Iterable<?> collection) {
        return new SizeSupplier(collection);
    }

    public static Function<Iterable<?>, Integer> sizeFunction() {
        return CollectionFunctionals.sizeFunction(null);
    }

    public static Function<Iterable<?>, Integer> sizeFunction(Integer valueIfInputNull) {
        return new SizeFunction(valueIfInputNull);
    }

    public static <T> Function<Iterable<? extends T>, T> firstElement() {
        return new FirstElementFunction();
    }

    public static <K> Function<Map<K, ?>, Set<K>> keys() {
        return new KeysOfMapFunction();
    }

    public static <K> Function<Map<K, ?>, Integer> mapSize() {
        return CollectionFunctionals.mapSize(null);
    }

    public static <K> Function<Map<K, ?>, Integer> mapSize(Integer valueIfNull) {
        return Functions.compose(CollectionFunctionals.sizeFunction(valueIfNull), CollectionFunctionals.keys());
    }

    public static Predicate<Iterable<?>> equalsSetOf(Object ... target) {
        return CollectionFunctionals.equalsSet(Arrays.asList(target));
    }

    public static Predicate<Iterable<?>> equalsSet(Iterable<?> target) {
        return new EqualsSetPredicate(target);
    }

    public static Predicate<Iterable<?>> sizeEquals(int targetSize) {
        return Predicates.compose((Predicate)Predicates.equalTo((Object)targetSize), CollectionFunctionals.sizeFunction());
    }

    public static Predicate<Iterable<?>> empty() {
        return CollectionFunctionals.sizeEquals(0);
    }

    public static Predicate<Iterable<?>> emptyOrNull() {
        return Predicates.or((Predicate)Predicates.isNull(), CollectionFunctionals.sizeEquals(0));
    }

    public static Predicate<Iterable<?>> notEmpty() {
        return Predicates.not(CollectionFunctionals.emptyOrNull());
    }

    public static <K> Predicate<Map<K, ?>> mapSizeEquals(int targetSize) {
        return Predicates.compose((Predicate)Predicates.equalTo((Object)targetSize), CollectionFunctionals.mapSize());
    }

    public static <K> Predicate<Map<K, ?>> mapEmptyOrNull() {
        return Predicates.or((Predicate)Predicates.isNull(), CollectionFunctionals.mapSizeEquals(0));
    }

    public static <K> Predicate<Map<K, ?>> mapNotEmpty() {
        return Predicates.not(CollectionFunctionals.mapEmptyOrNull());
    }

    public static <T, I extends Iterable<T>> Function<I, List<T>> limit(int max) {
        return new LimitFunction(max);
    }

    public static <I, T extends Collection<I>> Predicate<T> contains(I item) {
        return new CollectionContains(item);
    }

    public static <T, TT extends Iterable<T>> Predicate<TT> all(Predicate<T> attributeSatisfies) {
        return CollectionFunctionals.quorum(QuorumCheck.QuorumChecks.all(), attributeSatisfies);
    }

    public static <T, TT extends Iterable<T>> Predicate<TT> any(Predicate<T> attributeSatisfies) {
        return CollectionFunctionals.quorum(QuorumCheck.QuorumChecks.atLeastOne(), attributeSatisfies);
    }

    public static <T, TT extends Iterable<T>> Predicate<TT> quorum(QuorumCheck quorumCheck, Predicate<T> attributeSatisfies) {
        return new QuorumSatisfies(quorumCheck, attributeSatisfies);
    }

    private static final class QuorumSatisfies<I, T extends Iterable<I>>
    implements Predicate<T> {
        private final Predicate<I> itemCheck;
        private final QuorumCheck quorumCheck;

        private QuorumSatisfies(QuorumCheck quorumCheck, Predicate<I> itemCheck) {
            this.itemCheck = (Predicate)Preconditions.checkNotNull(itemCheck, (Object)"itemCheck");
            this.quorumCheck = (QuorumCheck)Preconditions.checkNotNull((Object)quorumCheck, (Object)"quorumCheck");
        }

        public boolean apply(T input) {
            if (input == null) {
                return false;
            }
            int sizeHealthy = 0;
            int totalSize = 0;
            for (Object item : input) {
                ++totalSize;
                if (!this.itemCheck.apply(item)) continue;
                ++sizeHealthy;
            }
            return this.quorumCheck.isQuorate(sizeHealthy, totalSize);
        }

        public String toString() {
            return this.quorumCheck.toString() + "(" + this.itemCheck + ")";
        }
    }

    private static final class CollectionContains<I, T extends Collection<I>>
    implements Predicate<T> {
        private final I item;

        private CollectionContains(I item) {
            this.item = item;
        }

        public boolean apply(T input) {
            if (input == null) {
                return false;
            }
            return input.contains(this.item);
        }

        public String toString() {
            return "contains(" + this.item + ")";
        }
    }

    private static final class LimitFunction<T, I extends Iterable<T>>
    implements Function<I, List<T>> {
        private final int max;

        private LimitFunction(int max) {
            this.max = max;
        }

        public List<T> apply(I input) {
            if (input == null) {
                return null;
            }
            MutableList result = MutableList.of();
            for (Object i : input) {
                result.add(i);
                if (result.size() < this.max) continue;
                return result;
            }
            return result;
        }
    }

    public static final class AllTrueFunction
    extends AllEqualsFunction {
        public AllTrueFunction() {
            super(Boolean.TRUE);
        }

        @Override
        public String toString() {
            return "AllTrueFunction";
        }
    }

    public static class AllEqualsFunction
    implements Function<Iterable<?>, Comparable<?>> {
        private final Comparable<?> value;

        public AllEqualsFunction(Comparable<?> value) {
            if (Objects.isNull(value)) {
                throw new IllegalArgumentException("The value to compare all to must be defined");
            }
            this.value = value;
        }

        public Boolean apply(@Nullable Iterable<?> input) {
            if (Objects.isNull(input) || Iterables.isEmpty(input)) {
                return null;
            }
            return Iterables.all(input, this.value::equals);
        }

        public String toString() {
            return "AllEqualsFunction";
        }
    }

    public static final class FirstElementFunction<T>
    implements Function<Iterable<? extends T>, T> {
        public T apply(Iterable<? extends T> input) {
            if (input == null || Iterables.isEmpty(input)) {
                return null;
            }
            return (T)Iterables.get(input, (int)0);
        }

        public String toString() {
            return "firstElementFunction";
        }
    }

    public static final class SizeFunction
    implements Function<Iterable<?>, Integer> {
        private final Integer valueIfInputNull;

        private SizeFunction(Integer valueIfInputNull) {
            this.valueIfInputNull = valueIfInputNull;
        }

        public Integer apply(Iterable<?> input) {
            if (input == null) {
                return this.valueIfInputNull;
            }
            return Iterables.size(input);
        }

        public String toString() {
            return "sizeFunction";
        }
    }

    private static final class SizeSupplier
    implements Supplier<Integer> {
        private final Iterable<?> collection;

        private SizeSupplier(Iterable<?> collection) {
            this.collection = collection;
        }

        public Integer get() {
            return Iterables.size(this.collection);
        }

        public String toString() {
            return "sizeSupplier(" + this.collection + ")";
        }
    }

    private static final class KeysOfMapFunction<K>
    implements Function<Map<K, ?>, Set<K>> {
        private KeysOfMapFunction() {
        }

        public Set<K> apply(Map<K, ?> input) {
            if (input == null) {
                return null;
            }
            return input.keySet();
        }

        public String toString() {
            return "keys";
        }
    }

    private static final class EqualsSetPredicate
    implements Predicate<Iterable<?>> {
        private final Iterable<?> target;

        private EqualsSetPredicate(Iterable<?> target) {
            this.target = target;
        }

        public boolean apply(@Nullable Iterable<?> input) {
            if (input == null) {
                return false;
            }
            return Sets.newHashSet(this.target).equals(Sets.newHashSet(input));
        }
    }
}

