/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task.ssh;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.InputStream;
import java.io.Reader;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.task.ssh.SshPutTaskStub;
import org.apache.brooklyn.util.core.task.ssh.SshPutTaskWrapper;
import org.apache.brooklyn.util.stream.KnownSizeInputStream;
import org.apache.brooklyn.util.stream.ReaderInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshPutTaskFactory
extends SshPutTaskStub
implements TaskFactory<SshPutTaskWrapper> {
    private static final Logger log = LoggerFactory.getLogger(SshPutTaskFactory.class);
    private boolean dirty = false;

    public SshPutTaskFactory(String remoteFile) {
        this.remoteFile(remoteFile);
    }

    public SshPutTaskFactory(SshMachineLocation machine, String remoteFile) {
        this.machine(machine);
        this.remoteFile(remoteFile);
    }

    protected SshPutTaskFactory self() {
        return this;
    }

    protected void markDirty() {
        this.dirty = true;
    }

    public SshPutTaskFactory machine(SshMachineLocation machine) {
        this.markDirty();
        this.machine = machine;
        return this.self();
    }

    public SshPutTaskFactory remoteFile(String remoteFile) {
        this.remoteFile = remoteFile;
        return this.self();
    }

    public SshPutTaskFactory summary(String summary) {
        this.markDirty();
        this.summary = summary;
        return this.self();
    }

    public SshPutTaskFactory contents(String contents) {
        this.markDirty();
        this.contents = Suppliers.ofInstance((Object)KnownSizeInputStream.of((String)contents));
        return this.self();
    }

    public SshPutTaskFactory contents(byte[] contents) {
        this.markDirty();
        this.contents = Suppliers.ofInstance((Object)KnownSizeInputStream.of((byte[])contents));
        return this.self();
    }

    public SshPutTaskFactory contents(InputStream stream) {
        this.markDirty();
        this.contents = Suppliers.ofInstance((Object)stream);
        return this.self();
    }

    public SshPutTaskFactory contents(Supplier<InputStream> stream) {
        this.markDirty();
        this.contents = stream;
        return this.self();
    }

    public SshPutTaskFactory contents(Reader reader) {
        this.markDirty();
        this.contents = Suppliers.ofInstance((Object)new ReaderInputStream(reader));
        return this.self();
    }

    public SshPutTaskFactory allowFailure() {
        this.markDirty();
        this.allowFailure = true;
        return this.self();
    }

    public SshPutTaskFactory createDirectory() {
        this.markDirty();
        this.createDirectory = true;
        return this.self();
    }

    public SshPutTaskWrapper newTask() {
        this.dirty = false;
        return new SshPutTaskWrapper(this);
    }

    protected void finalize() throws Throwable {
        if (this.dirty) {
            log.warn("Task " + this + " was modified but modification was never used");
        }
        super.finalize();
    }
}

