/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client.ntlm;

import io.cloudsoft.winrm4j.client.encryption.ByteArrayUtils;
import io.cloudsoft.winrm4j.client.encryption.WinrmEncryptionUtils;
import io.cloudsoft.winrm4j.client.ntlm.NTCredentialsWithEncryption;
import io.cloudsoft.winrm4j.client.ntlm.forks.httpclient.NTLMEngineImpl;
import java.util.Arrays;

public class NtlmKeys {
    public static final byte[] CLIENT_SIGNING = "session key to client-to-server signing key magic constant\u0000".getBytes();
    public static final byte[] SERVER_SIGNING = "session key to server-to-client signing key magic constant\u0000".getBytes();
    public static final byte[] CLIENT_SEALING = "session key to client-to-server sealing key magic constant\u0000".getBytes();
    public static final byte[] SERVER_SEALING = "session key to server-to-client sealing key magic constant\u0000".getBytes();
    private final byte[] exportedSessionKey;
    private final long negotiateFlags;

    public NtlmKeys(NTLMEngineImpl.Type3Message signAndSealData) {
        this(signAndSealData.getExportedSessionKey(), signAndSealData.getType2Flags());
    }

    public NtlmKeys(byte[] exportedSessionKey, long negotiateFlags) {
        this.exportedSessionKey = exportedSessionKey;
        this.negotiateFlags = negotiateFlags;
    }

    public byte[] getExportedSessionKey() {
        return this.exportedSessionKey;
    }

    public long getNegotiateFlags() {
        return this.negotiateFlags;
    }

    public boolean hasNegotiateFlag(long flag) {
        return (this.negotiateFlags & flag) == flag;
    }

    public byte[] getSignKey(byte[] magicConstant) {
        return WinrmEncryptionUtils.md5digest(ByteArrayUtils.concat(this.exportedSessionKey, magicConstant));
    }

    public byte[] getSealKey(byte[] magicConstant) {
        if (this.hasNegotiateFlag(524288L)) {
            return this.getSealKeyNtlm2(magicConstant);
        }
        if (this.hasNegotiateFlag(128L)) {
            return this.getSealKeyNtlm1(magicConstant);
        }
        return this.exportedSessionKey;
    }

    private byte[] getSealKeyNtlm1(byte[] magicConstant) {
        throw new UnsupportedOperationException("LM KEY negotiate mode not implemented; use extended session security instead");
    }

    private byte[] getSealKeyNtlm2(byte[] magicConstant) {
        byte[] key1 = this.hasNegotiateFlag(0x20000000L) ? this.exportedSessionKey : (this.hasNegotiateFlag(0x80000000L) ? Arrays.copyOfRange(this.exportedSessionKey, 0, 7) : Arrays.copyOfRange(this.exportedSessionKey, 0, 5));
        return WinrmEncryptionUtils.md5digest(ByteArrayUtils.concat(key1, magicConstant));
    }

    public void apply(NTCredentialsWithEncryption credentials) {
        credentials.setNegotiateFlags(this.getNegotiateFlags());
        credentials.setClientSigningKey(this.getSignKey(CLIENT_SIGNING));
        credentials.setServerSigningKey(this.getSignKey(SERVER_SIGNING));
        credentials.setClientSealingKey(this.getSealKey(CLIENT_SEALING));
        credentials.setServerSealingKey(this.getSealKey(SERVER_SEALING));
    }

    public static class NegotiateFlags {
        public static final long NTLMSSP_NEGOTIATE_56 = 0x80000000L;
        public static final long NTLMSSP_NEGOTIATE_KEY_EXCH = 0x40000000L;
        public static final long NTLMSSP_NEGOTIATE_128 = 0x20000000L;
        public static final long NTLMSSP_RESERVED_R1 = 0x10000000L;
        public static final long NTLMSSP_RESERVED_R2 = 0x8000000L;
        public static final long NTLMSSP_RESERVED_R3 = 0x4000000L;
        public static final long NTLMSSP_NEGOTIATE_VERSION = 0x2000000L;
        public static final long NTLMSSP_RESERVED_R4 = 0x1000000L;
        public static final long NTLMSSP_NEGOTIATE_TARGET_INFO = 0x800000L;
        public static final long NTLMSSP_REQUEST_NON_NT_SESSION_KEY = 0x400000L;
        public static final long NTLMSSP_RESERVED_R5 = 0x200000L;
        public static final long NTLMSSP_NEGOTIATE_IDENTITY = 0x100000L;
        public static final long NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY = 524288L;
        public static final long NTLMSSP_RESERVED_R6 = 262144L;
        public static final long NTLMSSP_TARGET_TYPE_SERVER = 131072L;
        public static final long NTLMSSP_TARGET_TYPE_DOMAIN = 65536L;
        public static final long NTLMSSP_NEGOTIATE_ALWAYS_SIGN = 32768L;
        public static final long NTLMSSP_RESERVED_R7 = 16384L;
        public static final long NTLMSSP_NEGOTIATE_OEM_WORKSTATION_SUPPLIED = 8192L;
        public static final long NTLMSSP_NEGOTIATE_OEM_DOMAIN_SUPPLIED = 4096L;
        public static final long NTLMSSP_ANOYNMOUS = 2048L;
        public static final long NTLMSSP_RESERVED_R8 = 1024L;
        public static final long NTLMSSP_NEGOTIATE_NTLM = 512L;
        public static final long NTLMSSP_RESERVED_R9 = 256L;
        public static final long NTLMSSP_NEGOTIATE_LM_KEY = 128L;
        public static final long NTLMSSP_NEGOTIATE_DATAGRAM = 64L;
        public static final long NTLMSSP_NEGOTIATE_SEAL = 32L;
        public static final long NTLMSSP_NEGOTIATE_SIGN = 16L;
        public static final long NTLMSSP_RESERVED_R10 = 8L;
        public static final long NTLMSSP_REQUEST_TARGET = 4L;
        public static final long NTLMSSP_NEGOTIATE_OEM = 2L;
        public static final long NTLMSSP_NEGOTIATE_UNICODE = 1L;
    }
}

