/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.transform;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationDefinition;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.location.BasicLocationDefinition;
import org.apache.brooklyn.core.location.CatalogLocationResolver;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.rest.api.LocationApi;
import org.apache.brooklyn.rest.domain.CatalogLocationSummary;
import org.apache.brooklyn.rest.domain.LocationSummary;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.transform.CatalogTransformer;
import org.apache.brooklyn.rest.util.BrooklynRestResourceUtils;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationTransformer {
    private static final Logger log = LoggerFactory.getLogger(LocationDetailLevel.class);
    private static boolean LEGACY_SPEC_WARNING = false;

    private static LocationSummary newInstance(ManagementContext mgmt, LocationSpec<? extends Location> spec, ConfigBag explicitConfig, String optionalExplicitId, String name, String specString, LocationDetailLevel level, UriBuilder ub) {
        RegisteredType ci;
        Object config = MutableMap.copyOf((Map)(explicitConfig == null ? null : explicitConfig.getAllConfig()));
        if (spec != null && (level == LocationDetailLevel.FULL_EXCLUDING_SECRET || level == LocationDetailLevel.FULL_INCLUDING_SECRET)) {
            config = ConfigBag.newInstance((Map)spec.getFlags()).putAll(spec.getConfig()).putAll((Map)config).getAllConfig();
        } else if (level == LocationDetailLevel.LOCAL_EXCLUDING_SECRET && spec != null && !explicitConfig.containsKey(LocationConfigKeys.DISPLAY_NAME)) {
            if (Strings.isNonBlank((CharSequence)((String)spec.getFlags().get(LocationConfigKeys.DISPLAY_NAME.getName())))) {
                config.put(LocationConfigKeys.DISPLAY_NAME.getName(), spec.getFlags().get(LocationConfigKeys.DISPLAY_NAME.getName()));
            } else if (Strings.isNonBlank((CharSequence)spec.getDisplayName())) {
                config.put(LocationConfigKeys.DISPLAY_NAME.getName(), spec.getDisplayName());
            }
        }
        String id = Strings.isNonBlank((CharSequence)optionalExplicitId) ? optionalExplicitId : (spec != null && Strings.isNonBlank((CharSequence)spec.getCatalogItemId()) ? spec.getCatalogItemId() : null);
        URI selfUri = WebResourceUtils.serviceUriBuilder(ub, LocationApi.class, "get").build(new Object[]{id});
        CatalogLocationSummary catalogSummary = null;
        if (CatalogLocationResolver.isLegacyWrappedReference((String)specString) && (ci = mgmt.getTypeRegistry().get(CatalogLocationResolver.unwrapLegacyWrappedReference((String)specString))) != null) {
            BrooklynRestResourceUtils br = new BrooklynRestResourceUtils(mgmt);
            catalogSummary = CatalogTransformer.catalogLocationSummary(br, ci, ub);
        }
        return new LocationSummary(id, Strings.isNonBlank((CharSequence)name) ? name : (spec != null ? spec.getDisplayName() : null), Strings.isNonBlank((CharSequence)specString) ? specString : (spec != null ? spec.getCatalogItemId() : null), null, LocationTransformer.copyConfig(config, level, AbstractBrooklynRestResource.RestValueResolver.resolving(mgmt, null)), catalogSummary, (Map)ImmutableMap.of((Object)"self", (Object)selfUri));
    }

    public static LocationSummary newInstance(ManagementContext mgmt, String id, org.apache.brooklyn.rest.domain.LocationSpec locationSpec, LocationDetailLevel level, UriBuilder ub) {
        BasicLocationDefinition ld = new BasicLocationDefinition(id, locationSpec.getName(), locationSpec.getSpec(), locationSpec.getConfig());
        return LocationTransformer.newInstance(mgmt, (LocationDefinition)ld, level, ub);
    }

    public static LocationSummary newInstance(ManagementContext mgmt, LocationDefinition ld, LocationDetailLevel level, UriBuilder ub) {
        return LocationTransformer.newInstance(mgmt, (LocationSpec<? extends Location>)((LocationSpec)mgmt.getLocationRegistry().getLocationSpec(ld).orNull()), ConfigBag.newInstance((Map)ld.getConfig()), ld.getId(), ld.getName(), ld.getSpec(), level, ub);
    }

    private static Map<String, ?> copyConfig(Map<String, ?> entries, LocationDetailLevel level, AbstractBrooklynRestResource.RestValueResolver resolver) {
        MutableMap.Builder builder = MutableMap.builder();
        if (level != LocationDetailLevel.NONE) {
            for (Map.Entry<String, ?> entry : entries.entrySet()) {
                if (level != LocationDetailLevel.FULL_INCLUDING_SECRET && Sanitizer.IS_SECRET_PREDICATE.apply((Object)entry.getKey())) continue;
                builder.put((Object)entry.getKey(), resolver.getValueForDisplay(entry.getValue(), true, false, Sanitizer.IS_SECRET_PREDICATE.apply((Object)entry.getKey()) ? Boolean.valueOf(false) : null));
            }
        }
        return builder.build();
    }

    public static LocationSummary newInstance(ManagementContext mgmt, Location l, LocationDetailLevel level, UriBuilder ub) {
        Maybe dn;
        String spec = null;
        String specId = null;
        for (Location lp = l; lp != null && (spec == null || specId == null); lp = lp.getParent()) {
            Maybe originalSpec;
            if (spec == null && (originalSpec = ((LocationInternal)lp).config().getRaw(LocationInternal.ORIGINAL_SPEC)).isPresent()) {
                spec = Strings.toString((Object)originalSpec.get());
            }
            if (specId != null) continue;
            LocationDefinition ld = null;
            if (spec != null) {
                ld = mgmt.getLocationRegistry().getDefinedLocationByName(spec);
            }
            if (ld == null && spec != null && spec.startsWith("named:")) {
                ld = mgmt.getLocationRegistry().getDefinedLocationByName(Strings.removeFromStart((String)spec, (String)"named:"));
            }
            if (ld == null) {
                ld = mgmt.getLocationRegistry().getDefinedLocationById(lp.getId());
            }
            if (ld == null) continue;
            if (spec == null) {
                spec = ld.getSpec();
            }
            specId = ld.getId();
        }
        if (specId == null && spec != null) {
            Location ll;
            if (!LEGACY_SPEC_WARNING) {
                log.warn("Legacy spec lookup required for rest summary of " + l);
                LEGACY_SPEC_WARNING = true;
            }
            if ((ll = (Location)mgmt.getLocationRegistry().resolve(spec, Boolean.valueOf(false), null).orNull()) != null) {
                specId = ll.getId();
            }
        }
        ConfigBag configOrig = ConfigBag.newInstance();
        if (level == LocationDetailLevel.LOCAL_EXCLUDING_SECRET) {
            configOrig.putAll(((LocationInternal)l).config().getInternalConfigMap().getAllConfigLocalRaw());
        } else {
            configOrig.putAll(((LocationInternal)l).config().getInternalConfigMap().getAllConfigInheritedRawValuesIgnoringErrors());
        }
        if (level == LocationDetailLevel.LOCAL_EXCLUDING_SECRET && !configOrig.containsKey(LocationConfigKeys.DISPLAY_NAME) && (dn = ((LocationInternal)l).config().getRaw(LocationConfigKeys.DISPLAY_NAME)).isPresent()) {
            configOrig.configure(LocationConfigKeys.DISPLAY_NAME, l.config().get(LocationConfigKeys.DISPLAY_NAME));
        }
        Map<String, ?> config = level == LocationDetailLevel.NONE ? null : LocationTransformer.copyConfig(configOrig.getAllConfig(), level, AbstractBrooklynRestResource.RestValueResolver.resolving(mgmt, null));
        URI selfUri = WebResourceUtils.serviceUriBuilder(ub, LocationApi.class, "get").build(new Object[]{l.getId()});
        URI parentUri = l.getParent() == null ? null : WebResourceUtils.serviceUriBuilder(ub, LocationApi.class, "get").build(new Object[]{l.getParent().getId()});
        URI specUri = specId == null ? null : WebResourceUtils.serviceUriBuilder(ub, LocationApi.class, "get").build(new Object[]{specId});
        return new LocationSummary(l.getId(), l.getDisplayName(), spec, l.getClass().getName(), config, null, MutableMap.of((Object)"self", (Object)selfUri).addIfNotNull((Object)"parent", (Object)parentUri).addIfNotNull((Object)"spec", (Object)specUri).asUnmodifiable());
    }

    public static LocationSummary newInstance(ManagementContext mgmt, String id, LocationDetailLevel level, UriBuilder uriBuilder) {
        Location l1 = mgmt.getLocationManager().getLocation(id);
        if (l1 != null) {
            return LocationTransformer.newInstance(mgmt, l1, level, uriBuilder);
        }
        LocationDefinition l2 = mgmt.getLocationRegistry().getDefinedLocationById(id);
        if (l2 != null) {
            return LocationTransformer.newInstance(mgmt, l2, level, uriBuilder);
        }
        return null;
    }

    public static enum LocationDetailLevel {
        NONE,
        LOCAL_EXCLUDING_SECRET,
        FULL_EXCLUDING_SECRET,
        FULL_INCLUDING_SECRET;

    }
}

