/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.agentproxy.sshj;

import com.jcraft.jsch.agentproxy.AgentProxy;
import com.jcraft.jsch.agentproxy.Identity;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AbstractAuthMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthAgent
extends AbstractAuthMethod {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AgentProxy agentProxy;
    private final Identity identity;
    private final String algorithm;
    private final String comment;

    public AuthAgent(AgentProxy agentProxy, Identity identity) throws Buffer.BufferException {
        super("publickey");
        this.agentProxy = agentProxy;
        this.identity = identity;
        this.comment = new String(identity.getComment());
        this.algorithm = new Buffer.PlainBuffer(identity.getBlob()).readString();
    }

    public void handle(Message cmd, SSHPacket buf) throws UserAuthException, TransportException {
        if (cmd == Message.USERAUTH_60) {
            this.sendSignedReq();
        } else {
            super.handle(cmd, buf);
        }
    }

    protected SSHPacket putPubKey(SSHPacket reqBuf) throws UserAuthException {
        ((SSHPacket)((SSHPacket)reqBuf.putString(this.algorithm)).putBytes(this.identity.getBlob())).getCompactData();
        return reqBuf;
    }

    private SSHPacket putSig(SSHPacket reqBuf) throws UserAuthException {
        byte[] dataToSign = ((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(this.params.getTransport().getSessionID())).putBuffer((Buffer)reqBuf)).getCompactData();
        reqBuf.putBytes(this.agentProxy.sign(this.identity.getBlob(), dataToSign));
        return reqBuf;
    }

    private void sendSignedReq() throws UserAuthException, TransportException {
        this.params.getTransport().write(this.putSig(this.buildReq(true)));
    }

    private SSHPacket buildReq(boolean signed) throws UserAuthException {
        this.log.debug("Attempting authentication using agent identity {}", (Object)this.comment);
        return this.putPubKey((SSHPacket)super.buildReq().putBoolean(signed));
    }

    protected SSHPacket buildReq() throws UserAuthException {
        return this.buildReq(false);
    }
}

