/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.IOException;
import java.util.Properties;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.MembershipProvider;
import org.apache.catalina.tribes.MembershipService;
import org.apache.catalina.tribes.membership.StaticMember;
import org.apache.catalina.tribes.util.UUIDGenerator;

public class WkaMembershipService
implements MembershipService {
    private final MembershipManager membershipManager;
    private MembershipProvider membershipProvider;
    private Channel channel;
    protected Properties properties = new Properties();
    protected byte[] payload;
    protected byte[] domain;

    public WkaMembershipService(MembershipManager membershipManager) {
        this.membershipManager = membershipManager;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void start() throws Exception {
    }

    public void start(int i) throws Exception {
    }

    public void stop(int i) {
    }

    public boolean hasMembers() {
        return this.membershipManager.hasMembers();
    }

    public Member getMember(Member member) {
        return this.membershipManager.getMember(member);
    }

    public Member[] getMembers() {
        return this.membershipManager.getMembers();
    }

    public Member getLocalMember(boolean b) {
        return this.membershipManager.getLocalMember();
    }

    public String[] getMembersByName() {
        String[] membernames;
        Member[] currentMembers = this.getMembers();
        if (currentMembers != null) {
            membernames = new String[currentMembers.length];
            for (int i = 0; i < currentMembers.length; ++i) {
                membernames[i] = currentMembers[i].toString();
            }
        } else {
            membernames = new String[]{};
        }
        return membernames;
    }

    public Member findMemberByName(String name) {
        Member[] currentMembers;
        for (Member currentMember : currentMembers = this.getMembers()) {
            if (!name.equals(currentMember.toString())) continue;
            return currentMember;
        }
        return null;
    }

    public void setLocalMemberProperties(String s, int i, int i1, int i2) {
    }

    public void setLocalMemberProperties(String listenHost, int listenPort) {
        this.properties.setProperty("tcpListenHost", listenHost);
        this.properties.setProperty("tcpListenPort", String.valueOf(listenPort));
        StaticMember localMember = (StaticMember)this.membershipManager.getLocalMember();
        try {
            if (localMember != null) {
                localMember.setHostname(listenHost);
                localMember.setPort(listenPort);
            } else {
                localMember = new StaticMember(listenHost, listenPort, 0L);
                localMember.setUniqueId(UUIDGenerator.randomUUID((boolean)true));
                localMember.setPayload(this.payload);
                localMember.setDomain(this.domain);
                this.membershipManager.setLocalMember((Member)localMember);
            }
            localMember.getData(true, true);
        }
        catch (IOException x) {
            throw new IllegalArgumentException(x);
        }
    }

    public void setMembershipListener(MembershipListener membershipListener) {
    }

    public void removeMembershipListener() {
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
        ((StaticMember)this.membershipManager.getLocalMember()).setPayload(payload);
    }

    public void setDomain(byte[] domain) {
        this.domain = domain;
        ((StaticMember)this.membershipManager.getLocalMember()).setDomain(domain);
    }

    public void broadcast(ChannelMessage channelMessage) throws ChannelException {
    }

    public MembershipProvider getMembershipProvider() {
        return this.membershipProvider;
    }

    public void setMembershipProvider(MembershipProvider memberProvider) {
        this.membershipProvider = memberProvider;
    }
}

