/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.Util;

public class HelpFormatter {
    public static final int DEFAULT_WIDTH = 74;
    public static final int DEFAULT_LEFT_PAD = 1;
    public static final int DEFAULT_DESC_PAD = 3;
    public static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    public static final String DEFAULT_OPT_PREFIX = "-";
    public static final String DEFAULT_LONG_OPT_PREFIX = "--";
    public static final String DEFAULT_LONG_OPT_SEPARATOR = " ";
    public static final String DEFAULT_ARG_NAME = "arg";
    @Deprecated
    public int defaultWidth = 74;
    @Deprecated
    public int defaultLeftPad = 1;
    @Deprecated
    public int defaultDescPad = 3;
    @Deprecated
    public String defaultSyntaxPrefix = "usage: ";
    @Deprecated
    public String defaultNewLine = System.lineSeparator();
    @Deprecated
    public String defaultOptPrefix = "-";
    @Deprecated
    public String defaultLongOptPrefix = "--";
    @Deprecated
    public String defaultArgName = "arg";
    protected Comparator<Option> optionComparator = new OptionComparator();
    private final Function<Option, String> deprecatedFormatFunc;
    private final PrintWriter printWriter;
    private String longOptSeparator = " ";

    public static Builder builder() {
        return new Builder();
    }

    private static PrintWriter createDefaultPrintWriter() {
        return new PrintWriter(System.out);
    }

    public static String getDescription(Option option) {
        String desc = option.getDescription();
        return desc == null ? "" : desc;
    }

    public HelpFormatter() {
        this(null, HelpFormatter.createDefaultPrintWriter());
    }

    private HelpFormatter(Function<Option, String> deprecatedFormatFunc, PrintWriter printStream) {
        this.deprecatedFormatFunc = deprecatedFormatFunc;
        this.printWriter = printStream;
    }

    private void appendOption(StringBuffer buff, Option option, boolean required) {
        if (!required) {
            buff.append("[");
        }
        if (option.getOpt() != null) {
            buff.append(DEFAULT_OPT_PREFIX).append(option.getOpt());
        } else {
            buff.append(DEFAULT_LONG_OPT_PREFIX).append(option.getLongOpt());
        }
        if (option.hasArg() && (option.getArgName() == null || !option.getArgName().isEmpty())) {
            buff.append(option.getOpt() == null ? this.longOptSeparator : DEFAULT_LONG_OPT_SEPARATOR);
            buff.append("<").append(option.getArgName() != null ? option.getArgName() : this.getArgName()).append(">");
        }
        if (!required) {
            buff.append("]");
        }
    }

    private void appendOptionGroup(StringBuffer buff, OptionGroup group) {
        if (!group.isRequired()) {
            buff.append("[");
        }
        ArrayList<Option> optList = new ArrayList<Option>(group.getOptions());
        if (this.getOptionComparator() != null) {
            Collections.sort(optList, this.getOptionComparator());
        }
        Iterator it = optList.iterator();
        while (it.hasNext()) {
            this.appendOption(buff, (Option)it.next(), true);
            if (!it.hasNext()) continue;
            buff.append(" | ");
        }
        if (!group.isRequired()) {
            buff.append("]");
        }
    }

    protected String createPadding(int len) {
        char[] padding = new char[len];
        Arrays.fill(padding, ' ');
        return new String(padding);
    }

    protected int findWrapPos(String text, int width, int startPos) {
        char c;
        int pos = text.indexOf(10, startPos);
        if (pos != -1 && pos <= width) {
            return pos + 1;
        }
        pos = text.indexOf(9, startPos);
        if (pos != -1 && pos <= width) {
            return pos + 1;
        }
        if (startPos + width >= text.length()) {
            return -1;
        }
        for (pos = startPos + width; pos >= startPos && (c = text.charAt(pos)) != ' ' && c != '\n' && c != '\r'; --pos) {
        }
        if (pos > startPos) {
            return pos;
        }
        pos = startPos + width;
        return pos == text.length() ? -1 : pos;
    }

    public String getArgName() {
        return this.defaultArgName;
    }

    public int getDescPadding() {
        return this.defaultDescPad;
    }

    public int getLeftPadding() {
        return this.defaultLeftPad;
    }

    public String getLongOptPrefix() {
        return this.defaultLongOptPrefix;
    }

    public String getLongOptSeparator() {
        return this.longOptSeparator;
    }

    public String getNewLine() {
        return this.defaultNewLine;
    }

    public Comparator<Option> getOptionComparator() {
        return this.optionComparator;
    }

    public String getOptPrefix() {
        return this.defaultOptPrefix;
    }

    public String getSyntaxPrefix() {
        return this.defaultSyntaxPrefix;
    }

    public int getWidth() {
        return this.defaultWidth;
    }

    public void printHelp(int width, String cmdLineSyntax, String header, Options options, String footer) {
        this.printHelp(width, cmdLineSyntax, header, options, footer, false);
    }

    public void printHelp(int width, String cmdLineSyntax, String header, Options options, String footer, boolean autoUsage) {
        PrintWriter pw = new PrintWriter(this.printWriter);
        this.printHelp(pw, width, cmdLineSyntax, header, options, this.getLeftPadding(), this.getDescPadding(), footer, autoUsage);
        pw.flush();
    }

    public void printHelp(PrintWriter pw, int width, String cmdLineSyntax, String header, Options options, int leftPad, int descPad, String footer) {
        this.printHelp(pw, width, cmdLineSyntax, header, options, leftPad, descPad, footer, false);
    }

    public void printHelp(PrintWriter pw, int width, String cmdLineSyntax, String header, Options options, int leftPad, int descPad, String footer, boolean autoUsage) {
        if (Util.isEmpty(cmdLineSyntax)) {
            throw new IllegalArgumentException("cmdLineSyntax not provided");
        }
        if (autoUsage) {
            this.printUsage(pw, width, cmdLineSyntax, options);
        } else {
            this.printUsage(pw, width, cmdLineSyntax);
        }
        if (header != null && !header.isEmpty()) {
            this.printWrapped(pw, width, header);
        }
        this.printOptions(pw, width, options, leftPad, descPad);
        if (footer != null && !footer.isEmpty()) {
            this.printWrapped(pw, width, footer);
        }
    }

    public void printHelp(String cmdLineSyntax, Options options) {
        this.printHelp(this.getWidth(), cmdLineSyntax, null, options, null, false);
    }

    public void printHelp(String cmdLineSyntax, Options options, boolean autoUsage) {
        this.printHelp(this.getWidth(), cmdLineSyntax, null, options, null, autoUsage);
    }

    public void printHelp(String cmdLineSyntax, String header, Options options, String footer) {
        this.printHelp(cmdLineSyntax, header, options, footer, false);
    }

    public void printHelp(String cmdLineSyntax, String header, Options options, String footer, boolean autoUsage) {
        this.printHelp(this.getWidth(), cmdLineSyntax, header, options, footer, autoUsage);
    }

    public void printOptions(PrintWriter pw, int width, Options options, int leftPad, int descPad) {
        StringBuffer sb = new StringBuffer();
        this.renderOptions(sb, width, options, leftPad, descPad);
        pw.println(sb.toString());
    }

    public void printUsage(PrintWriter pw, int width, String cmdLineSyntax) {
        int argPos = cmdLineSyntax.indexOf(32) + 1;
        this.printWrapped(pw, width, this.getSyntaxPrefix().length() + argPos, this.getSyntaxPrefix() + cmdLineSyntax);
    }

    public void printUsage(PrintWriter pw, int width, String app, Options options) {
        StringBuffer buff = new StringBuffer(this.getSyntaxPrefix()).append(app).append(' ');
        ArrayList<OptionGroup> processedGroups = new ArrayList<OptionGroup>();
        ArrayList<Option> optList = new ArrayList<Option>(options.getOptions());
        if (this.getOptionComparator() != null) {
            Collections.sort(optList, this.getOptionComparator());
        }
        Iterator it = optList.iterator();
        while (it.hasNext()) {
            Option option = (Option)it.next();
            OptionGroup group = options.getOptionGroup(option);
            if (group != null) {
                if (!processedGroups.contains(group)) {
                    processedGroups.add(group);
                    this.appendOptionGroup(buff, group);
                }
            } else {
                this.appendOption(buff, option, option.isRequired());
            }
            if (!it.hasNext()) continue;
            buff.append(' ');
        }
        this.printWrapped(pw, width, buff.toString().indexOf(32) + 1, buff.toString());
    }

    public void printWrapped(PrintWriter pw, int width, int nextLineTabStop, String text) {
        StringBuffer sb = new StringBuffer(text.length());
        this.renderWrappedTextBlock(sb, width, nextLineTabStop, text);
        pw.println(sb.toString());
    }

    public void printWrapped(PrintWriter pw, int width, String text) {
        this.printWrapped(pw, width, 0, text);
    }

    protected StringBuffer renderOptions(StringBuffer sb, int width, Options options, int leftPad, int descPad) {
        String lpad = this.createPadding(leftPad);
        String dpad = this.createPadding(descPad);
        int max = 0;
        ArrayList<StringBuffer> prefixList = new ArrayList<StringBuffer>();
        List<Option> optList = options.helpOptions();
        if (this.getOptionComparator() != null) {
            Collections.sort(optList, this.getOptionComparator());
        }
        for (Option option : optList) {
            StringBuffer optBuf = new StringBuffer();
            if (option.getOpt() == null) {
                optBuf.append(lpad).append("   ").append(this.getLongOptPrefix()).append(option.getLongOpt());
            } else {
                optBuf.append(lpad).append(this.getOptPrefix()).append(option.getOpt());
                if (option.hasLongOpt()) {
                    optBuf.append(',').append(this.getLongOptPrefix()).append(option.getLongOpt());
                }
            }
            if (option.hasArg()) {
                String argName = option.getArgName();
                if (argName != null && argName.isEmpty()) {
                    optBuf.append(' ');
                } else {
                    optBuf.append(option.hasLongOpt() ? this.longOptSeparator : DEFAULT_LONG_OPT_SEPARATOR);
                    optBuf.append("<").append(argName != null ? option.getArgName() : this.getArgName()).append(">");
                }
            }
            prefixList.add(optBuf);
            max = Math.max(optBuf.length(), max);
        }
        int x = 0;
        Iterator<Option> it = optList.iterator();
        while (it.hasNext()) {
            StringBuilder optBuf;
            Option option = it.next();
            if ((optBuf = new StringBuilder(((StringBuffer)prefixList.get(x++)).toString())).length() < max) {
                optBuf.append(this.createPadding(max - optBuf.length()));
            }
            optBuf.append(dpad);
            int nextLineTabStop = max + descPad;
            if (this.deprecatedFormatFunc != null && option.isDeprecated()) {
                optBuf.append(this.deprecatedFormatFunc.apply(option).trim());
            } else if (option.getDescription() != null) {
                optBuf.append(option.getDescription());
            }
            this.renderWrappedText(sb, width, nextLineTabStop, optBuf.toString());
            if (!it.hasNext()) continue;
            sb.append(this.getNewLine());
        }
        return sb;
    }

    protected StringBuffer renderWrappedText(StringBuffer sb, int width, int nextLineTabStop, String text) {
        String render = text;
        int nextLineTabStopPos = nextLineTabStop;
        int pos = this.findWrapPos(render, width, 0);
        if (pos == -1) {
            sb.append(this.rtrim(render));
            return sb;
        }
        sb.append(this.rtrim(render.substring(0, pos))).append(this.getNewLine());
        if (nextLineTabStopPos >= width) {
            nextLineTabStopPos = 1;
        }
        String padding = this.createPadding(nextLineTabStopPos);
        while (true) {
            if ((pos = this.findWrapPos(render = padding + render.substring(pos).trim(), width, 0)) == -1) {
                sb.append(render);
                return sb;
            }
            if (render.length() > width && pos == nextLineTabStopPos - 1) {
                pos = width;
            }
            sb.append(this.rtrim(render.substring(0, pos))).append(this.getNewLine());
        }
    }

    private Appendable renderWrappedTextBlock(StringBuffer sb, int width, int nextLineTabStop, String text) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(text));
            boolean firstLine = true;
            while ((line = in.readLine()) != null) {
                if (!firstLine) {
                    sb.append(this.getNewLine());
                } else {
                    firstLine = false;
                }
                this.renderWrappedText(sb, width, nextLineTabStop, line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb;
    }

    protected String rtrim(String s2) {
        int pos;
        if (Util.isEmpty(s2)) {
            return s2;
        }
        for (pos = s2.length(); pos > 0 && Character.isWhitespace(s2.charAt(pos - 1)); --pos) {
        }
        return s2.substring(0, pos);
    }

    public void setArgName(String name) {
        this.defaultArgName = name;
    }

    public void setDescPadding(int padding) {
        this.defaultDescPad = padding;
    }

    public void setLeftPadding(int padding) {
        this.defaultLeftPad = padding;
    }

    public void setLongOptPrefix(String prefix) {
        this.defaultLongOptPrefix = prefix;
    }

    public void setLongOptSeparator(String longOptSeparator) {
        this.longOptSeparator = longOptSeparator;
    }

    public void setNewLine(String newline) {
        this.defaultNewLine = newline;
    }

    public void setOptionComparator(Comparator<Option> comparator) {
        this.optionComparator = comparator;
    }

    public void setOptPrefix(String prefix) {
        this.defaultOptPrefix = prefix;
    }

    public void setSyntaxPrefix(String prefix) {
        this.defaultSyntaxPrefix = prefix;
    }

    public void setWidth(int width) {
        this.defaultWidth = width;
    }

    static /* synthetic */ PrintWriter access$000() {
        return HelpFormatter.createDefaultPrintWriter();
    }

    public static final class Builder
    implements Supplier<HelpFormatter> {
        private static final Function<Option, String> DEFAULT_DEPRECATED_FORMAT = o -> "[Deprecated] " + HelpFormatter.getDescription(o);
        private Function<Option, String> deprecatedFormatFunc = DEFAULT_DEPRECATED_FORMAT;
        private PrintWriter printStream = HelpFormatter.access$000();

        @Override
        public HelpFormatter get() {
            return new HelpFormatter(this.deprecatedFormatFunc, this.printStream);
        }

        public Builder setPrintWriter(PrintWriter printWriter) {
            this.printStream = Objects.requireNonNull(printWriter, "printWriter");
            return this;
        }

        public Builder setShowDeprecated(boolean useDefaultFormat) {
            return this.setShowDeprecated(useDefaultFormat ? DEFAULT_DEPRECATED_FORMAT : null);
        }

        public Builder setShowDeprecated(Function<Option, String> showDeprecatedFunc) {
            this.deprecatedFormatFunc = showDeprecatedFunc;
            return this;
        }
    }

    private static final class OptionComparator
    implements Comparator<Option>,
    Serializable {
        private static final long serialVersionUID = 5305467873966684014L;

        private OptionComparator() {
        }

        @Override
        public int compare(Option opt1, Option opt2) {
            return opt1.getKey().compareToIgnoreCase(opt2.getKey());
        }
    }
}

