/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ExtractRedundantVariablesInJoinRule
implements IAlgebraicRewriteRule {
    private final Map<LogicalVariable, List<Mutable<ILogicalExpression>>> variableToExpressionsMap = new HashMap<LogicalVariable, List<Mutable<ILogicalExpression>>>();
    private final Set<LogicalVariable> leftLiveVars = new HashSet<LogicalVariable>();

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.INNERJOIN && op.getOperatorTag() != LogicalOperatorTag.LEFTOUTERJOIN) {
            return false;
        }
        AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)op;
        if (!this.ensureAndExtractVarAndExpr((ILogicalExpression)joinOp.getCondition().getValue())) {
            return false;
        }
        this.setLeftLiveVariables(joinOp);
        ArrayList<LogicalVariable> leftAssignVars = new ArrayList<LogicalVariable>();
        ArrayList<Mutable<ILogicalExpression>> leftAssignExprs = new ArrayList<Mutable<ILogicalExpression>>();
        ArrayList<LogicalVariable> rightAssignVars = new ArrayList<LogicalVariable>();
        ArrayList<Mutable<ILogicalExpression>> rightAssignExprs = new ArrayList<Mutable<ILogicalExpression>>();
        for (Map.Entry<LogicalVariable, List<Mutable<ILogicalExpression>>> kv : this.variableToExpressionsMap.entrySet()) {
            LogicalVariable repeatedVariable = kv.getKey();
            List<Mutable<ILogicalExpression>> repeatedReferences = kv.getValue();
            if (this.leftLiveVars.contains(repeatedVariable)) {
                this.reassignRepeatedVariables(context, repeatedVariable, repeatedReferences, leftAssignVars, leftAssignExprs);
                continue;
            }
            this.reassignRepeatedVariables(context, repeatedVariable, repeatedReferences, rightAssignVars, rightAssignExprs);
        }
        SourceLocation sourceLocation = joinOp.getSourceLocation();
        if (!leftAssignVars.isEmpty()) {
            this.createAndSetAssign(context, sourceLocation, (Mutable<ILogicalOperator>)((Mutable)joinOp.getInputs().get(0)), leftAssignVars, leftAssignExprs);
        }
        if (!rightAssignVars.isEmpty()) {
            this.createAndSetAssign(context, sourceLocation, (Mutable<ILogicalOperator>)((Mutable)joinOp.getInputs().get(1)), rightAssignVars, rightAssignExprs);
        }
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)joinOp);
        return true;
    }

    private void createAndSetAssign(IOptimizationContext context, SourceLocation sourceLocation, Mutable<ILogicalOperator> joinInputRef, List<LogicalVariable> assignVars, List<Mutable<ILogicalExpression>> assignExprs) throws AlgebricksException {
        AssignOperator assignOp = new AssignOperator(assignVars, assignExprs);
        assignOp.setSourceLocation(sourceLocation);
        assignOp.getInputs().add(new MutableObject((Object)((ILogicalOperator)joinInputRef.getValue())));
        joinInputRef.setValue((Object)assignOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOp);
    }

    private void setLeftLiveVariables(AbstractBinaryJoinOperator op) throws AlgebricksException {
        ILogicalOperator leftOp = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        this.leftLiveVars.clear();
        VariableUtilities.getLiveVariables((ILogicalOperator)leftOp, this.leftLiveVars);
    }

    private void reassignRepeatedVariables(IOptimizationContext context, LogicalVariable repeatedVariable, List<Mutable<ILogicalExpression>> repeatedReferences, List<LogicalVariable> assignVars, List<Mutable<ILogicalExpression>> assignExprs) {
        for (int i = 1; i < repeatedReferences.size(); ++i) {
            Mutable<ILogicalExpression> exprRef = repeatedReferences.get(i);
            SourceLocation sourceLocation = ((ILogicalExpression)exprRef.getValue()).getSourceLocation();
            LogicalVariable newVar = context.newVar();
            exprRef.setValue((Object)new VariableReferenceExpression(newVar, sourceLocation));
            assignVars.add(newVar);
            assignExprs.add((Mutable<ILogicalExpression>)new MutableObject((Object)new VariableReferenceExpression(repeatedVariable, sourceLocation)));
            context.addNotToBeInlinedVar(newVar);
        }
    }

    private boolean ensureAndExtractVarAndExpr(ILogicalExpression expr) {
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        if (!AlgebricksBuiltinFunctions.AND.equals((Object)funcExpr.getFunctionIdentifier())) {
            return false;
        }
        this.variableToExpressionsMap.clear();
        boolean containsRepeatedReferences = false;
        for (Mutable argRef : funcExpr.getArguments()) {
            ILogicalExpression arg = (ILogicalExpression)argRef.getValue();
            if (arg.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                return false;
            }
            AbstractFunctionCallExpression argFuncExpr = (AbstractFunctionCallExpression)arg;
            if (!AlgebricksBuiltinFunctions.EQ.equals((Object)argFuncExpr.getFunctionIdentifier())) {
                return false;
            }
            List eqArgs = argFuncExpr.getArguments();
            Mutable leftRef = (Mutable)eqArgs.get(0);
            Mutable rightRef = (Mutable)eqArgs.get(1);
            ILogicalExpression left = (ILogicalExpression)leftRef.getValue();
            ILogicalExpression right = (ILogicalExpression)rightRef.getValue();
            LogicalVariable leftVar = VariableUtilities.getVariable((ILogicalExpression)left);
            LogicalVariable rightVar = VariableUtilities.getVariable((ILogicalExpression)right);
            if (leftVar == null || rightVar == null) {
                return false;
            }
            List leftList = this.variableToExpressionsMap.computeIfAbsent(leftVar, k -> new ArrayList());
            leftList.add(leftRef);
            List rightList = this.variableToExpressionsMap.computeIfAbsent(rightVar, k -> new ArrayList());
            rightList.add(rightRef);
            containsRepeatedReferences |= leftList.size() > 1 || rightList.size() > 1;
        }
        return containsRepeatedReferences;
    }
}

