/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MixedAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.api.http.server.ServletUtil;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IFormattedException;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;

public abstract class AbstractNCUdfServlet
extends AbstractServlet {
    INcApplicationContext appCtx;
    INCServiceContext srvCtx;
    protected final IApplicationContext plainAppCtx;
    private final HttpScheme httpServerProtocol;
    private final int httpServerPort;
    public static final String GET_UDF_DIST_ENDPOINT = "/dist";
    public static final String TYPE_PARAMETER = "type";
    public static final String DATA_PARAMETER = "data";
    public static final String NAME_KEY = "name";
    public static final String DATAVERSE_KEY = "dataverse";

    public AbstractNCUdfServlet(ConcurrentMap<String, Object> ctx, String[] paths, IApplicationContext appCtx, HttpScheme httpServerProtocol, int httpServerPort) {
        super(ctx, paths);
        this.plainAppCtx = appCtx;
        this.httpServerProtocol = httpServerProtocol;
        this.httpServerPort = httpServerPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readFromFile(final Path filePath, IServletResponse response, String contentType, final OpenOption opt) throws Exception {
        class InputStreamGetter
        extends SynchronizableWork {
            private InputStream is;

            InputStreamGetter() {
            }

            protected void doRun() throws Exception {
                this.is = opt != null ? Files.newInputStream(filePath, opt) : Files.newInputStream(filePath, new OpenOption[0]);
            }
        }
        InputStreamGetter r = new InputStreamGetter();
        ((NodeControllerService)this.srvCtx.getControllerService()).getWorkQueue().scheduleAndSync((SynchronizableWork)r);
        if (r.is == null) {
            response.setStatus(HttpResponseStatus.NOT_FOUND);
            return;
        }
        try {
            response.setStatus(HttpResponseStatus.OK);
            HttpUtil.setContentType((IServletResponse)response, (String)contentType);
            IOUtils.copyLarge((InputStream)r.is, (OutputStream)response.outputStream());
        }
        finally {
            r.is.close();
        }
    }

    protected String getDataverseKey() {
        return DATAVERSE_KEY;
    }

    URI createDownloadURI(Path file) throws Exception {
        String host = this.appCtx.getServiceContext().getAppConfig().getString((IOption)NCConfig.Option.PUBLIC_ADDRESS);
        String path = this.paths[0].substring(0, this.servletPathLengths[0]) + "/dist/" + file.getFileName();
        return new URI(this.httpServerProtocol.toString(), null, host, this.httpServerPort, path, null, null);
    }

    private boolean isNotAttribute(InterfaceHttpData field) {
        return field == null || !field.getHttpDataType().equals((Object)InterfaceHttpData.HttpDataType.Attribute);
    }

    protected Pair<Namespace, String> decodeDvAndLibFromLocalPath(String localPath) throws RuntimeDataException, AlgebricksException {
        String[] pathSegments = StringUtils.split((String)localPath, (char)'/');
        if (pathSegments.length != 2) {
            throw RuntimeDataException.create((ErrorCode)ErrorCode.PARAMETERS_REQUIRED, (Serializable[])new Serializable[]{"The URL-encoded " + this.getDataverseKey() + " name and library name in the request path"});
        }
        String namespaceStr = ServletUtil.decodeUriSegment(pathSegments[0]);
        Namespace namespace = this.plainAppCtx.getNamespaceResolver().resolve(namespaceStr);
        String libName = ServletUtil.decodeUriSegment(pathSegments[1]);
        return new Pair((Object)namespace, (Object)libName);
    }

    protected LibraryUploadData decodeMultiPartLibraryOptions(HttpPostRequestDecoder requestDecoder) throws IOException {
        InterfaceHttpData typeAttribute = requestDecoder.getBodyHttpData(TYPE_PARAMETER);
        if (typeAttribute == null) {
            throw RuntimeDataException.create((ErrorCode)ErrorCode.PARAMETERS_REQUIRED, (Serializable[])new Serializable[]{TYPE_PARAMETER});
        }
        if (!this.isNotAttribute(typeAttribute)) {
            InterfaceHttpData libraryData = requestDecoder.getBodyHttpData(DATA_PARAMETER);
            if (libraryData == null) {
                throw RuntimeDataException.create((ErrorCode)ErrorCode.PARAMETERS_REQUIRED, (Serializable[])new Serializable[]{DATA_PARAMETER});
            }
            if (!libraryData.getHttpDataType().equals((Object)InterfaceHttpData.HttpDataType.FileUpload)) {
                throw RuntimeDataException.create((ErrorCode)ErrorCode.INVALID_REQ_PARAM_VAL, (Serializable[])new Serializable[]{DATA_PARAMETER, libraryData.getHttpDataType()});
            }
            LibraryUploadData uploadData = LibraryUploadData.libraryCreationUploadData((MixedAttribute)typeAttribute, libraryData);
            if (uploadData.type == null) {
                throw RuntimeDataException.create((ErrorCode)ErrorCode.LIBRARY_EXTERNAL_FUNCTION_UNSUPPORTED_KIND, (Serializable[])new Serializable[]{((MixedAttribute)typeAttribute).getValue()});
            }
            return uploadData;
        }
        throw RuntimeDataException.create((ErrorCode)ErrorCode.PARAMETERS_REQUIRED, (Serializable[])new Serializable[]{TYPE_PARAMETER});
    }

    static ExternalFunctionLanguage getLanguageByTypeParameter(String lang) {
        if (lang.equalsIgnoreCase(ExternalFunctionLanguage.JAVA.name())) {
            return ExternalFunctionLanguage.JAVA;
        }
        if (lang.equalsIgnoreCase(ExternalFunctionLanguage.PYTHON.name())) {
            return ExternalFunctionLanguage.PYTHON;
        }
        return null;
    }

    HttpResponseStatus toHttpErrorStatus(Exception e) {
        if (IFormattedException.matchesAny((Throwable)e, (IError)ErrorCode.UNKNOWN_DATAVERSE, (IError[])new IError[]{ErrorCode.UNKNOWN_LIBRARY})) {
            return HttpResponseStatus.NOT_FOUND;
        }
        if (IFormattedException.matchesAny((Throwable)e, (IError)ErrorCode.LIBRARY_EXTERNAL_FUNCTION_UNKNOWN_KIND, (IError[])new IError[]{ErrorCode.LIBRARY_EXTERNAL_FUNCTION_UNSUPPORTED_KIND, ErrorCode.INVALID_REQ_PARAM_VAL, ErrorCode.PARAMETERS_REQUIRED, ErrorCode.INVALID_DATABASE_OBJECT_NAME})) {
            return HttpResponseStatus.BAD_REQUEST;
        }
        if (e instanceof AlgebricksException) {
            return HttpResponseStatus.BAD_REQUEST;
        }
        return HttpResponseStatus.INTERNAL_SERVER_ERROR;
    }

    protected static final class LibraryUploadData {
        final ExternalFunctionLanguage type;
        final boolean replaceIfExists;
        final FileUpload fileUpload;

        private LibraryUploadData(MixedAttribute type, boolean replaceIfExists, InterfaceHttpData fileUpload) throws IOException {
            this.type = type != null ? AbstractNCUdfServlet.getLanguageByTypeParameter(type.getValue()) : null;
            this.replaceIfExists = replaceIfExists;
            this.fileUpload = (FileUpload)fileUpload;
        }

        public static LibraryUploadData libraryCreationUploadData(MixedAttribute type, InterfaceHttpData fileUpload) throws IOException {
            return new LibraryUploadData(type, true, fileUpload);
        }
    }
}

