/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IExternalDataRuntimeContext;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IStreamDataParser;
import org.apache.asterix.external.parser.AbstractJsonDataParser;
import org.apache.asterix.external.parser.ParseException;
import org.apache.asterix.external.parser.jackson.ADMToken;
import org.apache.asterix.external.provider.context.NoOpExternalRuntimeDataContext;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class JSONDataParser
extends AbstractJsonDataParser
implements IStreamDataParser,
IRecordDataParser<char[]> {
    public JSONDataParser(ARecordType recordType, JsonFactory jsonFactory) {
        this(recordType, jsonFactory, NoOpExternalRuntimeDataContext.INSTANCE);
    }

    public JSONDataParser(ARecordType recordType, JsonFactory jsonFactory, IExternalDataRuntimeContext context) {
        super(recordType, jsonFactory, context);
    }

    @Override
    public void setInputStream(InputStream in) throws IOException {
        this.setInput(this.jsonFactory.createParser(in));
    }

    public void setInputNode(JsonNode node) {
        this.setInput((JsonParser)new TreeTraversingParser(node));
    }

    private void setInput(JsonParser parser) {
        this.jsonParser = parser;
        this.geometryCoParser.reset(this.jsonParser);
    }

    @Override
    public boolean parse(IRawRecord<? extends char[]> record, DataOutput out) throws HyracksDataException {
        try {
            this.jsonParser = this.jsonFactory.createParser(record.get(), 0, record.size());
            this.geometryCoParser.reset(this.jsonParser);
            if (this.nextToken() != ADMToken.OBJECT_START) {
                throw new ParseException(ErrorCode.PARSER_DATA_PARSER_UNEXPECTED_TOKEN, new Serializable[]{(Serializable)this.currentToken(), ADMToken.OBJECT_START});
            }
            this.valueEmbedder.reset();
            this.parseObject(this.rootType, out);
            return true;
        }
        catch (IOException e) {
            throw this.createException(e);
        }
    }

    @Override
    public boolean parse(DataOutput out) throws HyracksDataException {
        try {
            if (this.nextToken() == ADMToken.EOF) {
                return false;
            }
            this.valueEmbedder.reset();
            this.parseObject(this.rootType, out);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeDataException(ErrorCode.RECORD_READER_MALFORMED_INPUT_STREAM, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public boolean reset(InputStream in) throws IOException {
        this.setInputStream(in);
        return true;
    }
}

