/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.gcs;

import com.google.cloud.storage.Blob;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.asterix.common.external.IExternalFilterEvaluator;
import org.apache.asterix.common.external.IExternalFilterEvaluatorFactory;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IExternalDataRuntimeContext;
import org.apache.asterix.external.input.filter.embedder.IExternalFilterValueEmbedder;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStreamFactory;
import org.apache.asterix.external.input.record.reader.gcs.GCSInputStream;
import org.apache.asterix.external.util.ExternalDataPrefix;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.google.gcs.GCSUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public class GCSInputStreamFactory
extends AbstractExternalInputStreamFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public AsterixInputStream createInputStream(IExternalDataRuntimeContext context) throws HyracksDataException {
        IExternalFilterValueEmbedder valueEmbedder = context.getValueEmbedder();
        int partition = context.getPartition();
        return new GCSInputStream(this.configuration, ((AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize)this.partitionWorkLoadsBasedOnSize.get(partition)).getFilePaths(), valueEmbedder);
    }

    @Override
    public void configure(IServiceContext ctx, Map<String, String> configuration, IWarningCollector warningCollector, IExternalFilterEvaluatorFactory filterEvaluatorFactory) throws AlgebricksException, HyracksDataException {
        super.configure(ctx, configuration, warningCollector, filterEvaluatorFactory);
        AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher = ExternalDataUtils.getIncludeExcludeMatchers(configuration);
        IExternalFilterEvaluator evaluator = filterEvaluatorFactory.create(ctx, warningCollector);
        ExternalDataPrefix externalDataPrefix = new ExternalDataPrefix(configuration);
        configuration.put("prefix-root", externalDataPrefix.getRoot());
        List<Blob> filesOnly = GCSUtils.listItems(configuration, includeExcludeMatcher, warningCollector, externalDataPrefix, evaluator);
        this.distributeWorkLoad(filesOnly, this.getPartitionsCount());
    }

    private void distributeWorkLoad(List<Blob> items, int partitionsCount) {
        PriorityQueue<AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize> workloadQueue = new PriorityQueue<AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize>(partitionsCount, Comparator.comparingLong(AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize::getTotalSize));
        for (int i = 0; i < partitionsCount; ++i) {
            workloadQueue.add(new AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize());
        }
        for (Blob item : items) {
            AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize workload = workloadQueue.poll();
            workload.addFilePath(item.getName(), item.getSize());
            workloadQueue.add(workload);
        }
        this.partitionWorkLoadsBasedOnSize.addAll(workloadQueue);
    }
}

