/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

import java.util.List;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMissableTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.properties.TypePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypeEnvPointer;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;

public abstract class LeftOuterTypePropagationPolicy
extends TypePropagationPolicy {
    public static final TypePropagationPolicy MISSABLE = new LeftOuterTypePropagationPolicy(){

        @Override
        protected Object computeInnerBranchVarType(LogicalVariable var, Object varType, IMissableTypeComputer ntc, List<LogicalVariable> nonMissableVariableList, List<List<LogicalVariable>> correlatedMissableVariableLists, List<LogicalVariable> nonNullableVariableList, List<List<LogicalVariable>> correlatedNullableVariableLists) {
            boolean makeMissable = !1.inCorrelatedVariableList(var, correlatedMissableVariableLists, nonMissableVariableList);
            return makeMissable ? ntc.makeMissableType(varType) : varType;
        }
    };
    public static final TypePropagationPolicy NULLABLE = new LeftOuterTypePropagationPolicy(){

        @Override
        protected Object computeInnerBranchVarType(LogicalVariable var, Object varType, IMissableTypeComputer ntc, List<LogicalVariable> nonMissableVariableList, List<List<LogicalVariable>> correlatedMissableVariableLists, List<LogicalVariable> nonNullableVariableList, List<List<LogicalVariable>> correlatedNullableVariableLists) {
            boolean makeNullable = !2.inCorrelatedVariableList(var, correlatedNullableVariableLists, nonNullableVariableList);
            return makeNullable ? ntc.makeNullableType(varType) : varType;
        }
    };

    @Override
    public Object getVarType(LogicalVariable var, IMissableTypeComputer ntc, List<LogicalVariable> nonMissableVariableList, List<List<LogicalVariable>> correlatedMissableVariableLists, List<LogicalVariable> nonNullableVariableList, List<List<LogicalVariable>> correlatedNullableVariableLists, ITypeEnvPointer ... typeEnvs) throws AlgebricksException {
        int n = typeEnvs.length;
        for (int i = n - 1; i >= 0; --i) {
            Object varType = typeEnvs[i].getTypeEnv().getVarType(var, nonMissableVariableList, correlatedMissableVariableLists, nonNullableVariableList, correlatedNullableVariableLists);
            if (varType == null) continue;
            if (i == 0) {
                return varType;
            }
            return this.computeInnerBranchVarType(var, varType, ntc, nonMissableVariableList, correlatedMissableVariableLists, nonNullableVariableList, correlatedNullableVariableLists);
        }
        return null;
    }

    protected abstract Object computeInnerBranchVarType(LogicalVariable var1, Object var2, IMissableTypeComputer var3, List<LogicalVariable> var4, List<List<LogicalVariable>> var5, List<LogicalVariable> var6, List<List<LogicalVariable>> var7);

    protected static boolean inCorrelatedVariableList(LogicalVariable var, List<List<LogicalVariable>> correlatedOptionalVariableLists, List<LogicalVariable> nonOptionalVariableList) {
        if (!nonOptionalVariableList.isEmpty()) {
            for (List<LogicalVariable> correlatedVariables : correlatedOptionalVariableLists) {
                if (!correlatedVariables.contains(var) || OperatorPropertiesUtil.disjoint(correlatedVariables, nonOptionalVariableList)) continue;
                return true;
            }
        }
        return false;
    }
}

