/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.visitor;

import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.UpdateClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.IndexedTypeExpression;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.ListSliceExpression;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.OrderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.RecordTypeDefinition;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.expression.TypeReferenceExpression;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.UnorderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.AdapterDropStatement;
import org.apache.asterix.lang.common.statement.CompactStatement;
import org.apache.asterix.lang.common.statement.ConnectFeedStatement;
import org.apache.asterix.lang.common.statement.CreateAdapterStatement;
import org.apache.asterix.lang.common.statement.CreateDataverseStatement;
import org.apache.asterix.lang.common.statement.CreateFeedPolicyStatement;
import org.apache.asterix.lang.common.statement.CreateFeedStatement;
import org.apache.asterix.lang.common.statement.CreateFullTextConfigStatement;
import org.apache.asterix.lang.common.statement.CreateFullTextFilterStatement;
import org.apache.asterix.lang.common.statement.CreateFunctionStatement;
import org.apache.asterix.lang.common.statement.CreateIndexStatement;
import org.apache.asterix.lang.common.statement.CreateLibraryStatement;
import org.apache.asterix.lang.common.statement.CreateSynonymStatement;
import org.apache.asterix.lang.common.statement.CreateViewStatement;
import org.apache.asterix.lang.common.statement.DatasetDecl;
import org.apache.asterix.lang.common.statement.DataverseDecl;
import org.apache.asterix.lang.common.statement.DataverseDropStatement;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.DisconnectFeedStatement;
import org.apache.asterix.lang.common.statement.DropDatasetStatement;
import org.apache.asterix.lang.common.statement.ExternalDetailsDecl;
import org.apache.asterix.lang.common.statement.FeedDropStatement;
import org.apache.asterix.lang.common.statement.FeedPolicyDropStatement;
import org.apache.asterix.lang.common.statement.FullTextConfigDropStatement;
import org.apache.asterix.lang.common.statement.FullTextFilterDropStatement;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.FunctionDropStatement;
import org.apache.asterix.lang.common.statement.IndexDropStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.InternalDetailsDecl;
import org.apache.asterix.lang.common.statement.LibraryDropStatement;
import org.apache.asterix.lang.common.statement.LoadStatement;
import org.apache.asterix.lang.common.statement.NodeGroupDropStatement;
import org.apache.asterix.lang.common.statement.NodegroupDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.statement.SetStatement;
import org.apache.asterix.lang.common.statement.StartFeedStatement;
import org.apache.asterix.lang.common.statement.StopFeedStatement;
import org.apache.asterix.lang.common.statement.SynonymDropStatement;
import org.apache.asterix.lang.common.statement.TypeDecl;
import org.apache.asterix.lang.common.statement.TypeDropStatement;
import org.apache.asterix.lang.common.statement.UpdateStatement;
import org.apache.asterix.lang.common.statement.ViewDecl;
import org.apache.asterix.lang.common.statement.ViewDropStatement;
import org.apache.asterix.lang.common.statement.WriteStatement;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.struct.UnaryExprType;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.metadata.utils.MetadataConstants;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;

public abstract class FormatPrintVisitor
implements ILangVisitor<Void, Integer> {
    protected static final String COMMA = ",";
    protected static final String SEMICOLON = ";";
    private static final String CREATE = "create ";
    private static final String FEED = " feed ";
    private static final String DEFAULT_DATAVERSE_FORMAT = "org.apache.asterix.runtime.formats.NonTaggedDataFormat";
    protected final PrintWriter out;
    protected Set<Character> validIdentifierChars = new HashSet<Character>();
    protected Set<Character> validIdentifierStartChars = new HashSet<Character>();
    protected String dataverseSymbol = " dataverse ";
    protected String datasetSymbol = " dataset ";
    protected String assignSymbol = ":=";
    private final List<String> dataverseNameParts = new ArrayList<String>();

    public FormatPrintVisitor(PrintWriter out) {
        char ch;
        this.out = out;
        for (ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
            this.validIdentifierChars.add(Character.valueOf(ch));
            this.validIdentifierStartChars.add(Character.valueOf(ch));
        }
        for (ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            this.validIdentifierChars.add(Character.valueOf(ch));
            this.validIdentifierStartChars.add(Character.valueOf(ch));
        }
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            this.validIdentifierChars.add(Character.valueOf(ch));
        }
        this.validIdentifierChars.add(Character.valueOf('_'));
        this.validIdentifierChars.add(Character.valueOf('$'));
    }

    protected String skip(int step) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < step; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    @Override
    public Void visit(Query q, Integer step) throws CompilationException {
        if (q.getBody() != null) {
            q.getBody().accept(this, step);
        }
        if (q.isTopLevel()) {
            this.out.println(SEMICOLON);
        }
        return null;
    }

    @Override
    public Void visit(LiteralExpr l, Integer step) {
        Literal lc = l.getValue();
        if (lc.getLiteralType().equals((Object)Literal.Type.TRUE) || lc.getLiteralType().equals((Object)Literal.Type.FALSE) || lc.getLiteralType().equals((Object)Literal.Type.NULL) || lc.getLiteralType().equals((Object)Literal.Type.MISSING)) {
            this.out.print(lc.getLiteralType().toString().toLowerCase());
        } else if (lc.getLiteralType().equals((Object)Literal.Type.STRING)) {
            this.out.print(this.revertStringToLiteral(lc.getStringValue()));
        } else if (lc.getLiteralType().equals((Object)Literal.Type.FLOAT)) {
            this.out.printf("%ff", lc.getValue());
        } else if (lc.getLiteralType().equals((Object)Literal.Type.DOUBLE)) {
            DecimalFormat df = new DecimalFormat("#.#");
            df.setMinimumFractionDigits(1);
            df.setMaximumFractionDigits(16);
            this.out.print(df.format(lc.getValue()));
        } else {
            this.out.print(lc.getStringValue());
        }
        return null;
    }

    @Override
    public Void visit(VariableExpr v, Integer step) {
        this.out.print(v.getVar().getValue());
        return null;
    }

    @Override
    public Void visit(ListConstructor lc, Integer step) throws CompilationException {
        boolean ordered = false;
        if (lc.getType().equals((Object)ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR)) {
            ordered = true;
        }
        this.out.print(ordered ? "[" : "{{");
        this.printDelimitedExpressions(lc.getExprList(), COMMA, step + 2);
        this.out.print(ordered ? "]" : "}}");
        return null;
    }

    @Override
    public Void visit(RecordConstructor rc, Integer step) throws CompilationException {
        this.out.print("{");
        int size = rc.getFbList().size();
        int index = 0;
        for (FieldBinding fb : rc.getFbList()) {
            fb.getLeftExpr().accept(this, step + 2);
            this.out.print(":");
            fb.getRightExpr().accept(this, step + 2);
            if (++index >= size) continue;
            this.out.print(COMMA);
        }
        this.out.print("}");
        return null;
    }

    @Override
    public Void visit(CallExpr callExpr, Integer step) throws CompilationException {
        this.printHints(callExpr.getHints(), step);
        this.out.print(this.generateFullName(callExpr.getFunctionSignature().getDataverseName(), callExpr.getFunctionSignature().getName()) + "(");
        this.printDelimitedExpressions(callExpr.getExprList(), COMMA, step);
        this.out.print(")");
        if (callExpr.hasAggregateFilterExpr()) {
            this.out.println(" FILTER ( WHERE ");
            callExpr.getAggregateFilterExpr().accept(this, step + 1);
            this.out.println(this.skip(step) + ")");
        }
        return null;
    }

    @Override
    public Void visit(OperatorExpr operatorExpr, Integer step) throws CompilationException {
        List<Expression> exprList = operatorExpr.getExprList();
        List<OperatorType> opList = operatorExpr.getOpList();
        if (operatorExpr.isCurrentop()) {
            this.out.print("(");
            exprList.get(0).accept(this, step + 1);
            for (int i = 1; i < exprList.size(); ++i) {
                OperatorType opType = opList.get(i - 1);
                if (i == 1) {
                    this.printHints(operatorExpr.getHints(), step + 1);
                }
                this.out.print(" " + opType + " ");
                exprList.get(i).accept(this, step + 1);
            }
            this.out.print(")");
        } else {
            exprList.get(0).accept(this, step);
        }
        return null;
    }

    @Override
    public Void visit(IfExpr ifexpr, Integer step) throws CompilationException {
        this.out.print("if (");
        ifexpr.getCondExpr().accept(this, step + 2);
        this.out.println(")");
        this.out.print(this.skip(step) + "then ");
        ifexpr.getThenExpr().accept(this, step + 2);
        this.out.println();
        this.out.print(this.skip(step) + "else ");
        ifexpr.getElseExpr().accept(this, step + 2);
        return null;
    }

    @Override
    public Void visit(QuantifiedExpression qe, Integer step) throws CompilationException {
        this.out.print(qe.getQuantifier().toString().toLowerCase() + " ");
        int index = 0;
        int size = qe.getQuantifiedList().size();
        for (QuantifiedPair pair : qe.getQuantifiedList()) {
            pair.getVarExpr().accept(this, 0);
            this.out.print(" in ");
            pair.getExpr().accept(this, step + 2);
            if (++index >= size) continue;
            this.out.println(COMMA);
        }
        this.out.print(" satisfies ");
        qe.getSatisfiesExpr().accept(this, step + 2);
        return null;
    }

    @Override
    public Void visit(LetClause lc, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "let ");
        lc.getVarExpr().accept(this, 0);
        this.out.print(this.assignSymbol);
        lc.getBindingExpr().accept(this, step + 1);
        this.out.println();
        return null;
    }

    @Override
    public Void visit(WhereClause wc, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "where ");
        wc.getWhereExpr().accept(this, step + 1);
        this.out.println();
        return null;
    }

    @Override
    public Void visit(OrderbyClause oc, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "order by ");
        this.printDelimitedObyExpressions(oc.getOrderbyList(), oc.getModifierList(), oc.getNullModifierList(), step);
        this.out.println();
        return null;
    }

    @Override
    public Void visit(LimitClause lc, Integer step) throws CompilationException {
        if (lc.hasLimitExpr()) {
            this.out.print(this.skip(step) + "limit ");
            lc.getLimitExpr().accept(this, step + 1);
            if (lc.hasOffset()) {
                this.out.print(" offset ");
                lc.getOffset().accept(this, step + 1);
            }
        } else if (lc.hasOffset()) {
            this.out.print(this.skip(step) + "offset ");
            lc.getOffset().accept(this, step + 1);
        } else {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, lc.getSourceLocation(), new Serializable[]{""});
        }
        this.out.println();
        return null;
    }

    @Override
    public Void visit(FunctionDecl fd, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "declare function " + this.generateFullName(null, fd.getSignature().getName()) + "(");
        ArrayList<Identifier> parameters = new ArrayList<Identifier>();
        parameters.addAll(fd.getParamList());
        this.printDelimitedIdentifiers(parameters, COMMA);
        this.out.println(") {");
        fd.getFuncBody().accept(this, step + 2);
        this.out.println();
        this.out.print(this.skip(step) + "}");
        this.out.println(SEMICOLON);
        return null;
    }

    @Override
    public Void visit(UnaryExpr u, Integer step) throws CompilationException {
        this.out.print(u.getExprType() == UnaryExprType.NEGATIVE ? "-" : "");
        u.getExpr().accept(this, 0);
        return null;
    }

    @Override
    public Void visit(FieldAccessor fa, Integer step) throws CompilationException {
        fa.getExpr().accept(this, step + 1);
        this.out.print("." + this.normalize(fa.getIdent().getValue()));
        return null;
    }

    @Override
    public Void visit(IndexAccessor ia, Integer step) throws CompilationException {
        ia.getExpr().accept(this, step + 1);
        this.out.print("[");
        switch (ia.getIndexKind()) {
            case ANY: {
                this.out.print("?");
                break;
            }
            case STAR: {
                this.out.print("*");
                break;
            }
            case ELEMENT: {
                ia.getIndexExpr().accept(this, step + 1);
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, ia.getSourceLocation(), new Serializable[]{ia.getIndexKind()});
            }
        }
        this.out.print("]");
        return null;
    }

    @Override
    public Void visit(TypeDecl t, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "create type " + this.generateFullName(t.getDataverseName(), t.getIdent()) + this.generateIfNotExists(t.getIfNotExists()) + " as");
        t.getTypeDef().accept(this, step + 1);
        this.out.println();
        return null;
    }

    @Override
    public Void visit(TypeReferenceExpression t, Integer arg) throws CompilationException {
        if (t.getIdent().first != null && t.getIdent().first != null) {
            this.out.print(this.generateDataverseName((DataverseName)t.getIdent().first));
            this.out.print('.');
        }
        this.out.print(this.normalize(((Identifier)t.getIdent().second).getValue()));
        return null;
    }

    @Override
    public Void visit(RecordTypeDefinition r, Integer step) throws CompilationException {
        if (r.getRecordKind() == RecordTypeDefinition.RecordKind.CLOSED) {
            this.out.print(" closed ");
        }
        this.out.println("{");
        Iterator<String> nameIter = r.getFieldNames().iterator();
        Iterator<TypeExpression> typeIter = r.getFieldTypes().iterator();
        Iterator<Boolean> isNullableIter = r.getNullableFields().iterator();
        Iterator<Boolean> isMissableIter = r.getMissableFields().iterator();
        boolean first = true;
        while (nameIter.hasNext()) {
            if (first) {
                first = false;
            } else {
                this.out.println(COMMA);
            }
            String name = this.normalize(nameIter.next());
            TypeExpression texp = typeIter.next();
            Boolean isNullable = isNullableIter.next();
            Boolean isMissable = isMissableIter.next();
            this.out.print(this.skip(step) + name + " : ");
            texp.accept(this, step + 2);
            if (!isNullable.booleanValue() && !isMissable.booleanValue()) continue;
            this.out.print("?");
        }
        this.out.println();
        this.out.println(this.skip(step - 2) + "}");
        return null;
    }

    @Override
    public Void visit(OrderedListTypeDefinition x, Integer step) throws CompilationException {
        this.out.print("[");
        x.getItemTypeExpression().accept(this, step + 2);
        this.out.print("]");
        return null;
    }

    @Override
    public Void visit(UnorderedListTypeDefinition x, Integer step) throws CompilationException {
        this.out.print("{{");
        x.getItemTypeExpression().accept(this, step + 2);
        this.out.print("}}");
        return null;
    }

    @Override
    public Void visit(DatasetDecl dd, Integer step) throws CompilationException {
        List<String> filterField;
        if (dd.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            this.out.print(this.skip(step) + CREATE + this.datasetSymbol + this.generateFullName(dd.getDataverse(), dd.getName()) + this.generateIfNotExists(dd.getIfNotExists()) + "(");
            dd.getItemType().accept(this, step + 2);
            this.out.print(this.skip(step) + ") primary key ");
            this.printDelimitedKeys(((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getPartitioningExprs(), COMMA);
            if (((InternalDetailsDecl)dd.getDatasetDetailsDecl()).isAutogenerated()) {
                this.out.print(" autogenerated ");
            }
        } else if (dd.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            this.out.print(this.skip(step) + "create external " + this.datasetSymbol + this.generateFullName(dd.getDataverse(), dd.getName()) + "(");
            dd.getItemType().accept(this, step + 2);
            this.out.print(this.skip(step) + ")" + this.generateIfNotExists(dd.getIfNotExists()));
            ExternalDetailsDecl externalDetails = (ExternalDetailsDecl)dd.getDatasetDetailsDecl();
            this.out.print(" using " + FormatPrintVisitor.revertStringToQuoted(externalDetails.getAdapter()));
            this.printConfiguration(externalDetails.getProperties());
        }
        Map<String, String> hints = dd.getHints();
        if (dd.getHints().size() > 0) {
            this.out.print(" hints ");
            this.printProperties(hints);
        }
        if (dd.getDatasetType() == DatasetConfig.DatasetType.INTERNAL && (filterField = ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getFilterField()) != null && filterField.size() > 0) {
            this.out.print(" with filter on ");
            this.printNestField(filterField);
        }
        if (dd.getWithObjectNode() != null) {
            this.out.print(" with ");
            this.out.print(dd.getWithObjectNode().toString());
        }
        this.out.println(SEMICOLON);
        this.out.println();
        return null;
    }

    @Override
    public Void visit(DataverseDecl dv, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "use " + this.dataverseSymbol + this.generateDataverseName(dv.getDataverseName()) + ";\n\n");
        return null;
    }

    @Override
    public Void visit(WriteStatement ws, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "write output to " + ws.getNcName() + ":" + FormatPrintVisitor.revertStringToQuoted(ws.getFileName()));
        if (ws.getWriterClassName() != null) {
            this.out.print(" using " + ws.getWriterClassName());
        }
        this.out.println();
        return null;
    }

    @Override
    public Void visit(SetStatement ss, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "set " + FormatPrintVisitor.revertStringToQuoted(ss.getPropName()) + " " + FormatPrintVisitor.revertStringToQuoted(ss.getPropValue()) + ";\n");
        return null;
    }

    @Override
    public Void visit(DisconnectFeedStatement ss, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "disconnect  feed " + this.generateFullName(ss.getDataverseName(), ss.getFeedName()) + " from " + this.datasetSymbol + this.generateFullName(ss.getDataverseName(), ss.getDatasetName()) + SEMICOLON);
        return null;
    }

    @Override
    public Void visit(NodegroupDecl ngd, Integer step) throws CompilationException {
        this.out.println("create  nodegroup " + ngd.getNodegroupName() + this.generateIfNotExists(ngd.getIfNotExists()) + " on ");
        this.out.print(this.skip(step + 2));
        this.printDelimitedIdentifiers(ngd.getNodeControllerNames(), ",\n" + this.skip(step + 2));
        this.out.println();
        this.out.println(this.skip(step) + SEMICOLON);
        return null;
    }

    @Override
    public Void visit(LoadStatement stmtLoad, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "load " + this.datasetSymbol + this.generateFullName(stmtLoad.getDataverseName(), stmtLoad.getDatasetName()) + " using " + FormatPrintVisitor.revertStringToQuoted(stmtLoad.getAdapter()) + " ");
        this.printConfiguration(stmtLoad.getProperties());
        this.out.println(stmtLoad.dataIsAlreadySorted() ? " pre-sorted;" : SEMICOLON);
        this.out.println();
        return null;
    }

    @Override
    public Void visit(DropDatasetStatement del, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "drop " + this.datasetSymbol + this.generateFullName(del.getDataverseName(), del.getDatasetName()) + this.generateIfExists(del.getIfExists()) + SEMICOLON);
        return null;
    }

    @Override
    public Void visit(InsertStatement insert, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "insert into " + this.datasetSymbol + this.generateFullName(insert.getDataverseName(), insert.getDatasetName()));
        this.out.print("(");
        insert.getQuery().accept(this, step + 2);
        this.out.print(")");
        this.out.println(SEMICOLON);
        return null;
    }

    @Override
    public Void visit(DeleteStatement del, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "delete ");
        del.getVariableExpr().accept(this, step + 2);
        this.out.println(this.skip(step) + " from " + this.datasetSymbol + this.generateFullName(del.getDataverseName(), del.getDatasetName()));
        if (del.getCondition() != null) {
            this.out.print(this.skip(step) + " where ");
            del.getCondition().accept(this, step + 2);
        }
        this.out.println(SEMICOLON);
        return null;
    }

    @Override
    public Void visit(UpdateStatement update, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "update ");
        update.getVariableExpr().accept(this, step + 2);
        this.out.print(" in ");
        update.getTarget().accept(this, step + 2);
        this.out.println();
        this.out.print(this.skip(step) + "where ");
        update.getCondition().accept(this, step + 2);
        this.out.println();
        this.out.print("(");
        for (UpdateClause updateClause : update.getUpdateClauses()) {
            updateClause.accept(this, step + 4);
            this.out.println();
        }
        this.out.print(")");
        this.out.println(SEMICOLON);
        return null;
    }

    @Override
    public Void visit(UpdateClause del, Integer step) throws CompilationException {
        if (del.hasSet()) {
            this.out.println(this.skip(step) + "set ");
            del.getTarget().accept(this, step + 2);
            this.out.print("=");
            del.getTarget().accept(this, step + 2);
        } else if (del.hasInsert()) {
            del.getInsertStatement().accept(this, step + 2);
        } else if (del.hasDelete()) {
            del.getDeleteStatement().accept(this, step + 2);
        } else if (del.hasUpdate()) {
            del.getUpdateStatement().accept(this, step + 2);
        } else if (del.hasIfElse()) {
            this.out.println();
            this.out.print(this.skip(step) + "if (");
            del.getCondition().accept(this, step);
            this.out.print(")");
            this.out.println();
            this.out.print(this.skip(step) + "then ");
            del.getIfBranch().accept(this, step);
            if (del.hasElse()) {
                this.out.println();
                this.out.print(this.skip(step) + "else");
                del.getElseBranch().accept(this, step);
            }
            this.out.println();
        }
        return null;
    }

    @Override
    public Void visit(CreateIndexStatement cis, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "create  index ");
        this.out.print(this.normalize(cis.getIndexName().getValue()) + " ");
        this.out.print(this.generateIfNotExists(cis.getIfNotExists()));
        this.out.print(" on ");
        this.out.print(this.generateFullName(cis.getDataverseName(), cis.getDatasetName()));
        this.out.print(" (");
        List<CreateIndexStatement.IndexedElement> indexedElements = cis.getIndexedElements();
        int index = 0;
        for (CreateIndexStatement.IndexedElement element : indexedElements) {
            List<Pair<List<String>, IndexedTypeExpression>> projectList = element.getProjectList();
            if (element.hasUnnest()) {
                int innerIndex = 0;
                this.out.print("(");
                for (List<String> list : element.getUnnestList()) {
                    this.out.print(" unnest ");
                    this.printNestField(list);
                    if (++innerIndex >= element.getUnnestList().size()) continue;
                    this.out.print(" ");
                }
                if (projectList.get((int)0).first != null) {
                    innerIndex = 0;
                    this.out.print(" select ");
                    for (Pair pair : projectList) {
                        this.printNestField((List)pair.first);
                        if (pair.second != null) {
                            this.out.print(":");
                            ((IndexedTypeExpression)pair.second).getType().accept(this, step);
                            if (((IndexedTypeExpression)pair.second).isUnknownable()) {
                                this.out.print('?');
                            }
                        }
                        if (++innerIndex >= element.getProjectList().size()) continue;
                        this.out.print(COMMA);
                    }
                }
                this.out.print(")");
            } else {
                this.printNestField((List)projectList.get((int)0).first);
                IndexedTypeExpression typeExpr = (IndexedTypeExpression)projectList.get((int)0).second;
                if (typeExpr != null) {
                    this.out.print(":");
                    typeExpr.getType().accept(this, step);
                    if (typeExpr.isUnknownable()) {
                        this.out.print('?');
                    }
                }
            }
            if (++index >= indexedElements.size()) continue;
            this.out.print(COMMA);
        }
        this.out.print(") type ");
        this.out.print(this.generateIndexTypeString(cis.getIndexType()));
        if (cis.getIndexType() == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX && cis.getGramLength() >= 0) {
            this.out.print(" (");
            this.out.print(cis.getGramLength());
            this.out.print(")");
        }
        if (cis.isEnforced()) {
            this.out.print(" enforced");
        }
        this.out.println(SEMICOLON);
        this.out.println();
        return null;
    }

    @Override
    public Void visit(CreateDataverseStatement del, Integer step) throws CompilationException {
        this.out.print(CREATE + this.dataverseSymbol);
        this.out.print(this.generateDataverseName(del.getDataverseName()));
        this.out.print(this.generateIfNotExists(del.getIfNotExists()));
        String format = del.getFormat();
        if (format != null && !format.equals(DEFAULT_DATAVERSE_FORMAT)) {
            this.out.print(" with format ");
            this.out.print("\"" + format + "\"");
        }
        this.out.println(SEMICOLON);
        this.out.println();
        return null;
    }

    @Override
    public Void visit(CreateFullTextFilterStatement cis, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "create fulltext filter " + cis.getFilterName());
        this.out.println(SEMICOLON);
        return null;
    }

    @Override
    public Void visit(CreateFullTextConfigStatement cis, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "create fulltext config " + cis.getConfigName());
        this.out.println(SEMICOLON);
        return null;
    }

    @Override
    public Void visit(IndexDropStatement del, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "drop index ");
        this.out.print(this.generateFullName(del.getDataverseName(), del.getDatasetName()));
        this.out.print("." + del.getIndexName());
        this.out.println(this.generateIfExists(del.getIfExists()) + SEMICOLON);
        return null;
    }

    @Override
    public Void visit(NodeGroupDropStatement del, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "drop nodegroup ");
        this.out.print(del.getNodeGroupName());
        this.out.println(this.generateIfExists(del.getIfExists()) + SEMICOLON);
        return null;
    }

    @Override
    public Void visit(DataverseDropStatement del, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "drop " + this.dataverseSymbol);
        this.out.print(this.generateDataverseName(del.getDataverseName()));
        this.out.println(this.generateIfExists(del.getIfExists()) + SEMICOLON);
        return null;
    }

    @Override
    public Void visit(TypeDropStatement del, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "drop type ");
        this.out.print(this.generateFullName(del.getDataverseName(), del.getTypeName()));
        this.out.println(this.generateIfExists(del.getIfExists()) + SEMICOLON);
        return null;
    }

    @Override
    public Void visit(FullTextFilterDropStatement del, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "drop fulltext filter " + del.getFilterName());
        this.out.println(this.generateIfExists(del.getIfExists()) + SEMICOLON);
        return null;
    }

    @Override
    public Void visit(FullTextConfigDropStatement del, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "drop fulltext config " + del.getConfigName());
        this.out.println(this.generateIfExists(del.getIfExists()) + SEMICOLON);
        return null;
    }

    @Override
    public Void visit(ConnectFeedStatement connectFeedStmt, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "connect  feed ");
        this.out.print(this.generateFullName(connectFeedStmt.getDataverseName(), new Identifier(connectFeedStmt.getFeedName())));
        this.out.print(" to " + this.datasetSymbol + this.generateFullName(connectFeedStmt.getDataverseName(), connectFeedStmt.getDatasetName()));
        if (connectFeedStmt.getPolicy() != null) {
            this.out.print(" using policy " + FormatPrintVisitor.revertStringToQuoted(connectFeedStmt.getPolicy()));
        }
        if (connectFeedStmt.getAppliedFunctions() != null) {
            this.out.print(" apply function " + connectFeedStmt.getAppliedFunctions());
        }
        this.out.println(SEMICOLON);
        return null;
    }

    @Override
    public Void visit(CreateFeedStatement cfs, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "create  feed ");
        this.out.print(this.generateFullName(cfs.getDataverseName(), cfs.getFeedName()));
        this.out.print(this.generateIfNotExists(cfs.getIfNotExists()));
        if (cfs.getWithObjectNode() != null) {
            this.out.print(" with ");
            this.out.print(cfs.getWithObjectNode().toString());
        }
        this.out.println(SEMICOLON);
        return null;
    }

    @Override
    public Void visit(StartFeedStatement startFeedStatement, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "start  feed ");
        this.out.print(this.generateFullName(startFeedStatement.getDataverseName(), startFeedStatement.getFeedName()));
        this.out.println(SEMICOLON);
        return null;
    }

    @Override
    public Void visit(StopFeedStatement stopFeedStatement, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "stop  feed ");
        this.out.print(this.generateFullName(stopFeedStatement.getDataverseName(), stopFeedStatement.getFeedName()));
        this.out.println(SEMICOLON);
        return null;
    }

    @Override
    public Void visit(FeedDropStatement del, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "drop  feed ");
        this.out.print(this.generateFullName(del.getDataverseName(), del.getFeedName()));
        this.out.println(this.generateIfExists(del.getIfExists()) + SEMICOLON);
        return null;
    }

    @Override
    public Void visit(FeedPolicyDropStatement dfs, Integer step) throws CompilationException {
        return null;
    }

    @Override
    public Void visit(CreateFeedPolicyStatement cfps, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "create ingestion policy ");
        this.out.print(cfps.getPolicyName());
        this.out.print(this.generateIfNotExists(cfps.getIfNotExists()));
        this.out.print(" from ");
        String srcPolicyName = FormatPrintVisitor.revertStringToQuoted(cfps.getSourcePolicyName());
        if (srcPolicyName != null) {
            this.out.print(" policy ");
            this.out.print(srcPolicyName + " ");
            this.printConfiguration(cfps.getProperties());
        } else {
            this.out.print(" path ");
            this.out.print(cfps.getSourcePolicyFile() + " ");
            this.printConfiguration(cfps.getProperties());
        }
        String desc = cfps.getDescription();
        if (cfps.getDescription() != null) {
            this.out.print(" definition ");
            this.out.print(FormatPrintVisitor.revertStringToQuoted(desc));
        }
        this.out.println(SEMICOLON);
        this.out.println();
        return null;
    }

    @Override
    public Void visit(CreateFunctionStatement cfs, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + CREATE + this.generateOrReplace(cfs.getReplaceIfExists()) + " function ");
        this.out.print(this.generateIfNotExists(cfs.getIfNotExists()));
        this.out.print(this.generateFullName(cfs.getFunctionSignature().getDataverseName(), cfs.getFunctionSignature().getName()));
        this.out.print("(");
        this.printDelimitedStrings(cfs.getParameters().stream().map(v -> ((VarIdentifier)v.getFirst()).getValue()).collect(Collectors.toList()), COMMA);
        this.out.println(") {");
        this.out.println(cfs.getFunctionBody());
        this.out.println("};");
        this.out.println();
        return null;
    }

    @Override
    public Void visit(FunctionDropStatement del, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "drop function ");
        FunctionSignature funcSignature = del.getFunctionSignature();
        this.out.print(funcSignature.toString());
        this.out.println(SEMICOLON);
        return null;
    }

    @Override
    public Void visit(CreateAdapterStatement cfs, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "create  adapter");
        this.out.print(this.generateFullName(cfs.getDataverseName(), cfs.getAdapterName()));
        this.out.println(SEMICOLON);
        this.out.println();
        return null;
    }

    @Override
    public Void visit(AdapterDropStatement del, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "drop adapter ");
        this.out.print(this.generateFullName(del.getDataverseName(), del.getAdapterName()));
        this.out.println(this.generateIfExists(del.getIfExists()) + SEMICOLON);
        return null;
    }

    @Override
    public Void visit(CreateSynonymStatement css, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "create synonym " + this.generateFullName(css.getDataverseName(), css.getSynonymName()) + this.generateIfNotExists(css.getIfNotExists()) + " for " + this.generateFullName(css.getObjectDataverseName(), css.getObjectName()));
        return null;
    }

    @Override
    public Void visit(SynonymDropStatement del, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "drop synonym ");
        this.out.print(this.generateFullName(del.getDataverseName(), del.getSynonymName()));
        this.out.println(this.generateIfExists(del.getIfExists()) + SEMICOLON);
        return null;
    }

    @Override
    public Void visit(CompactStatement del, Integer step) throws CompilationException {
        return null;
    }

    @Override
    public Void visit(CreateLibraryStatement cls, Integer arg) throws CompilationException {
        return null;
    }

    @Override
    public Void visit(LibraryDropStatement del, Integer arg) throws CompilationException {
        return null;
    }

    @Override
    public Void visit(ListSliceExpression expression, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "ListSliceExpression [");
        expression.getExpr().accept(this, step + 1);
        this.out.print(this.skip(step + 1) + "Index: ");
        expression.getStartIndexExpression().accept(this, step + 1);
        this.out.println(this.skip(step) + ":");
        if (expression.hasEndExpression()) {
            expression.getEndIndexExpression().accept(this, step + 1);
        }
        this.out.println(this.skip(step) + "]");
        return null;
    }

    @Override
    public Void visit(CreateViewStatement cvs, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + CREATE + this.generateOrReplace(cvs.getReplaceIfExists()) + " view ");
        this.out.print(this.generateIfNotExists(cvs.getIfNotExists()));
        this.out.print(this.generateFullName(cvs.getDataverseName(), cvs.getViewName()));
        this.out.print(" as ");
        this.out.print(cvs.getViewBody());
        this.out.println(SEMICOLON);
        return null;
    }

    @Override
    public Void visit(ViewDropStatement vds, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "drop view ");
        this.out.print(this.generateFullName(vds.getDataverseName(), vds.getViewName()));
        this.out.print(this.generateIfExists(vds.getIfExists()));
        this.out.println(SEMICOLON);
        return null;
    }

    @Override
    public Void visit(ViewDecl vd, Integer arg) throws CompilationException {
        return null;
    }

    protected void printConfiguration(Map<String, String> properties) {
        if (properties.size() > 0) {
            this.out.print("(");
            int index = 0;
            int size = properties.size();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                this.out.print("(" + FormatPrintVisitor.revertStringToQuoted(entry.getKey()) + "=" + FormatPrintVisitor.revertStringToQuoted(entry.getValue()) + ")");
                if (++index >= size) continue;
                this.out.print(COMMA);
            }
            this.out.print(")");
        }
    }

    protected void printProperties(Map<String, String> properties) {
        if (properties.size() > 0) {
            this.out.print("(");
            int index = 0;
            int size = properties.size();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                this.out.print(FormatPrintVisitor.revertStringToQuoted(entry.getKey()) + "=" + FormatPrintVisitor.revertStringToQuoted(entry.getValue()));
                if (++index >= size) continue;
                this.out.print(COMMA);
            }
            this.out.print(")");
        }
    }

    protected void printNestField(List<String> filterField) {
        this.printDelimitedStrings(filterField, ".");
    }

    protected void printDelimitedGbyExpressions(List<GbyVariableExpressionPair> gbyList, int step) throws CompilationException {
        int gbySize = gbyList.size();
        int gbyIndex = 0;
        for (GbyVariableExpressionPair pair : gbyList) {
            if (pair.getVar() != null) {
                pair.getVar().accept(this, step);
                this.out.print(this.assignSymbol);
            }
            pair.getExpr().accept(this, step);
            if (++gbyIndex >= gbySize) continue;
            this.out.print(COMMA);
        }
    }

    protected void printDelimitedObyExpressions(List<Expression> list, List<OrderbyClause.OrderModifier> mlist, List<OrderbyClause.NullOrderModifier> nlist, Integer step) throws CompilationException {
        int index = 0;
        int size = list.size();
        for (Expression expr : list) {
            OrderbyClause.NullOrderModifier nullModifier;
            expr.accept(this, step);
            OrderbyClause.OrderModifier orderModifier = mlist.get(index);
            if (orderModifier != OrderbyClause.OrderModifier.ASC) {
                this.out.print(orderModifier.toString().toLowerCase());
            }
            if ((nullModifier = nlist.get(index)) != null) {
                this.out.print(" nulls ");
                this.out.print(nullModifier.toString().toLowerCase());
            }
            if (++index >= size) continue;
            this.out.print(COMMA);
        }
    }

    protected void printDelimitedExpressions(List<? extends Expression> exprs, String delimiter, int step) throws CompilationException {
        int index = 0;
        int size = exprs.size();
        for (Expression expression : exprs) {
            expression.accept(this, step);
            if (++index >= size) continue;
            this.out.print(delimiter);
        }
    }

    protected void printDelimitedStrings(List<String> strs, String delimiter) {
        int index = 0;
        int size = strs.size();
        for (String str : strs) {
            this.out.print(this.normalize(str));
            if (++index >= size) continue;
            this.out.print(delimiter);
        }
    }

    protected void printDelimitedKeys(List<List<String>> keys, String delimiter) {
        int index = 0;
        int size = keys.size();
        for (List<String> strs : keys) {
            this.printDelimitedStrings(strs, ".");
            if (++index >= size) continue;
            this.out.print(delimiter);
        }
    }

    protected void printDelimitedIdentifiers(List<Identifier> ids, String delimiter) {
        int index = 0;
        int size = ids.size();
        for (Identifier id : ids) {
            this.out.print(this.normalize(id.getValue()));
            if (++index >= size) continue;
            this.out.print(delimiter);
        }
    }

    protected boolean needQuotes(String str) {
        if (str.length() == 0) {
            return false;
        }
        if (!this.validIdentifierStartChars.contains(Character.valueOf(str.charAt(0)))) {
            return true;
        }
        for (char ch : str.toCharArray()) {
            if (this.validIdentifierChars.contains(Character.valueOf(ch))) continue;
            return true;
        }
        return false;
    }

    protected String normalize(String str) {
        if (this.needQuotes(str)) {
            return FormatPrintVisitor.revertStringToQuoted(str);
        }
        return str;
    }

    protected String generateDataverseName(DataverseName dataverseName) {
        StringBuilder sb = new StringBuilder();
        this.dataverseNameParts.clear();
        dataverseName.getParts(this.dataverseNameParts);
        int ln = this.dataverseNameParts.size();
        for (int i = 0; i < ln; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(this.normalize(this.dataverseNameParts.get(i)));
        }
        return sb.toString();
    }

    protected String generateFullName(DataverseName dataverseName, String identifier) {
        String dataversePrefix = dataverseName != null && !dataverseName.equals((Object)MetadataConstants.METADATA_DATAVERSE_NAME) ? this.generateDataverseName(dataverseName) + "." : "";
        return dataversePrefix + this.normalize(identifier);
    }

    protected String generateFullName(DataverseName dataverseName, Identifier ds) {
        return this.generateFullName(dataverseName, ds.getValue());
    }

    protected String generateIfNotExists(boolean ifNotExits) {
        return ifNotExits ? " if not exists " : "";
    }

    protected String generateIfExists(boolean ifExits) {
        return ifExits ? " if exists" : "";
    }

    protected String generateOrReplace(boolean orReplace) {
        return orReplace ? " or replace" : "";
    }

    protected String generateIndexTypeString(DatasetConfig.IndexType type) {
        switch (type) {
            case BTREE: {
                return "btree";
            }
            case RTREE: {
                return "rtree";
            }
            case SINGLE_PARTITION_WORD_INVIX: {
                return "fulltext";
            }
            case LENGTH_PARTITIONED_WORD_INVIX: {
                return "keyword";
            }
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                return "ngram";
            }
        }
        return "";
    }

    public static String revertStringToQuoted(String inputStr) {
        int size = inputStr.length();
        StringBuffer result = new StringBuffer();
        block10: for (int pos = 0; pos < size; ++pos) {
            char ch = inputStr.charAt(pos);
            switch (ch) {
                case '\\': {
                    result.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    result.append("\\b");
                    continue block10;
                }
                case '\f': {
                    result.append("\\f");
                    continue block10;
                }
                case '\n': {
                    result.append("\\n");
                    continue block10;
                }
                case '\r': {
                    result.append("\\r");
                    continue block10;
                }
                case '\t': {
                    result.append("\\t");
                    continue block10;
                }
                case '\'': {
                    result.append("\\'");
                    continue block10;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block10;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return "\"" + result.toString() + "\"";
    }

    public String revertStringToLiteral(String inputStr) {
        int size = inputStr.length();
        StringBuffer result = new StringBuffer();
        block9: for (int pos = 0; pos < size; ++pos) {
            char ch = inputStr.charAt(pos);
            switch (ch) {
                case '\\': {
                    result.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    result.append("\\b");
                    continue block9;
                }
                case '\f': {
                    result.append("\\f");
                    continue block9;
                }
                case '\n': {
                    result.append("\\n");
                    continue block9;
                }
                case '\r': {
                    result.append("\\r");
                    continue block9;
                }
                case '\t': {
                    result.append("\\t");
                    continue block9;
                }
                case '\'': {
                    result.append("\\'");
                    continue block9;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return "'" + result.toString() + "'";
    }

    protected void printHints(List<IExpressionAnnotation> annotations, int step) {
        if (annotations != null) {
            for (IExpressionAnnotation annotation : annotations) {
                this.out.print(" /*+ " + annotation + " */ ");
            }
        }
    }
}

