/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.event.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class LatencyMetric {
    private final long min;
    private final long max;
    private final long count;
    private final Map<Double, Long> percentiles;
    private final TimeUnit unit;

    public LatencyMetric(long min, long max, long count, Map<Double, Long> percentiles, TimeUnit unit) {
        this.min = min;
        this.max = max;
        this.count = count;
        this.percentiles = percentiles;
        this.unit = unit;
    }

    public long min() {
        return this.min;
    }

    public long max() {
        return this.max;
    }

    public long count() {
        return this.count;
    }

    public Map<Double, Long> percentiles() {
        return this.percentiles;
    }

    public TimeUnit timeUnit() {
        return this.unit;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LatencyMetric{");
        sb.append("min=").append(this.min);
        sb.append(", max=").append(this.max);
        sb.append(", count=").append(this.count);
        sb.append(", percentiles=").append(this.percentiles);
        sb.append(", timeUnit=").append((Object)this.unit);
        sb.append('}');
        return sb.toString();
    }

    public Map<String, Object> export() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("min", this.min());
        result.put("max", this.max());
        result.put("count", this.count());
        result.put("percentiles", this.percentiles());
        result.put("timeUnit", this.timeUnit().toString());
        return result;
    }
}

