/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.util.List;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IProjectionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.impls.DefaultTupleProjectorFactory;
import org.apache.hyracks.storage.common.projection.ITupleProjectorFactory;

public class SampleDataSource
extends DataSource {
    private final Dataset dataset;
    private final String sampleIndexName;

    public SampleDataSource(Dataset dataset, String sampleIndexName, IAType itemType, IAType metaItemType, INodeDomain domain) throws AlgebricksException {
        super(SampleDataSource.createSampleDataSourceId(dataset, sampleIndexName), itemType, metaItemType, (byte)5, domain);
        this.dataset = dataset;
        this.sampleIndexName = sampleIndexName;
        this.schemaTypes = DatasetDataSource.createSchemaTypesForInternalDataset(itemType, metaItemType, (InternalDatasetDetails)dataset.getDatasetDetails());
    }

    @Override
    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildDatasourceScanRuntime(MetadataProvider metadataProvider, IDataSource<DataSourceId> dataSource, List<LogicalVariable> scanVariables, List<LogicalVariable> projectVariables, boolean projectPushed, List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars, ITupleFilterFactory tupleFilterFactory, long outputLimit, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, JobSpecification jobSpec, Object implConfig, IProjectionInfo<?> projectionInfo) throws AlgebricksException {
        return metadataProvider.buildBtreeRuntime(jobSpec, opSchema, typeEnv, context, true, false, null, this.dataset, this.sampleIndexName, null, null, true, true, false, null, null, null, tupleFilterFactory, outputLimit, false, false, (ITupleProjectorFactory)DefaultTupleProjectorFactory.INSTANCE);
    }

    public boolean isScanAccessPathALeaf() {
        return false;
    }

    private static DataSourceId createSampleDataSourceId(Dataset dataset, String sampleIndexName) {
        return new DataSourceId(dataset.getDataverseName(), dataset.getDatasetName(), new String[]{sampleIndexName});
    }
}

