/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.algebra.operators.physical;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.asterix.runtime.operators.joins.spatial.PlaneSweepJoinOperatorDescriptor;
import org.apache.asterix.runtime.operators.joins.spatial.utils.ISpatialJoinUtilFactory;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.UnorderedPartitionedProperty;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;

public class SpatialJoinPOperator
extends AbstractJoinPOperator {
    private final List<LogicalVariable> keysLeftBranch;
    private final List<LogicalVariable> keysRightBranch;
    protected final ISpatialJoinUtilFactory mjcf;
    private final int memSizeInFrames;

    public SpatialJoinPOperator(AbstractBinaryJoinOperator.JoinKind kind, AbstractJoinPOperator.JoinPartitioningType partitioningType, List<LogicalVariable> keysLeftBranch, List<LogicalVariable> keysRightBranch, int memSizeInFrames, ISpatialJoinUtilFactory mjcf) {
        super(kind, partitioningType);
        this.keysLeftBranch = keysLeftBranch;
        this.keysRightBranch = keysRightBranch;
        this.mjcf = mjcf;
        this.memSizeInFrames = memSizeInFrames;
    }

    public List<LogicalVariable> getKeysLeftBranch() {
        return this.keysLeftBranch;
    }

    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.SPATIAL_JOIN;
    }

    public boolean isMicroOperator() {
        return false;
    }

    public String toString() {
        return "SPATIAL_JOIN " + this.keysLeftBranch + " " + this.keysRightBranch;
    }

    public void computeDeliveredProperties(ILogicalOperator iop, IOptimizationContext context) throws AlgebricksException {
        Object pp;
        AbstractLogicalOperator op = (AbstractLogicalOperator)iop;
        if (op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.LOCAL) {
            AbstractLogicalOperator op0 = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
            IPhysicalPropertiesVector pv0 = op0.getPhysicalOperator().getDeliveredProperties();
            AbstractLogicalOperator op1 = (AbstractLogicalOperator)((Mutable)op.getInputs().get(1)).getValue();
            IPhysicalPropertiesVector pv1 = op1.getPhysicalOperator().getDeliveredProperties();
            pp = pv0 == null || pv1 == null ? null : pv0.getPartitioningProperty();
        } else {
            pp = IPartitioningProperty.UNPARTITIONED;
        }
        this.deliveredProperties = new StructuralPropertiesVector(pp, this.deliveredLocalProperties(iop, context));
    }

    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        ArrayList<LogicalVariable> keysLeftBranchTileId = new ArrayList<LogicalVariable>();
        keysLeftBranchTileId.add(this.keysLeftBranch.get(0));
        ArrayList<LogicalVariable> keysRightBranchTileId = new ArrayList<LogicalVariable>();
        keysRightBranchTileId.add(this.keysRightBranch.get(0));
        UnorderedPartitionedProperty pp1 = new UnorderedPartitionedProperty((Set)new ListSet(keysLeftBranchTileId), context.getComputationNodeDomain());
        UnorderedPartitionedProperty pp2 = new UnorderedPartitionedProperty((Set)new ListSet(keysRightBranchTileId), context.getComputationNodeDomain());
        ArrayList<LocalOrderProperty> localProperties1 = new ArrayList<LocalOrderProperty>();
        ArrayList<OrderColumn> orderColumns1 = new ArrayList<OrderColumn>();
        orderColumns1.add(new OrderColumn(this.keysLeftBranch.get(0), OrderOperator.IOrder.OrderKind.ASC));
        orderColumns1.add(new OrderColumn(this.keysLeftBranch.get(1), OrderOperator.IOrder.OrderKind.ASC));
        localProperties1.add(new LocalOrderProperty(orderColumns1));
        ArrayList<LocalOrderProperty> localProperties2 = new ArrayList<LocalOrderProperty>();
        ArrayList<OrderColumn> orderColumns2 = new ArrayList<OrderColumn>();
        orderColumns2.add(new OrderColumn(this.keysRightBranch.get(0), OrderOperator.IOrder.OrderKind.ASC));
        orderColumns2.add(new OrderColumn(this.keysRightBranch.get(1), OrderOperator.IOrder.OrderKind.ASC));
        localProperties2.add(new LocalOrderProperty(orderColumns2));
        StructuralPropertiesVector[] pv = new StructuralPropertiesVector[]{new StructuralPropertiesVector((IPartitioningProperty)pp1, localProperties1), new StructuralPropertiesVector((IPartitioningProperty)pp2, localProperties2)};
        return new PhysicalRequirements((IPhysicalPropertiesVector[])pv, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        int[] keysBuild = JobGenHelper.variablesToFieldIndexes(this.keysLeftBranch, (IOperatorSchema)inputSchemas[0]);
        int[] keysProbe = JobGenHelper.variablesToFieldIndexes(this.keysRightBranch, (IOperatorSchema)inputSchemas[1]);
        JobSpecification spec = builder.getJobSpec();
        RecordDescriptor recordDescriptor = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)context.getTypeEnvironment(op), (IOperatorSchema)propagatedSchema, (JobGenContext)context);
        PlaneSweepJoinOperatorDescriptor opDesc = new PlaneSweepJoinOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.memSizeInFrames, keysBuild, keysProbe, recordDescriptor, this.mjcf);
        this.contributeOpDesc(builder, (AbstractLogicalOperator)op, (IOperatorDescriptor)opDesc);
        ILogicalOperator src1 = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        builder.contributeGraphEdge(src1, 0, op, 0);
        ILogicalOperator src2 = (ILogicalOperator)((Mutable)op.getInputs().get(1)).getValue();
        builder.contributeGraphEdge(src2, 0, op, 1);
    }

    protected List<ILocalStructuralProperty> deliveredLocalProperties(ILogicalOperator op, IOptimizationContext context) {
        AbstractLogicalOperator op0 = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        IPhysicalPropertiesVector pv0 = op0.getPhysicalOperator().getDeliveredProperties();
        List lp0 = pv0.getLocalProperties();
        if (lp0 != null) {
            return new LinkedList<ILocalStructuralProperty>(lp0);
        }
        return new LinkedList<ILocalStructuralProperty>();
    }
}

