/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.buffercache;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.hyracks.api.replication.IIOReplicationManager;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.storage.common.buffercache.BufferCacheHeaderHelper;
import org.apache.hyracks.storage.common.buffercache.CachedPage;
import org.apache.hyracks.storage.common.buffercache.FIFOLocalWriter;
import org.apache.hyracks.storage.common.buffercache.IBufferCacheInternal;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.ICachedPageInternal;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageWriter;
import org.apache.hyracks.storage.common.buffercache.IPageCleanerPolicy;
import org.apache.hyracks.storage.common.buffercache.IPageReplacementStrategy;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;
import org.apache.hyracks.storage.common.compression.file.ICompressedPageWriter;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;
import org.apache.hyracks.storage.common.file.IFileMapManager;
import org.apache.hyracks.util.IThreadStats;
import org.apache.hyracks.util.IThreadStatsCollector;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferCache
implements IBufferCacheInternal,
ILifeCycleComponent,
IThreadStatsCollector {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAP_FACTOR = 3;
    private static final int MIN_CLEANED_COUNT_DIFF = 3;
    private static final int PIN_MAX_WAIT_TIME = 50;
    private static final int PIN_ATTEMPT_CYCLES_WARNING_THRESHOLD = 3;
    private static final int MAX_PIN_ATTEMPT_CYCLES = 1000;
    private static final int MAX_PAGE_READ_ATTEMPTS = 5;
    private static final long PERIOD_BETWEEN_READ_ATTEMPTS = 100L;
    public static final boolean DEBUG = false;
    private final int pageSize;
    private final int maxOpenFiles;
    final IIOManager ioManager;
    private final CacheBucket[] pageMap;
    private final IPageReplacementStrategy pageReplacementStrategy;
    private final IPageCleanerPolicy pageCleanerPolicy;
    private final IFileMapManager fileMapManager;
    private final CleanerThread cleanerThread;
    private final Map<Integer, BufferedFileHandle> fileInfoMap;
    private final BlockingQueue<BufferCacheHeaderHelper> headerPageCache;
    private IIOReplicationManager ioReplicationManager;
    private final List<ICachedPageInternal> cachedPages = new ArrayList<ICachedPageInternal>();
    private final AtomicLong masterPinCount = new AtomicLong();
    private final Map<Thread, IThreadStats> statsSubscribers = new ConcurrentHashMap<Thread, IThreadStats>();
    private boolean closed;
    private static final Level fileOpsLevel = Level.TRACE;
    private ArrayList<CachedPage> confiscatedPages;
    private Lock confiscateLock;
    private HashMap<CachedPage, StackTraceElement[]> confiscatedPagesOwner;
    private ConcurrentHashMap<CachedPage, StackTraceElement[]> pinnedPageOwner;

    public BufferCache(IIOManager ioManager, IPageReplacementStrategy pageReplacementStrategy, IPageCleanerPolicy pageCleanerPolicy, IFileMapManager fileMapManager, int maxOpenFiles, int ioQueuelen, ThreadFactory threadFactory) {
        this.headerPageCache = new ArrayBlockingQueue<BufferCacheHeaderHelper>(ioQueuelen);
        this.ioManager = ioManager;
        this.pageSize = pageReplacementStrategy.getPageSize();
        this.maxOpenFiles = maxOpenFiles;
        pageReplacementStrategy.setBufferCache(this);
        this.pageMap = new CacheBucket[pageReplacementStrategy.getMaxAllowedNumPages() * 3 + 1];
        for (int i = 0; i < this.pageMap.length; ++i) {
            this.pageMap[i] = new CacheBucket();
        }
        this.pageReplacementStrategy = pageReplacementStrategy;
        this.pageCleanerPolicy = pageCleanerPolicy;
        this.fileMapManager = fileMapManager;
        ExecutorService executor = Executors.newCachedThreadPool(threadFactory);
        this.fileInfoMap = new HashMap<Integer, BufferedFileHandle>();
        this.cleanerThread = new CleanerThread();
        executor.execute(this.cleanerThread);
        this.closed = false;
    }

    public BufferCache(IIOManager ioManager, IPageReplacementStrategy pageReplacementStrategy, IPageCleanerPolicy pageCleanerPolicy, IFileMapManager fileMapManager, int maxOpenFiles, int ioQueueLen, ThreadFactory threadFactory, IIOReplicationManager ioReplicationManager) {
        this(ioManager, pageReplacementStrategy, pageCleanerPolicy, fileMapManager, maxOpenFiles, ioQueueLen, threadFactory);
        this.ioReplicationManager = ioReplicationManager;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getPageSizeWithHeader() {
        return this.pageSize + 8;
    }

    @Override
    public int getPageBudget() {
        return this.pageReplacementStrategy.getMaxAllowedNumPages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pinSanityCheck(long dpid) throws HyracksDataException {
        BufferedFileHandle fInfo;
        if (this.closed) {
            throw new HyracksDataException("pin called on a closed cache");
        }
        int fileId = BufferedFileHandle.getFileId(dpid);
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            fInfo = this.fileInfoMap.get(fileId);
        }
        if (fInfo == null || fInfo.hasBeenDeleted() || !fInfo.hasBeenOpened()) {
            throw new HyracksDataException("pin called on a fileId " + fileId + " that has not been created.");
        }
        if (fInfo.getReferenceCount() <= 0) {
            throw new HyracksDataException("pin called on a fileId " + fileId + " that has not been opened.");
        }
    }

    @Override
    public ICachedPage pin(long dpid, boolean newPage) throws HyracksDataException {
        return this.pin(dpid, newPage, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedPage pin(long dpid, boolean newPage, boolean incrementStats) throws HyracksDataException {
        IThreadStats threadStats = this.statsSubscribers.get(Thread.currentThread());
        if (threadStats != null && incrementStats) {
            threadStats.pagePinned();
        }
        CachedPage cPage = this.findPage(dpid);
        if (!newPage) {
            CachedPage cachedPage = cPage;
            synchronized (cachedPage) {
                if (!cPage.valid) {
                    try {
                        this.tryRead(cPage, incrementStats);
                        cPage.valid = true;
                    }
                    catch (Exception e) {
                        LOGGER.log(ExceptionUtils.causedByInterrupt((Throwable)e) ? Level.DEBUG : Level.WARN, "Failure while trying to read a page from disk", (Throwable)e);
                        throw e;
                    }
                    finally {
                        if (!cPage.valid) {
                            this.unpin(cPage);
                        }
                    }
                }
            }
        }
        cPage.valid = true;
        this.pageReplacementStrategy.notifyCachePageAccess(cPage);
        return cPage;
    }

    private CachedPage findPage(long dpid) throws HyracksDataException {
        return (CachedPage)this.getPageLoop(dpid, -1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICachedPage findPageInner(long dpid) {
        CachedPage cPage;
        int hash = this.hash(dpid);
        CacheBucket bucket = this.pageMap[hash];
        bucket.bucketLock.lock();
        try {
            cPage = bucket.cachedPage;
            while (cPage != null) {
                if (cPage.dpid == dpid) {
                    cPage.pinCount.incrementAndGet();
                    CachedPage cachedPage = cPage;
                    return cachedPage;
                }
                cPage = cPage.next;
            }
        }
        finally {
            bucket.bucketLock.unlock();
        }
        CachedPage victim = (CachedPage)this.pageReplacementStrategy.findVictim();
        if (victim == null) {
            return null;
        }
        if (victim.dpid < 0L) {
            bucket.bucketLock.lock();
            try {
                if (!victim.pinCount.compareAndSet(0, 1)) {
                    ICachedPage iCachedPage = null;
                    return iCachedPage;
                }
                if (victim.dpid >= 0L) {
                    victim.pinCount.decrementAndGet();
                    ICachedPage iCachedPage = null;
                    return iCachedPage;
                }
                cPage = this.findTargetInBucket(dpid, bucket.cachedPage, victim);
                if (cPage != null) {
                    CachedPage cachedPage = cPage;
                    return cachedPage;
                }
                victim.reset(dpid);
                victim.next = bucket.cachedPage;
                bucket.cachedPage = victim;
            }
            finally {
                bucket.bucketLock.unlock();
            }
            return victim;
        }
        int victimHash = this.hash(victim.dpid);
        if (victimHash == hash) {
            bucket.bucketLock.lock();
            try {
                if (!victim.pinCount.compareAndSet(0, 1)) {
                    ICachedPage iCachedPage = null;
                    return iCachedPage;
                }
                if (victimHash != this.hash(victim.dpid)) {
                    victim.pinCount.decrementAndGet();
                    ICachedPage iCachedPage = null;
                    return iCachedPage;
                }
                cPage = this.findTargetInBucket(dpid, bucket.cachedPage, victim);
                if (cPage != null) {
                    CachedPage cachedPage = cPage;
                    return cachedPage;
                }
                victim.reset(dpid);
            }
            finally {
                bucket.bucketLock.unlock();
            }
            return victim;
        }
        CacheBucket victimBucket = this.pageMap[victimHash];
        if (victimHash < hash) {
            victimBucket.bucketLock.lock();
            bucket.bucketLock.lock();
        } else {
            bucket.bucketLock.lock();
            victimBucket.bucketLock.lock();
        }
        try {
            if (!victim.pinCount.compareAndSet(0, 1)) {
                ICachedPage iCachedPage = null;
                return iCachedPage;
            }
            if (victimHash != this.hash(victim.dpid)) {
                victim.pinCount.decrementAndGet();
                ICachedPage iCachedPage = null;
                return iCachedPage;
            }
            cPage = this.findTargetInBucket(dpid, bucket.cachedPage, victim);
            if (cPage != null) {
                CachedPage cachedPage = cPage;
                return cachedPage;
            }
            if (victimBucket.cachedPage == victim) {
                victimBucket.cachedPage = victim.next;
            } else {
                CachedPage victimPrev = victimBucket.cachedPage;
                while (victimPrev.next != victim) {
                    victimPrev = victimPrev.next;
                    if (victimPrev != null) continue;
                    throw new IllegalStateException();
                }
                victimPrev.next = victim.next;
            }
            victim.reset(dpid);
            victim.next = bucket.cachedPage;
            bucket.cachedPage = victim;
        }
        finally {
            victimBucket.bucketLock.unlock();
            bucket.bucketLock.unlock();
        }
        return victim;
    }

    private CachedPage findTargetInBucket(long dpid, CachedPage cPage, CachedPage victim) {
        while (cPage != null) {
            if (cPage.dpid == dpid) {
                cPage.pinCount.incrementAndGet();
                victim.pinCount.decrementAndGet();
                break;
            }
            cPage = cPage.next;
        }
        return cPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dumpState() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Buffer cache state\n");
        buffer.append("Page Size: ").append(this.pageSize).append('\n');
        buffer.append("Number of physical pages: ").append(this.pageReplacementStrategy.getMaxAllowedNumPages()).append('\n');
        buffer.append("Hash table size: ").append(this.pageMap.length).append('\n');
        buffer.append("Page Map:\n");
        buffer.append("cpid -> [fileId:pageId, pinCount, valid/invalid, confiscated/physical, dirty/clean]");
        int nCachedPages = 0;
        for (int i = 0; i < this.pageMap.length; ++i) {
            CacheBucket cb = this.pageMap[i];
            cb.bucketLock.lock();
            try {
                CachedPage cp = cb.cachedPage;
                if (cp == null) continue;
                buffer.append("   ").append(i).append('\n');
                while (cp != null) {
                    buffer.append("      ").append(cp.cpid).append(" -> [").append(BufferedFileHandle.getFileId(cp.dpid)).append(':').append(BufferedFileHandle.getPageId(cp.dpid)).append(", ").append(cp.pinCount.get()).append(", ").append(cp.valid ? "valid" : "invalid").append(", ").append(cp.confiscated.get() ? "confiscated" : "physical").append(", ").append(cp.dirty.get() ? "dirty" : "clean").append("]\n");
                    cp = cp.next;
                    ++nCachedPages;
                }
                continue;
            }
            finally {
                cb.bucketLock.unlock();
            }
        }
        buffer.append("Number of cached pages: ").append(nCachedPages).append('\n');
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClean() {
        LinkedList<Long> reachableDpids = new LinkedList<Long>();
        List<ICachedPageInternal> list = this.cachedPages;
        synchronized (list) {
            for (ICachedPageInternal internalPage : this.cachedPages) {
                CachedPage c = (CachedPage)internalPage;
                if (c.confiscated() || c.latch.getReadLockCount() != 0 || c.latch.getWriteHoldCount() != 0) {
                    return false;
                }
                if (!c.valid) continue;
                reachableDpids.add(c.dpid);
            }
        }
        for (Long l : reachableDpids) {
            if (this.canFindValidCachedPage(l)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canFindValidCachedPage(long dpid) {
        int hash = this.hash(dpid);
        CachedPage cPage = null;
        CacheBucket bucket = this.pageMap[hash];
        bucket.bucketLock.lock();
        try {
            cPage = bucket.cachedPage;
            while (cPage != null) {
                assert (bucket.cachedPage != bucket.cachedPage.next);
                if (cPage.dpid == dpid) {
                    boolean bl = true;
                    return bl;
                }
                cPage = cPage.next;
            }
        }
        finally {
            bucket.bucketLock.unlock();
        }
        return false;
    }

    private void tryRead(CachedPage cPage, boolean incrementStats) throws HyracksDataException {
        for (int i = 1; i <= 5; ++i) {
            try {
                this.read(cPage, incrementStats);
                return;
            }
            catch (HyracksDataException readException) {
                if (readException.matches((IError)ErrorCode.CANNOT_READ_CLOSED_FILE) && i != 5) {
                    try {
                        Thread.sleep(100L);
                        LOGGER.log(Level.WARN, String.format("Failed to read page. Retrying attempt (%d/%d)", i + 1, 5), (Throwable)readException);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw HyracksDataException.create((Throwable)e);
                    }
                }
                throw readException;
            }
        }
    }

    private void read(CachedPage cPage, boolean incrementStats) throws HyracksDataException {
        BufferedFileHandle fInfo = this.getFileHandle(cPage);
        cPage.buffer.clear();
        fInfo.read(cPage);
        IThreadStats threadStats = this.statsSubscribers.get(Thread.currentThread());
        if (threadStats != null && incrementStats) {
            threadStats.coldRead();
        }
    }

    @Override
    public void resizePage(ICachedPage cPage, int totalPages, IExtraPageBlockHelper extraPageBlockHelper) throws HyracksDataException {
        this.pageReplacementStrategy.resizePage((ICachedPageInternal)cPage, totalPages, extraPageBlockHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(CachedPage cPage) throws HyracksDataException {
        BufferedFileHandle fInfo;
        BufferedFileHandle bufferedFileHandle = fInfo = this.getFileHandle(cPage);
        synchronized (bufferedFileHandle) {
            if (fInfo.hasBeenDeleted()) {
                return;
            }
            fInfo.write(cPage);
        }
    }

    @Override
    public void unpin(ICachedPage page) throws HyracksDataException {
        if (this.closed) {
            throw new HyracksDataException("unpin called on a closed cache");
        }
        int pinCount = ((CachedPage)page).pinCount.decrementAndGet();
    }

    public void subscribe(IThreadStats stats) {
        this.statsSubscribers.put(Thread.currentThread(), stats);
    }

    public void unsubscribe() {
        this.statsSubscribers.remove(Thread.currentThread());
    }

    private int hash(long dpid) {
        int hashValue = (int)dpid ^ Integer.reverse((int)(dpid >>> 32)) >>> 1;
        return hashValue % this.pageMap.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedPageInternal getPage(int cpid) {
        List<ICachedPageInternal> list = this.cachedPages;
        synchronized (list) {
            return this.cachedPages.get(cpid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<Integer, BufferedFileHandle> map;
        this.closed = true;
        try {
            map = this.cleanerThread.threadLock;
            synchronized (map) {
                this.cleanerThread.shutdownStart = true;
                this.cleanerThread.threadLock.notifyAll();
                while (!this.cleanerThread.shutdownComplete) {
                    this.cleanerThread.threadLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        map = this.fileInfoMap;
        synchronized (map) {
            this.fileInfoMap.forEach((key, value) -> {
                block2: {
                    try {
                        this.sweepAndFlush((BufferedFileHandle)value, true);
                        value.close();
                    }
                    catch (HyracksDataException e) {
                        if (!LOGGER.isWarnEnabled()) break block2;
                        LOGGER.log(Level.WARN, "Error flushing file id: " + key, (Throwable)e);
                    }
                }
            });
            this.fileInfoMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createFile(FileReference fileRef) throws HyracksDataException {
        if (LOGGER.isEnabled(fileOpsLevel)) {
            LOGGER.log(fileOpsLevel, "Creating file: " + fileRef + " in cache: " + this);
        }
        BufferedFileHandle.createFile(this, fileRef);
        try {
            int fileId;
            Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
            synchronized (map) {
                fileId = this.fileMapManager.registerFile(fileRef);
                this.getOrCreateFileHandle(fileId);
            }
            return fileId;
        }
        catch (Exception e) {
            try {
                IoUtil.delete((FileReference)fileRef);
            }
            catch (Exception deleteException) {
                e.addSuppressed(deleteException);
            }
            throw HyracksDataException.create((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int openFile(FileReference fileRef) throws HyracksDataException {
        if (LOGGER.isEnabled(fileOpsLevel)) {
            LOGGER.log(fileOpsLevel, "Opening file: " + fileRef + " in cache: " + this);
        }
        int fileId = -1;
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            fileId = this.fileMapManager.isMapped(fileRef) ? this.fileMapManager.lookupFileId(fileRef) : this.fileMapManager.registerFile(fileRef);
        }
        this.openFile(fileId);
        return fileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(int fileId) throws HyracksDataException {
        block11: {
            if (LOGGER.isEnabled(fileOpsLevel)) {
                LOGGER.log(fileOpsLevel, "Opening file: " + fileId + " in cache: " + this);
            }
            try {
                BufferedFileHandle fInfo = this.getOrCreateFileHandle(fileId);
                fInfo.incReferenceCount();
                if (fInfo.hasBeenOpened()) break block11;
                BufferedFileHandle bufferedFileHandle = fInfo;
                synchronized (bufferedFileHandle) {
                    if (!fInfo.hasBeenOpened()) {
                        FileReference fileRef;
                        if (this.fileInfoMap.size() > this.maxOpenFiles) {
                            this.closeOpeningFiles(fInfo);
                        }
                        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
                        synchronized (map) {
                            fileRef = this.fileMapManager.lookupFileName(fileId);
                        }
                        fInfo.open(fileRef);
                    }
                }
            }
            catch (Exception e) {
                this.removeFileHandle(fileId);
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOpeningFiles(BufferedFileHandle newFileHandle) throws HyracksDataException {
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            boolean unreferencedFileFound = true;
            block3: while (this.fileInfoMap.size() > this.maxOpenFiles && unreferencedFileFound) {
                unreferencedFileFound = false;
                for (Map.Entry<Integer, BufferedFileHandle> entry : this.fileInfoMap.entrySet()) {
                    BufferedFileHandle fh = entry.getValue();
                    if (fh == newFileHandle || fh.getReferenceCount() > 0) continue;
                    if (fh.getReferenceCount() < 0) {
                        throw new IllegalStateException("Illegal reference count " + fh.getReferenceCount() + " of file " + fh.getFileReference());
                    }
                    int entryFileId = entry.getKey();
                    this.sweepAndFlush(fh, true);
                    entry.getValue().close();
                    this.fileInfoMap.remove(entryFileId);
                    unreferencedFileFound = true;
                    continue block3;
                }
            }
            if (this.fileInfoMap.size() > this.maxOpenFiles) {
                throw new HyracksDataException("Could not open fileId " + newFileHandle.getFileId() + ". Max number of files " + this.maxOpenFiles + " already opened and referenced.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sweepAndFlush(BufferedFileHandle fInfo, boolean flushDirtyPages) throws HyracksDataException {
        if (!fInfo.hasBeenOpened()) {
            return;
        }
        int fileId = fInfo.getFileId();
        for (CacheBucket bucket : this.pageMap) {
            bucket.bucketLock.lock();
            try {
                CachedPage cPage;
                CachedPage prev = bucket.cachedPage;
                while (prev != null && (cPage = prev.next) != null) {
                    if (this.invalidateIfFileIdMatch(fileId, cPage, flushDirtyPages)) {
                        prev.next = cPage.next;
                        cPage.next = null;
                        continue;
                    }
                    prev = cPage;
                }
                if (bucket.cachedPage == null || !this.invalidateIfFileIdMatch(fileId, bucket.cachedPage, flushDirtyPages)) continue;
                cPage = bucket.cachedPage;
                bucket.cachedPage = bucket.cachedPage.next;
                cPage.next = null;
            }
            finally {
                bucket.bucketLock.unlock();
            }
        }
    }

    private boolean invalidateIfFileIdMatch(int fileId, CachedPage cPage, boolean flushDirtyPages) throws HyracksDataException {
        if (BufferedFileHandle.getFileId(cPage.dpid) == fileId) {
            int pinCount;
            if (cPage.dirty.get()) {
                if (flushDirtyPages) {
                    this.write(cPage);
                }
                cPage.dirty.set(false);
                pinCount = cPage.pinCount.decrementAndGet();
            } else {
                pinCount = cPage.pinCount.get();
            }
            if (pinCount > 0) {
                throw new IllegalStateException("Page " + BufferedFileHandle.getFileId(cPage.dpid) + ":" + BufferedFileHandle.getPageId(cPage.dpid) + " is pinned and file is being closed. Pincount is: " + pinCount + " Page is confiscated: " + cPage.confiscated);
            }
            cPage.invalidate();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile(int fileId) throws HyracksDataException {
        if (LOGGER.isEnabled(fileOpsLevel)) {
            LOGGER.log(fileOpsLevel, "Closing file: " + fileId + " in cache: " + this);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.dumpState());
        }
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            BufferedFileHandle fInfo = this.fileInfoMap.get(fileId);
            if (fInfo == null || !fInfo.hasBeenOpened()) {
                throw new HyracksDataException("Closing unopened file");
            }
            if (fInfo.decReferenceCount() < 0) {
                throw new HyracksDataException("Closed fileId: " + fileId + " more times than it was opened.");
            }
        }
        if (LOGGER.isEnabled(fileOpsLevel)) {
            LOGGER.log(fileOpsLevel, "Closed file: " + fileId + " in cache: " + this);
        }
    }

    @Override
    public void flush(ICachedPage page) throws HyracksDataException {
        this.cleanerThread.cleanPage((CachedPage)page, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force(int fileId, boolean metadata) throws HyracksDataException {
        BufferedFileHandle fInfo;
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            fInfo = this.fileInfoMap.get(fileId);
        }
        fInfo.force(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(FileReference fileRef) throws HyracksDataException {
        boolean mapped = false;
        int fileId = -1;
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            if (this.fileMapManager.isMapped(fileRef)) {
                mapped = true;
                fileId = this.fileMapManager.lookupFileId(fileRef);
            }
        }
        if (mapped) {
            this.deleteFile(fileId);
        } else {
            BufferedFileHandle.deleteFile(fileRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(int fileId) throws HyracksDataException {
        BufferedFileHandle fInfo;
        if (LOGGER.isEnabled(fileOpsLevel)) {
            LOGGER.log(fileOpsLevel, "Deleting file: " + fileId + " in cache: " + this);
        }
        if ((fInfo = this.removeFileHandle(fileId)) == null) {
            return;
        }
        this.sweepAndFlush(fInfo, false);
        try {
            if (fInfo.getReferenceCount() > 0) {
                throw new HyracksDataException("Deleting open file");
            }
        }
        finally {
            Object object;
            FileReference fileRef = null;
            try {
                object = this.fileInfoMap;
                synchronized (object) {
                    fileRef = this.fileMapManager.unregisterFile(fileId);
                }
            }
            catch (Throwable throwable) {
                try {
                    BufferedFileHandle bufferedFileHandle = fInfo;
                    synchronized (bufferedFileHandle) {
                        fInfo.close();
                        fInfo.markAsDeleted();
                    }
                }
                catch (Throwable throwable2) {
                    BufferedFileHandle.deleteFile(fileRef);
                    throw throwable2;
                }
                BufferedFileHandle.deleteFile(fileRef);
                throw throwable;
            }
            try {
                object = fInfo;
                synchronized (object) {
                    fInfo.close();
                    fInfo.markAsDeleted();
                }
            }
            finally {
                BufferedFileHandle.deleteFile(fileRef);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getFileReferenceCount(int fileId) {
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            BufferedFileHandle fInfo = this.fileInfoMap.get(fileId);
            if (fInfo != null) {
                return fInfo.getReferenceCount();
            }
            return 0;
        }
    }

    public void start() {
    }

    public void stop(boolean dumpState, OutputStream os) throws IOException {
        if (dumpState) {
            this.dumpState(os);
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPage(ICachedPageInternal page) {
        List<ICachedPageInternal> list = this.cachedPages;
        synchronized (list) {
            int cpid = page.getCachedPageId();
            if (cpid < this.cachedPages.size()) {
                this.cachedPages.set(cpid, page);
            } else {
                if (cpid > this.cachedPages.size()) {
                    this.cachedPages.addAll(Collections.nCopies(cpid - this.cachedPages.size(), null));
                }
                this.cachedPages.add(page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePage(ICachedPageInternal victimPage) {
        CachedPage victim = (CachedPage)victimPage;
        if (victim.dpid < 0L) {
            if (!victim.pinCount.compareAndSet(0, 1)) {
                return false;
            }
            if (victim.dpid >= 0L) {
                victim.pinCount.decrementAndGet();
                return false;
            }
        } else {
            int pageHash = this.hash(victim.dpid);
            CacheBucket bucket = this.pageMap[pageHash];
            bucket.bucketLock.lock();
            try {
                if (!victim.pinCount.compareAndSet(0, 1)) {
                    boolean bl = false;
                    return bl;
                }
                if (pageHash != this.hash(victim.dpid)) {
                    victim.pinCount.decrementAndGet();
                    boolean bl = false;
                    return bl;
                }
                CachedPage curr = bucket.cachedPage;
                CachedPage prev = null;
                boolean found = false;
                while (curr != null) {
                    if (curr == victim) {
                        if (prev == null) {
                            bucket.cachedPage = curr.next;
                        } else {
                            prev.next = curr.next;
                        }
                        curr.next = null;
                        found = true;
                        break;
                    }
                    prev = curr;
                    curr = curr.next;
                }
                assert (found);
            }
            finally {
                bucket.bucketLock.unlock();
            }
        }
        List<ICachedPageInternal> list = this.cachedPages;
        synchronized (list) {
            ICachedPageInternal iCachedPageInternal = this.cachedPages.set(victim.cpid, null);
        }
        return true;
    }

    public void dumpState(OutputStream os) throws IOException {
        os.write(this.dumpState().getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumPagesOfFile(int fileId) throws HyracksDataException {
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            BufferedFileHandle fInfo = this.fileInfoMap.get(fileId);
            if (fInfo == null) {
                throw new HyracksDataException("No such file mapped for fileId:" + fileId);
            }
            return fInfo.getNumberOfPages();
        }
    }

    @Override
    public ICachedPage confiscatePage(long dpid) throws HyracksDataException {
        return this.confiscatePage(dpid, 1);
    }

    @Override
    public ICachedPage confiscateLargePage(long dpid, int multiplier, int extraBlockPageId) throws HyracksDataException {
        ICachedPage cachedPage = this.confiscatePage(dpid, multiplier);
        ((ICachedPageInternal)cachedPage).setExtraBlockPageId(extraBlockPageId);
        return cachedPage;
    }

    private ICachedPage confiscatePage(long dpid, int multiplier) throws HyracksDataException {
        ICachedPage page = this.getPageLoop(dpid, multiplier, true);
        page.getBuffer().clear();
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICachedPage confiscateInner(long dpid, int multiplier) {
        CachedPage returnPage = null;
        CachedPage victim = (CachedPage)this.pageReplacementStrategy.findVictim(multiplier);
        if (victim == null) {
            return victim;
        }
        if (victim.dpid < 0L) {
            if (!victim.pinCount.compareAndSet(0, 1)) {
                return null;
            }
            if (victim.dpid >= 0L) {
                victim.pinCount.decrementAndGet();
                return null;
            }
            returnPage = victim;
            returnPage.dpid = dpid;
        } else {
            int pageHash = this.hash(victim.getDiskPageId());
            CacheBucket bucket = this.pageMap[pageHash];
            bucket.bucketLock.lock();
            try {
                CachedPage curr = bucket.cachedPage;
                CachedPage prev = null;
                boolean found = false;
                while (curr != null) {
                    if (curr == victim) {
                        if (!victim.pinCount.compareAndSet(0, 1)) break;
                        if (prev == null) {
                            bucket.cachedPage = curr.next;
                        } else {
                            prev.next = curr.next;
                        }
                        curr.next = null;
                        found = true;
                        break;
                    }
                    prev = curr;
                    curr = curr.next;
                }
                if (found) {
                    returnPage = victim;
                    returnPage.dpid = dpid;
                }
            }
            finally {
                bucket.bucketLock.unlock();
            }
        }
        if (returnPage != null) {
            returnPage.confiscated.set(true);
            return returnPage;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedFileHandle getOrCreateFileHandle(int fileId) throws HyracksDataException {
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            FileReference fileRef = this.fileMapManager.lookupFileName(fileId);
            return this.fileInfoMap.computeIfAbsent(fileId, id -> BufferedFileHandle.create(fileRef, fileId, this, this.ioManager, this.headerPageCache, this.pageReplacementStrategy));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedFileHandle removeFileHandle(int fileId) {
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            return this.fileInfoMap.remove(fileId);
        }
    }

    private BufferedFileHandle getFileHandle(CachedPage cPage) throws HyracksDataException {
        return this.getFileHandle(BufferedFileHandle.getFileId(cPage.dpid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedFileHandle getFileHandle(int fileId) throws HyracksDataException {
        BufferedFileHandle fInfo;
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            fInfo = this.fileInfoMap.get(fileId);
        }
        if (fInfo == null) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.FILE_DOES_NOT_EXIST, (Serializable[])new Serializable[]{Integer.valueOf(fileId)});
        }
        return fInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICachedPage getPageLoop(long dpid, int multiplier, boolean confiscate) throws HyracksDataException {
        long startingPinCount = -1L;
        int cycleCount = 0;
        try {
            while (true) {
                Object object;
                ICachedPage page;
                ++cycleCount;
                int startCleanedCount = this.cleanerThread.cleanedCount;
                ICachedPage iCachedPage = page = confiscate ? this.confiscateInner(dpid, multiplier) : this.findPageInner(dpid);
                if (page != null) {
                    this.masterPinCount.incrementAndGet();
                    object = page;
                    return object;
                }
                object = this.cleanerThread.threadLock;
                synchronized (object) {
                    try {
                        this.pageCleanerPolicy.notifyVictimNotFound(this.cleanerThread.threadLock);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.cleanerThread.cleanedCount - startCleanedCount > 3) continue;
                object = this.cleanerThread.cleanNotification;
                synchronized (object) {
                    try {
                        this.cleanerThread.cleanNotification.wait(50L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (cycleCount > 1000) break;
            }
            cycleCount = 0;
            throw new HyracksDataException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Unable to find free page in buffer cache after 1000 cycles (buffer cache undersized?)"})));
        }
        finally {
            if (cycleCount > 3 && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Took " + cycleCount + " cycles to find free page in buffer cache.  (buffer cache undersized?)");
            }
        }
    }

    @Override
    public void returnPage(ICachedPage page) {
        this.returnPage(page, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnPage(ICachedPage page, boolean reinsert) {
        CachedPage cPage = (CachedPage)page;
        if (!page.confiscated()) {
            return;
        }
        if (reinsert) {
            int hash = this.hash(cPage.dpid);
            CacheBucket bucket = this.pageMap[hash];
            bucket.bucketLock.lock();
            try {
                cPage.reset(cPage.dpid);
                cPage.valid = true;
                cPage.next = bucket.cachedPage;
                bucket.cachedPage = cPage;
                cPage.pinCount.decrementAndGet();
            }
            finally {
                bucket.bucketLock.unlock();
            }
        } else {
            cPage.invalidate();
            cPage.pinCount.decrementAndGet();
        }
        this.pageReplacementStrategy.adviseWontNeed(cPage);
    }

    @Override
    public IFIFOPageWriter createFIFOWriter(IPageWriteCallback callback, IPageWriteFailureCallback failureCallback) {
        return new FIFOLocalWriter(this, callback, failureCallback);
    }

    @Override
    public boolean isReplicationEnabled() {
        if (this.ioReplicationManager != null) {
            return this.ioReplicationManager.isReplicationEnabled();
        }
        return false;
    }

    @Override
    public IIOReplicationManager getIOReplicationManager() {
        return this.ioReplicationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeHandle(int fileId) throws HyracksDataException {
        BufferedFileHandle fh = this.removeFileHandle(fileId);
        if (fh != null) {
            Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
            synchronized (map) {
                this.fileMapManager.unregisterFile(fileId);
                fh.purge();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFileIfOpen(FileReference fileRef) {
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            if (this.fileMapManager.isMapped(fileRef)) {
                int fileId;
                try {
                    fileId = this.fileMapManager.lookupFileId(fileRef);
                }
                catch (HyracksDataException e) {
                    throw new IllegalStateException(e);
                }
                BufferedFileHandle fInfo = this.fileInfoMap.get(fileId);
                if (fInfo != null && fInfo.getReferenceCount() > 0) {
                    fInfo.decReferenceCount();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICompressedPageWriter getCompressedPageWriter(int fileId) {
        BufferedFileHandle fInfo;
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            fInfo = this.fileInfoMap.get(fileId);
        }
        return fInfo.getCompressedPageWriter();
    }

    private static class CacheBucket {
        private final Lock bucketLock = new ReentrantLock();
        private CachedPage cachedPage;
    }

    private class CleanerThread
    implements Runnable {
        private volatile boolean shutdownStart = false;
        private volatile boolean shutdownComplete = false;
        private final Object threadLock = new Object();
        private final Object cleanNotification = new Object();
        private volatile int cleanedCount = 0;

        private CleanerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanPage(CachedPage cPage, boolean force) {
            if (cPage.dirty.get() && !cPage.confiscated.get()) {
                boolean proceed = false;
                if (force) {
                    cPage.latch.writeLock().lock();
                    proceed = true;
                } else {
                    proceed = cPage.latch.readLock().tryLock();
                }
                if (proceed) {
                    try {
                        this.cleanPageLocked(cPage);
                    }
                    finally {
                        if (force) {
                            cPage.latch.writeLock().unlock();
                        } else {
                            cPage.latch.readLock().unlock();
                        }
                    }
                } else if (this.shutdownStart) {
                    throw new IllegalStateException("Cache closed, but unable to acquire read lock on dirty page: " + cPage.dpid);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanPageLocked(CachedPage cPage) {
            if (!cPage.dirty.get()) {
                return;
            }
            boolean cleaned = true;
            try {
                BufferCache.this.write(cPage);
            }
            catch (HyracksDataException e) {
                LOGGER.log(Level.WARN, "Unable to write dirty page", (Throwable)e);
                cleaned = false;
            }
            if (cleaned) {
                cPage.dirty.set(false);
                cPage.pinCount.decrementAndGet();
                ++this.cleanedCount;
                Object object = this.cleanNotification;
                synchronized (object) {
                    this.cleanNotification.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.threadLock;
            synchronized (object) {
                try {
                    while (!this.shutdownStart) {
                        this.runCleanCycle();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.shutdownComplete = true;
                    this.threadLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runCleanCycle() throws InterruptedException {
            BufferCache.this.pageCleanerPolicy.notifyCleanCycleStart(this.threadLock);
            int curPage = 0;
            while (true) {
                List<ICachedPageInternal> list = BufferCache.this.cachedPages;
                synchronized (list) {
                    if (curPage >= BufferCache.this.cachedPages.size()) {
                        break;
                    }
                    CachedPage cPage = (CachedPage)BufferCache.this.cachedPages.get(curPage);
                    if (cPage != null) {
                        this.cleanPage(cPage, false);
                    }
                }
                ++curPage;
            }
            if (!this.shutdownStart) {
                BufferCache.this.pageCleanerPolicy.notifyCleanCycleFinish(this.threadLock);
            }
        }
    }
}

