/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators.joins.interval.utils;

import org.apache.asterix.om.pointables.nonvisitor.AIntervalPointable;
import org.apache.asterix.runtime.evaluators.functions.temporal.IntervalLogic;
import org.apache.asterix.runtime.operators.joins.interval.utils.IIntervalJoinUtil;
import org.apache.asterix.runtime.operators.joins.interval.utils.memory.IntervalJoinUtil;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class AbstractIntervalJoinUtil
implements IIntervalJoinUtil {
    protected final int idBuild;
    protected final int idProbe;
    protected final IntervalLogic il = new IntervalLogic();
    protected final AIntervalPointable ipBuild = (AIntervalPointable)AIntervalPointable.FACTORY.createPointable();
    protected final AIntervalPointable ipProbe = (AIntervalPointable)AIntervalPointable.FACTORY.createPointable();

    public AbstractIntervalJoinUtil(int idBuild, int idProbe) {
        this.idBuild = idBuild;
        this.idProbe = idProbe;
    }

    @Override
    public boolean checkToSaveInMemory(IFrameTupleAccessor buildAccessor, int buildTupleIndex, IFrameTupleAccessor probeAccessor, int probeTupleIndex) {
        long probeStart;
        long buildStart = IntervalJoinUtil.getIntervalStart(buildAccessor, buildTupleIndex, this.idBuild);
        return buildStart <= (probeStart = IntervalJoinUtil.getIntervalStart(probeAccessor, probeTupleIndex, this.idProbe));
    }

    @Override
    public boolean checkToRemoveInMemory(IFrameTupleAccessor buildAccessor, int buildTupleIndex, IFrameTupleAccessor probeAccessor, int probeTupleIndex) {
        long probeStart;
        long buildStart = IntervalJoinUtil.getIntervalStart(buildAccessor, buildTupleIndex, this.idBuild);
        return buildStart > (probeStart = IntervalJoinUtil.getIntervalStart(probeAccessor, probeTupleIndex, this.idProbe));
    }

    @Override
    public boolean checkToSaveInResult(IFrameTupleAccessor buildAccessor, int buildTupleIndex, IFrameTupleAccessor probeAccessor, int probeTupleIndex) throws HyracksDataException {
        IntervalJoinUtil.getIntervalPointable(buildAccessor, buildTupleIndex, this.idBuild, this.ipBuild);
        IntervalJoinUtil.getIntervalPointable(probeAccessor, probeTupleIndex, this.idProbe, this.ipProbe);
        return this.compareInterval(this.ipBuild, this.ipProbe);
    }

    @Override
    public boolean checkForEarlyExit(IFrameTupleAccessor buildAccessor, int buildTupleIndex, IFrameTupleAccessor probeAccessor, int probeTupleIndex) {
        long probeStart;
        long buildEnd = IntervalJoinUtil.getIntervalEnd(buildAccessor, buildTupleIndex, this.idBuild);
        return buildEnd < (probeStart = IntervalJoinUtil.getIntervalStart(probeAccessor, probeTupleIndex, this.idProbe));
    }

    @Override
    public abstract boolean compareInterval(AIntervalPointable var1, AIntervalPointable var2) throws HyracksDataException;

    @Override
    public boolean checkToLoadNextProbeTuple(IFrameTupleAccessor buildAccessor, int buildTupleIndex, IFrameTupleAccessor probeAccessor, int probeTupleIndex) {
        long probeStart;
        long buildEnd = IntervalJoinUtil.getIntervalEnd(buildAccessor, buildTupleIndex, this.idBuild);
        return buildEnd > (probeStart = IntervalJoinUtil.getIntervalStart(probeAccessor, probeTupleIndex, this.idProbe));
    }
}

