/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors;

import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.BroadcastExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.StatefulFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;

public class BroadcastSideSwitchingVisitor
implements ILogicalExpressionVisitor<ILogicalExpression, Void> {
    private static BroadcastSideSwitchingVisitor instance = null;

    private BroadcastSideSwitchingVisitor() {
    }

    public static BroadcastSideSwitchingVisitor getInstance() {
        if (instance == null) {
            instance = new BroadcastSideSwitchingVisitor();
        }
        return instance;
    }

    @Override
    public ILogicalExpression visitConstantExpression(ConstantExpression expr, Void arg) {
        return null;
    }

    @Override
    public ILogicalExpression visitVariableReferenceExpression(VariableReferenceExpression expr, Void arg) {
        return null;
    }

    @Override
    public ILogicalExpression visitAggregateFunctionCallExpression(AggregateFunctionCallExpression expr, Void arg) {
        return null;
    }

    @Override
    public ILogicalExpression visitScalarFunctionCallExpression(ScalarFunctionCallExpression expr, Void arg) throws AlgebricksException {
        BroadcastExpressionAnnotation bcastAnn;
        FunctionIdentifier fi = expr.getFunctionIdentifier();
        if (fi.equals(AlgebricksBuiltinFunctions.AND)) {
            for (Mutable<ILogicalExpression> a : expr.getArguments()) {
                ((ILogicalExpression)a.getValue()).accept(this, null);
            }
        }
        if ((bcastAnn = expr.removeAnnotation(BroadcastExpressionAnnotation.class)) != null && bcastAnn.getBroadcastSide() != null) {
            BroadcastExpressionAnnotation.BroadcastSide oppositeSide = BroadcastExpressionAnnotation.BroadcastSide.getOppositeSide(bcastAnn.getBroadcastSide());
            expr.putAnnotation(new BroadcastExpressionAnnotation(oppositeSide));
        }
        return null;
    }

    @Override
    public ILogicalExpression visitStatefulFunctionCallExpression(StatefulFunctionCallExpression expr, Void arg) {
        return null;
    }

    @Override
    public ILogicalExpression visitUnnestingFunctionCallExpression(UnnestingFunctionCallExpression expr, Void arg) {
        return null;
    }
}

