/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.http;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.input.record.reader.http.HttpServerRecordReader;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.http.server.HttpServerConfigBuilder;

public class HttpServerRecordReaderFactory
implements IRecordReaderFactory<char[]> {
    private static final long serialVersionUID = -66399726369366305L;
    private static final String KEY_CONFIGURATION_ADDRESSES = "addresses";
    private static final String KEY_CONFIGURATION_PATH = "path";
    private static final String KEY_CONFIGURATION_QUEUE_SIZE = "queue_size";
    private static final List<String> recordReaderNames = Collections.singletonList("http_adapter");
    private String entryPoint;
    private String addrValue;
    private int queueSize;
    private Map<String, String> configurations;
    private List<Pair<String, Integer>> serverAddrs;

    @Override
    public IRecordReader<? extends char[]> createRecordReader(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        try {
            return new HttpServerRecordReader((Integer)this.serverAddrs.get(partition).getRight(), this.entryPoint, this.queueSize, HttpServerConfigBuilder.createDefault());
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public Class<?> getRecordClass() {
        return char[].class;
    }

    @Override
    public List<String> getRecordReaderNames() {
        return recordReaderNames;
    }

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() {
        return FeedUtils.addressToAbsolutePartitionConstraints(this.serverAddrs);
    }

    private String getConfigurationValue(String key, boolean required) throws CompilationException {
        String value = this.configurations.get(key);
        if (value == null && required) {
            throw new CompilationException("Required configuration missing: " + key);
        }
        return value;
    }

    @Override
    public void configure(IServiceContext ctx, Map<String, String> configuration, IWarningCollector warningCollector) throws AlgebricksException {
        this.configurations = configuration;
        this.addrValue = this.getConfigurationValue(KEY_CONFIGURATION_ADDRESSES, true);
        this.serverAddrs = FeedUtils.extractHostsPorts(this.getConfigurationValue("address-type", true), ctx, this.addrValue);
        String queueSizeStr = this.getConfigurationValue(KEY_CONFIGURATION_QUEUE_SIZE, false);
        this.queueSize = queueSizeStr == null ? 0 : Integer.valueOf(queueSizeStr);
        this.entryPoint = this.getConfigurationValue(KEY_CONFIGURATION_PATH, false);
    }
}

